/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.client.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class WaystoneButton
extends Button {
    private static final ResourceLocation ENCHANTMENT_TABLE_GUI_TEXTURE = new ResourceLocation("textures/gui/container/enchanting_table.png");
    private final int xpLevelCost;

    public WaystoneButton(int x, int y, IWaystone waystone, int xpLevelCost, Button.OnPress pressable) {
        super(x, y, 200, 20, WaystoneButton.getWaystoneNameComponent(waystone), pressable, Button.f_252438_);
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        this.xpLevelCost = xpLevelCost;
        if (player == null || !PlayerWaystoneManager.mayTeleportToWaystone((Player)player, waystone)) {
            this.f_93623_ = false;
        } else if (player.f_36078_ < xpLevelCost && !player.m_150110_().f_35937_) {
            this.f_93623_ = false;
        }
    }

    private static Component getWaystoneNameComponent(IWaystone waystone) {
        String effectiveName = waystone.getName();
        if (effectiveName.isEmpty()) {
            effectiveName = I18n.m_118938_((String)"gui.waystones.waystone_selection.unnamed_waystone", (Object[])new Object[0]);
        }
        MutableComponent textComponent = Component.m_237113_((String)effectiveName);
        if (waystone.isGlobal()) {
            textComponent.m_130940_(ChatFormatting.YELLOW);
        }
        return textComponent;
    }

    public void m_87963_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        super.m_87963_(poseStack, mouseX, mouseY, partialTicks);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft mc = Minecraft.m_91087_();
        if (this.xpLevelCost > 0) {
            boolean canAfford = Objects.requireNonNull(mc.f_91074_).f_36078_ >= this.xpLevelCost || mc.f_91074_.m_150110_().f_35937_;
            RenderSystem.m_157456_((int)0, (ResourceLocation)ENCHANTMENT_TABLE_GUI_TEXTURE);
            WaystoneButton.m_93228_((PoseStack)poseStack, (int)(this.m_252754_() + 2), (int)(this.m_252907_() + 2), (int)((Math.min(this.xpLevelCost, 3) - 1) * 16), (int)(223 + (!canAfford ? 16 : 0)), (int)16, (int)16);
            if (this.xpLevelCost > 3) {
                mc.f_91062_.m_92883_(poseStack, "+", (float)(this.m_252754_() + 17), (float)(this.m_252907_() + 6), 0xC8FF8F);
            }
            if (this.f_93622_ && mouseX <= this.m_252754_() + 16) {
                ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
                MutableComponent levelRequirementText = Component.m_237110_((String)"gui.waystones.waystone_selection.level_requirement", (Object[])new Object[]{this.xpLevelCost});
                levelRequirementText.m_130940_(canAfford ? ChatFormatting.GREEN : ChatFormatting.RED);
                tooltip.add(levelRequirementText);
                Screen screen = Minecraft.m_91087_().f_91080_;
                Optional optional = Optional.empty();
                Objects.requireNonNull(mc.f_91062_);
                Objects.requireNonNull(screen).m_169388_(poseStack, tooltip, optional, mouseX, mouseY + 9);
            }
        }
    }
}

