/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones;

import com.mojang.datafixers.util.Either;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.waystones.api.IAttunementItem;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.api.IWaystoneTeleportContext;
import net.blay09.mods.waystones.api.InternalMethods;
import net.blay09.mods.waystones.api.WaystoneStyle;
import net.blay09.mods.waystones.api.WaystoneTeleportError;
import net.blay09.mods.waystones.api.WaystonesAPI;
import net.blay09.mods.waystones.block.ModBlocks;
import net.blay09.mods.waystones.block.WaystoneBlock;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.blay09.mods.waystones.config.WaystonesConfigData;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.core.WarpMode;
import net.blay09.mods.waystones.core.WaystoneManager;
import net.blay09.mods.waystones.core.WaystoneTeleportContext;
import net.blay09.mods.waystones.core.WaystoneTeleportManager;
import net.blay09.mods.waystones.item.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class InternalMethodsImpl
implements InternalMethods {
    @Override
    public Either<IWaystoneTeleportContext, WaystoneTeleportError> createDefaultTeleportContext(Entity entity, IWaystone waystone, WarpMode warpMode, @Nullable IWaystone fromWaystone) {
        return WaystonesAPI.createCustomTeleportContext(entity, waystone).ifLeft(context -> {
            context.setWarpMode(warpMode);
            WaystonesConfigData.TransportPets shouldTransportPets = WaystonesConfig.getActive().restrictions.transportPets;
            if (shouldTransportPets == WaystonesConfigData.TransportPets.ENABLED || shouldTransportPets == WaystonesConfigData.TransportPets.SAME_DIMENSION && !context.isDimensionalTeleport()) {
                context.getAdditionalEntities().addAll(WaystoneTeleportManager.findPets(entity));
            }
            context.getLeashedEntities().addAll(WaystoneTeleportManager.findLeashedAnimals(entity));
            context.setFromWaystone(fromWaystone);
            context.setWarpItem(PlayerWaystoneManager.findWarpItem(entity, warpMode));
            context.setCooldown(PlayerWaystoneManager.getCooldownPeriod(warpMode, waystone));
            context.setExperienceCost(WaystoneTeleportManager.getExperienceLevelCost(context));
        });
    }

    @Override
    public Either<IWaystoneTeleportContext, WaystoneTeleportError> createCustomTeleportContext(Entity entity, IWaystone waystone) {
        if (!waystone.isValid()) {
            return Either.right((Object)new WaystoneTeleportError.InvalidWaystone(waystone));
        }
        MinecraftServer server = entity.m_20194_();
        if (server == null) {
            return Either.right((Object)new WaystoneTeleportError.NotOnServer());
        }
        ServerLevel targetLevel = server.m_129880_(waystone.getDimension());
        if (targetLevel == null) {
            return Either.right((Object)new WaystoneTeleportError.InvalidDimension(waystone.getDimension()));
        }
        if (!waystone.isValidInLevel(targetLevel)) {
            return Either.right((Object)new WaystoneTeleportError.MissingWaystone(waystone));
        }
        return Either.left((Object)new WaystoneTeleportContext(entity, waystone, waystone.resolveDestination(targetLevel)));
    }

    @Override
    public Either<List<Entity>, WaystoneTeleportError> tryTeleportToWaystone(Entity entity, IWaystone waystone, WarpMode warpMode, IWaystone fromWaystone) {
        return WaystoneTeleportManager.tryTeleportToWaystone(entity, waystone, warpMode, fromWaystone);
    }

    @Override
    public Either<List<Entity>, WaystoneTeleportError> tryTeleport(IWaystoneTeleportContext context) {
        return WaystoneTeleportManager.tryTeleport(context);
    }

    @Override
    public Either<List<Entity>, WaystoneTeleportError> forceTeleportToWaystone(Entity entity, IWaystone waystone) {
        return this.createDefaultTeleportContext(entity, waystone, WarpMode.CUSTOM, null).mapLeft(this::forceTeleport);
    }

    @Override
    public List<Entity> forceTeleport(IWaystoneTeleportContext context) {
        return WaystoneTeleportManager.doTeleport(context);
    }

    @Override
    public Optional<IWaystone> getWaystoneAt(Level level, BlockPos pos) {
        return WaystoneManager.get(level.m_7654_()).getWaystoneAt((BlockGetter)level, pos);
    }

    @Override
    public Optional<IWaystone> getWaystone(Level level, UUID uuid) {
        return WaystoneManager.get(level.m_7654_()).getWaystoneById(uuid);
    }

    @Override
    public ItemStack createAttunedShard(IWaystone warpPlate) {
        ItemStack itemStack = new ItemStack((ItemLike)ModItems.attunedShard);
        this.setBoundWaystone(itemStack, warpPlate);
        return itemStack;
    }

    @Override
    public ItemStack createBoundScroll(IWaystone waystone) {
        ItemStack itemStack = new ItemStack((ItemLike)ModItems.boundScroll);
        this.setBoundWaystone(itemStack, waystone);
        return itemStack;
    }

    @Override
    public Optional<IWaystone> placeWaystone(Level level, BlockPos pos, WaystoneStyle style) {
        Block block = Balm.getRegistries().getBlock(style.getBlockRegistryName());
        level.m_7731_(pos, (BlockState)block.m_49966_().m_61124_((Property)WaystoneBlock.HALF, (Comparable)DoubleBlockHalf.LOWER), 3);
        level.m_7731_(pos.m_7494_(), (BlockState)block.m_49966_().m_61124_((Property)WaystoneBlock.HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
        return this.getWaystoneAt(level, pos);
    }

    @Override
    public Optional<IWaystone> placeSharestone(Level level, BlockPos pos, @Nullable DyeColor color) {
        Block sharestone = color != null ? ModBlocks.scopedSharestones[color.ordinal()] : ModBlocks.sharestone;
        level.m_7731_(pos, (BlockState)sharestone.m_49966_().m_61124_((Property)WaystoneBlock.HALF, (Comparable)DoubleBlockHalf.LOWER), 3);
        level.m_7731_(pos.m_7494_(), (BlockState)sharestone.m_49966_().m_61124_((Property)WaystoneBlock.HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
        return this.getWaystoneAt(level, pos);
    }

    @Override
    public Optional<IWaystone> placeWarpPlate(Level level, BlockPos pos) {
        level.m_7731_(pos, ModBlocks.warpPlate.m_49966_(), 3);
        return this.getWaystoneAt(level, pos);
    }

    @Override
    public Optional<IWaystone> getBoundWaystone(ItemStack itemStack) {
        Item item = itemStack.m_41720_();
        if (item instanceof IAttunementItem) {
            IAttunementItem attunementItem = (IAttunementItem)item;
            return Optional.ofNullable(attunementItem.getWaystoneAttunedTo(Balm.getHooks().getServer(), itemStack));
        }
        return Optional.empty();
    }

    @Override
    public void setBoundWaystone(ItemStack itemStack, @Nullable IWaystone waystone) {
        Item item = itemStack.m_41720_();
        if (item instanceof IAttunementItem) {
            IAttunementItem attunementItem = (IAttunementItem)item;
            attunementItem.setWaystoneAttunedTo(itemStack, waystone);
        }
    }
}

