/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.block.entity;

import java.util.Collection;
import net.blay09.mods.balm.api.menu.BalmMenuProvider;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.api.WaystoneOrigin;
import net.blay09.mods.waystones.api.WaystoneTypes;
import net.blay09.mods.waystones.block.SharestoneBlock;
import net.blay09.mods.waystones.block.entity.ModBlockEntities;
import net.blay09.mods.waystones.block.entity.WaystoneBlockEntityBase;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.core.WarpMode;
import net.blay09.mods.waystones.core.Waystone;
import net.blay09.mods.waystones.core.WaystoneSyncManager;
import net.blay09.mods.waystones.menu.ModMenus;
import net.blay09.mods.waystones.menu.WaystoneSelectionMenu;
import net.blay09.mods.waystones.menu.WaystoneSettingsMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class SharestoneBlockEntity
extends WaystoneBlockEntityBase {
    public SharestoneBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.sharestone.get(), pos, state);
    }

    @Override
    protected ResourceLocation getWaystoneType() {
        return WaystoneTypes.getSharestone(((SharestoneBlock)this.m_58900_().m_60734_()).getColor());
    }

    @Override
    public void initializeWaystone(ServerLevelAccessor world, @Nullable LivingEntity player, WaystoneOrigin origin) {
        super.initializeWaystone(world, player, origin);
        WaystoneSyncManager.sendWaystoneUpdateToAll(world.m_7654_(), this.getWaystone());
    }

    @Override
    public MenuProvider getMenuProvider() {
        return new BalmMenuProvider(){

            public Component m_5446_() {
                return Component.m_237115_((String)"container.waystones.waystone_selection");
            }

            public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player player) {
                IWaystone fromWaystone = SharestoneBlockEntity.this.getWaystone();
                Collection<IWaystone> waystones = PlayerWaystoneManager.getTargetsForWaystone(player, fromWaystone);
                PlayerWaystoneManager.ensureSortingIndex(player, waystones);
                return new WaystoneSelectionMenu((MenuType<WaystoneSelectionMenu>)((MenuType)ModMenus.sharestoneSelection.get()), WarpMode.SHARESTONE_TO_SHARESTONE, fromWaystone, windowId, waystones);
            }

            public void writeScreenOpeningData(ServerPlayer player, FriendlyByteBuf buf) {
                buf.m_130064_(SharestoneBlockEntity.this.f_58858_);
                Waystone.writeList(buf, PlayerWaystoneManager.getTargetsForWaystone((Player)player, SharestoneBlockEntity.this.getWaystone()));
            }
        };
    }

    public BalmMenuProvider getSettingsMenuProvider() {
        return new BalmMenuProvider(){

            public Component m_5446_() {
                return Component.m_237115_((String)"container.waystones.sharestone");
            }

            public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player playerEntity) {
                return new WaystoneSettingsMenu(windowId, SharestoneBlockEntity.this.getWaystone(), SharestoneBlockEntity.this, SharestoneBlockEntity.this.dataAccess, playerInventory);
            }

            public void writeScreenOpeningData(ServerPlayer player, FriendlyByteBuf buf) {
                buf.m_130064_(SharestoneBlockEntity.this.f_58858_);
                Waystone.write(buf, SharestoneBlockEntity.this.getWaystone());
            }
        };
    }
}

