/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.client.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import net.blay09.mods.waystones.api.ExperienceCost;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.api.WaystoneTypes;
import net.blay09.mods.waystones.api.WaystoneVisibility;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class WaystoneButton
extends Button {
    private static final ResourceLocation[] ENABLED_LEVEL_SPRITES = new ResourceLocation[]{new ResourceLocation("container/enchanting_table/level_1"), new ResourceLocation("container/enchanting_table/level_2"), new ResourceLocation("container/enchanting_table/level_3")};
    private static final ResourceLocation[] DISABLED_LEVEL_SPRITES = new ResourceLocation[]{new ResourceLocation("container/enchanting_table/level_1_disabled"), new ResourceLocation("container/enchanting_table/level_2_disabled"), new ResourceLocation("container/enchanting_table/level_3_disabled")};
    private final ExperienceCost xpCost;
    private final IWaystone waystone;

    public WaystoneButton(int x, int y, IWaystone waystone, ExperienceCost xpCost, Button.OnPress pressable) {
        super(x, y, 200, 20, WaystoneButton.getWaystoneNameComponent(waystone), pressable, Button.f_252438_);
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        this.xpCost = xpCost;
        this.waystone = waystone;
        if (player == null || !PlayerWaystoneManager.mayTeleportToWaystone((Player)player, waystone)) {
            this.f_93623_ = false;
        } else if (!xpCost.canAfford((Player)player) && !player.m_150110_().f_35937_) {
            this.f_93623_ = false;
        }
    }

    private static Component getWaystoneNameComponent(IWaystone waystone) {
        String effectiveName = waystone.getName();
        if (effectiveName.isEmpty()) {
            effectiveName = I18n.m_118938_((String)"gui.waystones.waystone_selection.unnamed_waystone", (Object[])new Object[0]);
        }
        MutableComponent textComponent = Component.m_237113_((String)effectiveName);
        if (waystone.getVisibility() == WaystoneVisibility.GLOBAL && waystone.getWaystoneType().equals((Object)WaystoneTypes.WAYSTONE)) {
            textComponent.m_130940_(ChatFormatting.YELLOW);
        }
        return textComponent;
    }

    public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.m_87963_(guiGraphics, mouseX, mouseY, partialTicks);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft mc = Minecraft.m_91087_();
        if (this.waystone.getDimension() == mc.f_91074_.m_9236_().m_46472_() && this.m_142518_()) {
            int distance = (int)mc.f_91074_.m_20182_().m_82554_(this.waystone.getPos().m_252807_());
            String distanceStr = distance < 10000 && (mc.f_91062_.m_92852_((FormattedText)this.m_6035_()) < 120 || distance < 1000) ? distance + "m" : String.format("%.1f", Float.valueOf((float)distance / 1000.0f)).replace(",0", "").replace(".0", "") + "km";
            int xOffset = this.m_5711_() - mc.f_91062_.m_92895_(distanceStr);
            guiGraphics.m_280488_(mc.f_91062_, distanceStr, this.m_252754_() + xOffset - 4, this.m_252907_() + 6, 0xFFFFFF);
        }
        if (!this.xpCost.isEmpty()) {
            boolean canAfford = this.xpCost.canAfford((Player)mc.f_91074_);
            int xpCostAsLevels = this.xpCost.getCostAsLevels((Player)mc.f_91074_);
            int spriteIndex = Math.max(0, Math.min(xpCostAsLevels, 3) - 1);
            guiGraphics.m_292816_(canAfford ? ENABLED_LEVEL_SPRITES[spriteIndex] : DISABLED_LEVEL_SPRITES[spriteIndex], this.m_252754_() + 2, this.m_252907_() + 2, 16, 16);
            if (xpCostAsLevels > 3) {
                guiGraphics.m_280488_(mc.f_91062_, "+", this.m_252754_() + 17, this.m_252907_() + 6, 0xC8FF8F);
            }
            if (this.f_93622_ && mouseX <= this.m_252754_() + 16) {
                ArrayList<Component> tooltip = new ArrayList<Component>();
                Component xpCostText = this.xpCost.getCostAsTooltip((Player)mc.f_91074_);
                if (xpCostText instanceof MutableComponent) {
                    MutableComponent mutableComponent = (MutableComponent)xpCostText;
                    mutableComponent.m_130940_(canAfford ? ChatFormatting.GREEN : ChatFormatting.RED);
                }
                tooltip.add(xpCostText);
                Font font = mc.f_91062_;
                Optional optional = Optional.empty();
                Objects.requireNonNull(mc.f_91062_);
                guiGraphics.m_280677_(font, tooltip, optional, mouseX, mouseY + 9);
            }
        }
    }
}

