/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import java.util.List;
import net.blay09.mods.balm.api.command.BalmCommands;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.command.CountWaystonesCommand;
import net.blay09.mods.waystones.command.OpenPlayerWaystonesGuiCommand;
import net.blay09.mods.waystones.comparator.WaystoneComparators;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class ModCommands {
    public static void initialize(BalmCommands commands) {
        commands.register(dispatcher -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"waystones").requires(source -> source.m_230897_() && source.m_6761_(2))).then(Commands.m_82127_((String)"count").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes((Command)new CountWaystonesCommand())))).then(Commands.m_82127_((String)"list").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(ctx -> {
            ServerPlayer caller = ((CommandSourceStack)ctx.getSource()).m_81375_();
            ServerPlayer target = ((EntitySelector)ctx.getArgument("player", EntitySelector.class)).m_121163_((CommandSourceStack)ctx.getSource());
            List<IWaystone> waystones = PlayerWaystoneManager.getActivatedWaystones((Player)target).stream().filter(it -> it.isOwner((Player)target)).sorted(WaystoneComparators.forAdminInspection((Player)caller, (Player)target)).toList();
            ((CommandSourceStack)ctx.getSource()).m_243053_((Component)Component.m_237110_((String)"commands.waystones.list.header", (Object[])new Object[]{target.m_6302_()}));
            for (IWaystone waystone : waystones) {
                ((CommandSourceStack)ctx.getSource()).m_243053_(ModCommands.componentForWaystoneList(caller, target, waystone));
            }
            MutableComponent result = Component.m_237110_((String)"commands.waystones.list.footer", (Object[])new Object[]{waystones.size()});
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> result, false);
            return waystones.size();
        })).then(Commands.m_82127_((String)"all").executes(ctx -> {
            ServerPlayer caller = ((CommandSourceStack)ctx.getSource()).m_81375_();
            ServerPlayer target = ((EntitySelector)ctx.getArgument("player", EntitySelector.class)).m_121163_((CommandSourceStack)ctx.getSource());
            List<IWaystone> waystones = PlayerWaystoneManager.getActivatedWaystones((Player)target).stream().sorted(WaystoneComparators.forAdminInspection((Player)caller, (Player)target)).toList();
            ((CommandSourceStack)ctx.getSource()).m_243053_((Component)Component.m_237110_((String)"commands.waystones.list.all.header", (Object[])new Object[]{target.m_6302_()}));
            for (IWaystone waystone : waystones) {
                ((CommandSourceStack)ctx.getSource()).m_243053_(ModCommands.componentForWaystoneList(caller, target, waystone));
            }
            long ownedCount = waystones.stream().filter(it -> it.isOwner((Player)target)).count();
            MutableComponent result = Component.m_237110_((String)"commands.waystones.list.all.footer", (Object[])new Object[]{waystones.size(), ownedCount});
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> result, false);
            return waystones.size();
        }))))).then(Commands.m_82127_((String)"gui").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes((Command)new OpenPlayerWaystonesGuiCommand())))));
    }

    private static Component componentForWaystoneList(ServerPlayer caller, ServerPlayer target, IWaystone waystone) {
        MutableComponent location;
        ResourceLocation waystoneDimensionId = waystone.getDimension().m_135782_();
        BlockPos waystonePos = waystone.getPos();
        if (waystone.getDimension() != caller.m_9236_().m_46472_()) {
            location = Component.m_237110_((String)"commands.waystones.list.in_dimension", (Object[])new Object[]{waystoneDimensionId});
        } else {
            int distance = (int)caller.m_20182_().m_82554_(waystonePos.m_252807_());
            location = Component.m_237110_((String)"commands.waystones.list.at_distance", (Object[])new Object[]{distance});
        }
        String suggestedCommand = String.format("/execute in %s run teleport %d %d %d", waystoneDimensionId, waystonePos.m_123341_(), waystonePos.m_123342_(), waystonePos.m_123343_());
        MutableComponent coordinates = Component.m_237110_((String)"commands.waystones.list.coordinates", (Object[])new Object[]{waystonePos.m_123341_(), waystonePos.m_123342_(), waystonePos.m_123343_()}).m_130940_(ChatFormatting.YELLOW).m_130948_(Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, suggestedCommand)));
        MutableComponent waystoneName = Component.m_237113_((String)waystone.getName()).m_130940_(ChatFormatting.GREEN).m_130948_(Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, suggestedCommand)));
        String entryKey = waystone.isOwner((Player)target) ? "commands.waystones.list.entry.owned" : "commands.waystones.list.entry.activated";
        return Component.m_237110_((String)entryKey, (Object[])new Object[]{location, coordinates, waystoneName});
    }
}

