/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.core.IPlayerWaystoneData;
import net.blay09.mods.waystones.core.WaystoneProxy;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;

public class PersistentPlayerWaystoneData
implements IPlayerWaystoneData {
    private static final String TAG_NAME = "WaystonesData";
    private static final String ACTIVATED_WAYSTONES = "Waystones";
    private static final String SORTING_INDEX = "SortingIndex";
    private static final String INVENTORY_BUTTON_COOLDOWN_UNTIL = "InventoryButtonCooldownUntilUnix";
    private static final String WARP_STONE_COOLDOWN_UNTIL = "WarpStoneCooldownUntilUnix";

    @Override
    public void activateWaystone(Player player, IWaystone waystone) {
        ListTag activatedWaystonesData = PersistentPlayerWaystoneData.getActivatedWaystonesData(PersistentPlayerWaystoneData.getWaystonesData(player));
        activatedWaystonesData.add((Object)StringTag.m_129297_((String)waystone.getWaystoneUid().toString()));
    }

    @Override
    public boolean isWaystoneActivated(Player player, IWaystone waystone) {
        ListTag activatedWaystones = PersistentPlayerWaystoneData.getActivatedWaystonesData(PersistentPlayerWaystoneData.getWaystonesData(player));
        String waystoneUid = waystone.getWaystoneUid().toString();
        for (Tag activatedWaystone : activatedWaystones) {
            if (!waystoneUid.equals(activatedWaystone.m_7916_())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<IWaystone> getWaystones(Player player) {
        ListTag activatedWaystonesTag = PersistentPlayerWaystoneData.getActivatedWaystonesData(PersistentPlayerWaystoneData.getWaystonesData(player));
        ArrayList<IWaystone> waystones = new ArrayList<IWaystone>();
        Iterator iterator = activatedWaystonesTag.iterator();
        while (iterator.hasNext()) {
            Tag activatedWaystoneTag = (Tag)iterator.next();
            WaystoneProxy proxy = new WaystoneProxy(player.m_20194_(), UUID.fromString(activatedWaystoneTag.m_7916_()));
            if (proxy.isValid()) {
                waystones.add(proxy);
                continue;
            }
            iterator.remove();
        }
        return waystones;
    }

    @Override
    public List<UUID> getSortingIndex(Player player) {
        ListTag sortingIndex = PersistentPlayerWaystoneData.getSortingIndexData(PersistentPlayerWaystoneData.getWaystonesData(player));
        return sortingIndex.stream().map(entry -> UUID.fromString(entry.m_7916_())).toList();
    }

    @Override
    public void setSortingIndex(Player player, List<UUID> sortingIndex) {
        ListTag sortingIndexData = PersistentPlayerWaystoneData.getSortingIndexData(PersistentPlayerWaystoneData.getWaystonesData(player));
        sortingIndexData.clear();
        for (UUID waystoneUid : sortingIndex) {
            sortingIndexData.add((Object)StringTag.m_129297_((String)waystoneUid.toString()));
        }
    }

    @Override
    public List<UUID> ensureSortingIndex(Player player, Collection<IWaystone> waystones) {
        UUID waystoneUid;
        ListTag sortingIndexData = PersistentPlayerWaystoneData.getSortingIndexData(PersistentPlayerWaystoneData.getWaystonesData(player));
        ArrayList<UUID> sortingIndex = new ArrayList<UUID>();
        HashSet<UUID> existing = new HashSet<UUID>();
        for (Tag sortingIndexEntry : sortingIndexData) {
            waystoneUid = UUID.fromString(sortingIndexEntry.m_7916_());
            if (!existing.add(waystoneUid)) continue;
            sortingIndex.add(waystoneUid);
        }
        for (IWaystone waystone : waystones) {
            waystoneUid = waystone.getWaystoneUid();
            if (existing.contains(waystoneUid)) continue;
            sortingIndex.add(waystoneUid);
            sortingIndexData.add((Object)StringTag.m_129297_((String)waystoneUid.toString()));
        }
        return sortingIndex;
    }

    @Override
    public void sortWaystoneAsFirst(Player player, UUID waystoneUid) {
        ListTag sortingIndex = PersistentPlayerWaystoneData.getSortingIndexData(PersistentPlayerWaystoneData.getWaystonesData(player));
        for (int i = 0; i < sortingIndex.size(); ++i) {
            Tag sortingIndexEntry = sortingIndex.get(i);
            if (!waystoneUid.toString().equals(sortingIndexEntry.m_7916_())) continue;
            sortingIndex.remove(i);
            sortingIndex.add(0, sortingIndexEntry);
            break;
        }
    }

    @Override
    public void sortWaystoneAsLast(Player player, UUID waystoneUid) {
        ListTag sortingIndex = PersistentPlayerWaystoneData.getSortingIndexData(PersistentPlayerWaystoneData.getWaystonesData(player));
        for (int i = 0; i < sortingIndex.size(); ++i) {
            Tag sortingIndexEntry = sortingIndex.get(i);
            if (!waystoneUid.toString().equals(sortingIndexEntry.m_7916_())) continue;
            sortingIndex.remove(i);
            sortingIndex.add((Object)sortingIndexEntry);
            break;
        }
    }

    @Override
    public void sortWaystoneSwap(Player player, UUID waystoneUid, UUID otherWaystoneUid) {
        ListTag sortingIndex = PersistentPlayerWaystoneData.getSortingIndexData(PersistentPlayerWaystoneData.getWaystonesData(player));
        int waystoneIndex = -1;
        int otherWaystoneIndex = -1;
        for (int i = 0; i < sortingIndex.size(); ++i) {
            Tag sortingIndexEntry = sortingIndex.get(i);
            if (waystoneUid.toString().equals(sortingIndexEntry.m_7916_())) {
                waystoneIndex = i;
                continue;
            }
            if (!otherWaystoneUid.toString().equals(sortingIndexEntry.m_7916_())) continue;
            otherWaystoneIndex = i;
        }
        if (waystoneIndex != -1 && otherWaystoneIndex != -1) {
            Collections.swap(sortingIndex, waystoneIndex, otherWaystoneIndex);
        }
    }

    @Override
    public void deactivateWaystone(Player player, IWaystone waystone) {
        CompoundTag data = PersistentPlayerWaystoneData.getWaystonesData(player);
        ListTag activatedWaystones = PersistentPlayerWaystoneData.getActivatedWaystonesData(data);
        String waystoneUid = waystone.getWaystoneUid().toString();
        for (int i = activatedWaystones.size() - 1; i >= 0; --i) {
            Tag activatedWaystone = activatedWaystones.get(i);
            if (!waystoneUid.equals(activatedWaystone.m_7916_())) continue;
            activatedWaystones.remove(i);
            break;
        }
    }

    @Override
    public long getWarpStoneCooldownUntil(Player player) {
        return PersistentPlayerWaystoneData.getWaystonesData(player).m_128454_(WARP_STONE_COOLDOWN_UNTIL);
    }

    @Override
    public void setWarpStoneCooldownUntil(Player player, long timeStamp) {
        PersistentPlayerWaystoneData.getWaystonesData(player).m_128356_(WARP_STONE_COOLDOWN_UNTIL, timeStamp);
    }

    @Override
    public long getInventoryButtonCooldownUntil(Player player) {
        return PersistentPlayerWaystoneData.getWaystonesData(player).m_128454_(INVENTORY_BUTTON_COOLDOWN_UNTIL);
    }

    @Override
    public void setInventoryButtonCooldownUntil(Player player, long timeStamp) {
        PersistentPlayerWaystoneData.getWaystonesData(player).m_128356_(INVENTORY_BUTTON_COOLDOWN_UNTIL, timeStamp);
    }

    private static ListTag getActivatedWaystonesData(CompoundTag data) {
        ListTag list = data.m_128437_(ACTIVATED_WAYSTONES, 8);
        data.m_128365_(ACTIVATED_WAYSTONES, (Tag)list);
        return list;
    }

    private static ListTag getSortingIndexData(CompoundTag data) {
        ListTag list = data.m_128441_(SORTING_INDEX) ? data.m_128437_(SORTING_INDEX, 8) : PersistentPlayerWaystoneData.createSortingIndexFromLegacy(data);
        data.m_128365_(SORTING_INDEX, (Tag)list);
        return list;
    }

    private static CompoundTag getWaystonesData(Player player) {
        CompoundTag persistedData = Balm.getHooks().getPersistentData(player);
        CompoundTag compound = persistedData.m_128469_(TAG_NAME);
        persistedData.m_128365_(TAG_NAME, (Tag)compound);
        return compound;
    }

    private static ListTag createSortingIndexFromLegacy(CompoundTag data) {
        ListTag activatedWaystones = PersistentPlayerWaystoneData.getActivatedWaystonesData(data);
        if (activatedWaystones.isEmpty()) {
            return new ListTag();
        }
        ListTag sortingIndex = new ListTag();
        sortingIndex.addAll((Collection)activatedWaystones);
        return sortingIndex;
    }
}

