/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.core;

import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.api.WaystoneTypes;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.core.WaystoneManager;
import net.blay09.mods.waystones.network.message.KnownWaystonesMessage;
import net.blay09.mods.waystones.network.message.PlayerWaystoneCooldownsMessage;
import net.blay09.mods.waystones.network.message.SortingIndexMessage;
import net.blay09.mods.waystones.network.message.UpdateWaystoneMessage;
import net.blay09.mods.waystones.network.message.WaystoneRemovedMessage;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class WaystoneSyncManager {
    public static void sendWaystoneUpdateToAll(@Nullable MinecraftServer server, IWaystone waystone) {
        if (server == null) {
            return;
        }
        List players = server.m_6846_().m_11314_();
        for (ServerPlayer player : players) {
            WaystoneSyncManager.sendWaystoneUpdate((Player)player, waystone);
            WaystoneSyncManager.sendActivatedWaystones((Player)player);
        }
    }

    public static void sendWaystoneRemovalToAll(@Nullable MinecraftServer server, IWaystone waystone, boolean wasDestroyed) {
        if (server == null) {
            return;
        }
        List players = server.m_6846_().m_11314_();
        for (ServerPlayer player : players) {
            WaystoneSyncManager.sendWaystoneRemoval((Player)player, waystone, wasDestroyed);
        }
    }

    public static void sendSortingIndex(Player player) {
        List<UUID> sortingIndex = PlayerWaystoneManager.getSortingIndex(player);
        Balm.getNetworking().sendTo(player, (Object)new SortingIndexMessage(sortingIndex));
    }

    public static void sendActivatedWaystones(Player player) {
        Collection<IWaystone> waystones = PlayerWaystoneManager.getActivatedWaystones(player);
        Balm.getNetworking().sendTo(player, (Object)new KnownWaystonesMessage(WaystoneTypes.WAYSTONE, waystones));
    }

    public static void sendWaystonesOfType(ResourceLocation waystoneType, ServerPlayer player) {
        List<IWaystone> warpPlates = WaystoneManager.get(player.f_8924_).getWaystonesByType(waystoneType).collect(Collectors.toList());
        Balm.getNetworking().sendTo((Player)player, (Object)new KnownWaystonesMessage(waystoneType, warpPlates));
    }

    public static void sendWaystoneUpdate(Player player, IWaystone waystone) {
        if (!waystone.getWaystoneType().equals((Object)WaystoneTypes.WAYSTONE) || PlayerWaystoneManager.isWaystoneActivated(player, waystone)) {
            Balm.getNetworking().sendTo(player, (Object)new UpdateWaystoneMessage(waystone));
        }
    }

    public static void sendWaystoneRemoval(Player player, IWaystone waystone, boolean wasDestroyed) {
        if (!waystone.getWaystoneType().equals((Object)WaystoneTypes.WAYSTONE) || PlayerWaystoneManager.isWaystoneActivated(player, waystone)) {
            Balm.getNetworking().sendTo(player, (Object)new WaystoneRemovedMessage(waystone.getWaystoneType(), waystone.getWaystoneUid(), wasDestroyed));
        }
    }

    public static void sendWaystoneCooldowns(Player player) {
        long inventoryButtonCooldownUntil = PlayerWaystoneManager.getInventoryButtonCooldownUntil(player);
        long warpStoneCooldownUntil = PlayerWaystoneManager.getWarpStoneCooldownUntil(player);
        Balm.getNetworking().sendTo(player, (Object)new PlayerWaystoneCooldownsMessage(inventoryButtonCooldownUntil, warpStoneCooldownUntil));
    }
}

