/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.network.message;

import java.util.UUID;
import net.blay09.mods.waystones.Waystones;
import net.blay09.mods.waystones.api.WaystoneTypes;
import net.blay09.mods.waystones.api.WaystoneVisibility;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.core.Waystone;
import net.blay09.mods.waystones.core.WaystoneEditPermissions;
import net.blay09.mods.waystones.core.WaystoneManager;
import net.blay09.mods.waystones.core.WaystonePermissionManager;
import net.blay09.mods.waystones.core.WaystoneProxy;
import net.blay09.mods.waystones.core.WaystoneSyncManager;
import net.blay09.mods.waystones.menu.WaystoneSettingsMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class EditWaystoneMessage {
    private final UUID waystoneUid;
    private final String name;
    private final WaystoneVisibility visibility;

    public EditWaystoneMessage(UUID waystoneUid, String name, WaystoneVisibility visibility) {
        this.waystoneUid = waystoneUid;
        this.name = name;
        this.visibility = visibility;
    }

    public static void encode(EditWaystoneMessage message, FriendlyByteBuf buf) {
        buf.m_130077_(message.waystoneUid);
        buf.m_130070_(message.name);
        buf.m_130068_((Enum)message.visibility);
    }

    public static EditWaystoneMessage decode(FriendlyByteBuf buf) {
        UUID waystoneUid = buf.m_130259_();
        String name = buf.m_130136_(255);
        WaystoneVisibility visibility = (WaystoneVisibility)buf.m_130066_(WaystoneVisibility.class);
        return new EditWaystoneMessage(waystoneUid, name, visibility);
    }

    public static void handle(ServerPlayer player, EditWaystoneMessage message) {
        WaystoneProxy waystone = new WaystoneProxy(player.f_8924_, message.waystoneUid);
        WaystoneEditPermissions permissions = WaystonePermissionManager.mayEditWaystone((Player)player, player.m_9236_(), waystone);
        if (permissions != WaystoneEditPermissions.ALLOW) {
            return;
        }
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (!(abstractContainerMenu instanceof WaystoneSettingsMenu)) {
            return;
        }
        WaystoneSettingsMenu settingsMenu = (WaystoneSettingsMenu)abstractContainerMenu;
        WaystoneVisibility visibility = message.visibility;
        if (!settingsMenu.getVisibilityOptions().contains((Object)message.visibility)) {
            Waystones.logger.warn("{} tried to edit a waystone with an invalid visibility {}", (Object)player.m_7755_().getString(), (Object)message.visibility);
            visibility = settingsMenu.getVisibilityOptions().get(0);
        }
        if (visibility == WaystoneVisibility.GLOBAL && waystone.getWaystoneType().equals((Object)WaystoneTypes.WAYSTONE) && !PlayerWaystoneManager.mayEditGlobalWaystones((Player)player)) {
            Waystones.logger.warn("{} tried to edit a global waystone without permission", (Object)player.m_7755_().getString());
            return;
        }
        BlockPos pos = waystone.getPos();
        if (player.m_20275_((double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f)) > 64.0) {
            return;
        }
        Waystone backingWaystone = (Waystone)waystone.getBackingWaystone();
        String legalName = EditWaystoneMessage.makeNameLegal(player.f_8924_, message.name);
        backingWaystone.setName(legalName);
        if (PlayerWaystoneManager.mayEditGlobalWaystones((Player)player) && backingWaystone.getVisibility() != WaystoneVisibility.GLOBAL && visibility == WaystoneVisibility.GLOBAL) {
            PlayerWaystoneManager.activeWaystoneForEveryone(player.f_8924_, backingWaystone);
        }
        backingWaystone.setVisibility(visibility);
        WaystoneManager.get(player.f_8924_).m_77762_();
        WaystoneSyncManager.sendWaystoneUpdateToAll(player.f_8924_, backingWaystone);
        player.m_6915_();
    }

    private static String makeNameLegal(MinecraftServer server, String name) {
        String inventoryButtonMode;
        if (name.trim().isEmpty()) {
            name = Component.m_237115_((String)"waystones.untitled_waystone").getString();
        }
        if ((inventoryButtonMode = WaystonesConfig.getActive().inventoryButton.inventoryButton).equals(name) && WaystoneManager.get(server).findWaystoneByName(name).isPresent()) {
            return name + "*";
        }
        return name;
    }
}

