/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.network.message;

import java.util.UUID;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.waystones.api.WaystoneRemoveReceivedEvent;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class WaystoneRemovedMessage {
    private final ResourceLocation waystoneType;
    private final UUID waystoneId;
    private final boolean wasDestroyed;

    public WaystoneRemovedMessage(ResourceLocation waystoneType, UUID waystoneId, boolean wasDestroyed) {
        this.waystoneType = waystoneType;
        this.waystoneId = waystoneId;
        this.wasDestroyed = wasDestroyed;
    }

    public static void encode(WaystoneRemovedMessage message, FriendlyByteBuf buf) {
        buf.m_130085_(message.waystoneType);
        buf.m_130077_(message.waystoneId);
        buf.writeBoolean(message.wasDestroyed);
    }

    public static WaystoneRemovedMessage decode(FriendlyByteBuf buf) {
        return new WaystoneRemovedMessage(buf.m_130281_(), buf.m_130259_(), buf.readBoolean());
    }

    public static void handle(Player player, WaystoneRemovedMessage message) {
        Balm.getEvents().fireEvent((Object)new WaystoneRemoveReceivedEvent(message.waystoneType, message.waystoneId, message.wasDestroyed));
    }
}

