/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Locale;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.block.WaystoneBlockBase;
import net.blay09.mods.waystones.block.entity.ModBlockEntities;
import net.blay09.mods.waystones.block.entity.WarpPlateBlockEntity;
import net.blay09.mods.waystones.block.entity.WaystoneBlockEntityBase;
import net.blay09.mods.waystones.core.WaystoneProxy;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class WarpPlateBlock
extends WaystoneBlockBase {
    public static final MapCodec<WarpPlateBlock> CODEC = WarpPlateBlock.m_306223_(WarpPlateBlock::new);
    private static final Style GALACTIC_STYLE = Style.f_131099_.m_131150_(new ResourceLocation("minecraft", "alt"));
    private static final VoxelShape SHAPE = Shapes.m_83110_((VoxelShape)WarpPlateBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), (VoxelShape)WarpPlateBlock.m_49796_((double)3.0, (double)1.0, (double)3.0, (double)13.0, (double)2.0, (double)13.0)).m_83296_();
    public static final EnumProperty<WarpPlateStatus> STATUS = EnumProperty.m_61587_((String)"status", WarpPlateStatus.class);

    public WarpPlateBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_(STATUS, (Comparable)((Object)WarpPlateStatus.IDLE)));
    }

    @Override
    protected boolean canSilkTouch() {
        return true;
    }

    @Override
    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity tileEntity;
        super.m_6402_(world, pos, state, placer, stack);
        if (stack.m_41788_() && (tileEntity = world.m_7702_(pos)) instanceof WarpPlateBlockEntity) {
            WarpPlateBlockEntity warpPlate = (WarpPlateBlockEntity)tileEntity;
            warpPlate.setCustomName(stack.m_41786_());
        }
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return SHAPE;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{STATUS});
    }

    public void m_7892_(BlockState blockState, Level world, BlockPos pos, Entity entity) {
        BlockEntity tileEntity;
        if (entity.m_20185_() >= (double)pos.m_123341_() && entity.m_20185_() < (double)(pos.m_123341_() + 1) && entity.m_20186_() >= (double)pos.m_123342_() && entity.m_20186_() < (double)(pos.m_123342_() + 1) && entity.m_20189_() >= (double)pos.m_123343_() && entity.m_20189_() < (double)(pos.m_123343_() + 1) && !world.f_46443_ && (tileEntity = world.m_7702_(pos)) instanceof WarpPlateBlockEntity) {
            ((WarpPlateBlockEntity)tileEntity).onEntityCollision(entity);
        }
    }

    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource random) {
        block3: {
            block2: {
                if (state.m_61143_(STATUS) != WarpPlateStatus.ACTIVE) break block2;
                for (int i = 0; i < 50; ++i) {
                    world.m_7106_((ParticleOptions)ParticleTypes.f_123784_, (double)pos.m_123341_() + Math.random(), (double)pos.m_123342_() + Math.random() * 2.0, (double)pos.m_123343_() + Math.random(), 0.0, 0.0, 0.0);
                    world.m_7106_((ParticleOptions)ParticleTypes.f_123760_, (double)pos.m_123341_() + Math.random(), (double)pos.m_123342_() + Math.random() * 2.0, (double)pos.m_123343_() + Math.random(), 0.0, 0.0, 0.0);
                }
                break block3;
            }
            if (state.m_61143_(STATUS) != WarpPlateStatus.INVALID) break block3;
            for (int i = 0; i < 10; ++i) {
                world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)pos.m_123341_() + Math.random(), (double)pos.m_123342_(), (double)pos.m_123343_() + Math.random(), 0.0, (double)0.01f, 0.0);
            }
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new WarpPlateBlockEntity(pos, state);
    }

    @Override
    protected InteractionResult handleActivation(Level world, BlockPos pos, Player player, WaystoneBlockEntityBase tileEntity, Waystone waystone) {
        if (!world.f_46443_) {
            Balm.getNetworking().openGui(player, tileEntity.getMenuProvider());
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    protected void addWaystoneNameToTooltip(List<Component> tooltip, WaystoneProxy waystone) {
        tooltip.add(WarpPlateBlock.getGalacticName(waystone));
    }

    public static ChatFormatting getColorForName(String name) {
        int colorIndex = Math.abs(name.hashCode()) % 15;
        ChatFormatting textFormatting = ChatFormatting.m_126647_((int)colorIndex);
        if (textFormatting == ChatFormatting.GRAY) {
            return ChatFormatting.LIGHT_PURPLE;
        }
        if (textFormatting == ChatFormatting.DARK_GRAY) {
            return ChatFormatting.DARK_PURPLE;
        }
        if (textFormatting == ChatFormatting.BLACK) {
            return ChatFormatting.GOLD;
        }
        return textFormatting != null ? textFormatting : ChatFormatting.GRAY;
    }

    public static Component getGalacticName(Waystone waystone) {
        String name = StringUtils.substringBeforeLast((String)waystone.getName().getString(), (String)" ");
        return Component.m_237113_((String)name).m_130940_(WarpPlateBlock.getColorForName(name)).m_130948_(GALACTIC_STYLE);
    }

    @Override
    protected boolean shouldOpenMenuWhenPlaced() {
        return false;
    }

    @Override
    public BlockEntityType<? extends WaystoneBlockEntityBase> getTickingBlockEntityType() {
        return (BlockEntityType)ModBlockEntities.warpPlate.get();
    }

    protected MapCodec<? extends BaseEntityBlock> m_304657_() {
        return CODEC;
    }

    public static enum WarpPlateStatus implements StringRepresentable
    {
        IDLE,
        ACTIVE,
        INVALID;


        public String m_7912_() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

