/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.block.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.UUID;
import net.blay09.mods.balm.api.block.entity.CustomRenderBoundingBox;
import net.blay09.mods.balm.api.block.entity.OnLoadHandler;
import net.blay09.mods.balm.api.container.ImplementedContainer;
import net.blay09.mods.balm.common.BalmBlockEntity;
import net.blay09.mods.waystones.Waystones;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.api.WaystoneOrigin;
import net.blay09.mods.waystones.api.WaystonesAPI;
import net.blay09.mods.waystones.block.WaystoneBlock;
import net.blay09.mods.waystones.block.WaystoneBlockBase;
import net.blay09.mods.waystones.core.InvalidWaystone;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.core.WaystoneImpl;
import net.blay09.mods.waystones.core.WaystoneManagerImpl;
import net.blay09.mods.waystones.core.WaystoneProxy;
import net.blay09.mods.waystones.core.WaystoneSyncManager;
import net.blay09.mods.waystones.recipe.ModRecipes;
import net.blay09.mods.waystones.recipe.WaystoneRecipe;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public abstract class WaystoneBlockEntityBase
extends BalmBlockEntity
implements OnLoadHandler,
CustomRenderBoundingBox,
ImplementedContainer {
    protected final ContainerData dataAccess = new ContainerData(){

        public int m_6413_(int i) {
            return WaystoneBlockEntityBase.this.attunementTicks;
        }

        public void m_8050_(int i, int j) {
            WaystoneBlockEntityBase.this.attunementTicks = j;
        }

        public int m_6499_() {
            return 1;
        }
    };
    private final NonNullList<ItemStack> items = NonNullList.m_122780_((int)5, (Object)ItemStack.f_41583_);
    private boolean readyForAttunement;
    private boolean completedFirstAttunement;
    protected int attunementTicks;
    private Waystone waystone = InvalidWaystone.INSTANCE;
    private UUID waystoneUid;
    private boolean shouldNotInitialize;
    private boolean silkTouched;

    public WaystoneBlockEntityBase(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ContainerHelper.m_18973_((CompoundTag)tag, this.items);
        if (this.waystone.isValid()) {
            tag.m_128365_("UUID", (Tag)NbtUtils.m_129226_((UUID)this.waystone.getWaystoneUid()));
        } else if (this.waystoneUid != null) {
            tag.m_128365_("UUID", (Tag)NbtUtils.m_129226_((UUID)this.waystoneUid));
        }
        tag.m_128379_("ReadyForAttunement", this.readyForAttunement);
        tag.m_128379_("CompletedFirstAttunement", this.completedFirstAttunement);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        ContainerHelper.m_18980_((CompoundTag)compound, this.items);
        if (compound.m_128425_("UUID", 11)) {
            this.waystoneUid = NbtUtils.m_129233_((Tag)Objects.requireNonNull(compound.m_128423_("UUID")));
        }
        if (compound.m_128425_("Waystone", 10)) {
            Waystone syncedWaystone = WaystoneImpl.read(compound.m_128469_("Waystone"));
            WaystoneManagerImpl.get(null).updateWaystone(syncedWaystone);
            this.waystone = new WaystoneProxy(null, syncedWaystone.getWaystoneUid());
        }
        this.readyForAttunement = compound.m_128471_("ReadyForAttunement");
        this.completedFirstAttunement = compound.m_128471_("CompletedFirstAttunement");
    }

    public void writeUpdateTag(CompoundTag tag) {
        tag.m_128365_("Waystone", (Tag)WaystoneImpl.write(this.getWaystone(), new CompoundTag()));
    }

    public void onLoad() {
        Waystone backingWaystone = this.waystone;
        if (this.waystone instanceof WaystoneProxy) {
            backingWaystone = ((WaystoneProxy)this.waystone).getBackingWaystone();
        }
        if (backingWaystone instanceof WaystoneImpl && this.f_58857_ != null) {
            ((WaystoneImpl)backingWaystone).setDimension((ResourceKey<Level>)this.f_58857_.m_46472_());
            ((WaystoneImpl)backingWaystone).setPos(this.f_58858_);
        }
        this.sync();
    }

    public AABB getRenderBoundingBox() {
        return new AABB((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), (double)(this.f_58858_.m_123341_() + 1), (double)(this.f_58858_.m_123342_() + 2), (double)(this.f_58858_.m_123343_() + 1));
    }

    public Waystone getWaystone() {
        if (!(this.waystone.isValid() || this.f_58857_ == null || this.f_58857_.f_46443_ || this.shouldNotInitialize)) {
            BlockState state;
            if (this.waystoneUid != null) {
                this.waystone = new WaystoneProxy(this.f_58857_.m_7654_(), this.waystoneUid);
            }
            if (!this.waystone.isValid() && (state = this.m_58900_()).m_60734_() instanceof WaystoneBlockBase) {
                BlockEntity blockEntity;
                WaystoneOrigin origin;
                DoubleBlockHalf half = state.m_61138_(WaystoneBlockBase.HALF) ? (DoubleBlockHalf)state.m_61143_(WaystoneBlockBase.HALF) : DoubleBlockHalf.LOWER;
                WaystoneOrigin waystoneOrigin = origin = state.m_61138_(WaystoneBlockBase.ORIGIN) ? (WaystoneOrigin)((Object)state.m_61143_(WaystoneBlockBase.ORIGIN)) : WaystoneOrigin.UNKNOWN;
                if (half == DoubleBlockHalf.LOWER) {
                    this.initializeWaystone((ServerLevelAccessor)Objects.requireNonNull(this.f_58857_), null, origin);
                } else if (half == DoubleBlockHalf.UPPER && (blockEntity = this.f_58857_.m_7702_(this.f_58858_.m_7495_())) instanceof WaystoneBlockEntityBase) {
                    this.initializeFromBase((WaystoneBlockEntityBase)blockEntity);
                }
            }
            if (this.waystone.isValid()) {
                this.waystoneUid = this.waystone.getWaystoneUid();
                this.sync();
            }
        }
        return this.waystone;
    }

    protected abstract ResourceLocation getWaystoneType();

    public void initializeWaystone(ServerLevelAccessor world, @Nullable LivingEntity player, WaystoneOrigin origin) {
        WaystoneImpl waystone = new WaystoneImpl(this.getWaystoneType(), UUID.randomUUID(), (ResourceKey<Level>)world.m_6018_().m_46472_(), this.f_58858_, origin, player != null ? player.m_20148_() : null);
        WaystoneManagerImpl.get(world.m_7654_()).addWaystone(waystone);
        this.waystone = waystone;
        this.m_6596_();
        this.sync();
        if (!this.isCompletedFirstAttunement()) {
            this.initializeInventory(world);
        }
    }

    public ItemStack m_7407_(int slot, int count) {
        if (!this.isCompletedFirstAttunement()) {
            return ItemStack.f_41583_;
        }
        return super.m_7407_(slot, count);
    }

    public ItemStack m_8016_(int slot) {
        if (!this.isCompletedFirstAttunement()) {
            return ItemStack.f_41583_;
        }
        return super.m_8016_(slot);
    }

    public void initializeFromExisting(ServerLevelAccessor world, WaystoneImpl existingWaystone, ItemStack itemStack) {
        this.waystone = existingWaystone;
        existingWaystone.setDimension((ResourceKey<Level>)world.m_6018_().m_46472_());
        existingWaystone.setPos(this.f_58858_);
        this.m_6596_();
        this.sync();
        CompoundTag tag = itemStack.m_41783_();
        boolean bl = this.completedFirstAttunement = tag != null && tag.m_128471_("CompletedFirstAttunement");
        if (!this.isCompletedFirstAttunement()) {
            this.initializeInventory(world);
        }
    }

    public void initializeFromBase(WaystoneBlockEntityBase tileEntity) {
        this.waystone = tileEntity.getWaystone();
        this.m_6596_();
        this.sync();
    }

    public void uninitializeWaystone() {
        if (this.waystone.isValid()) {
            WaystoneManagerImpl.get(this.f_58857_.m_7654_()).removeWaystone(this.waystone);
            PlayerWaystoneManager.removeKnownWaystone(this.f_58857_.m_7654_(), this.waystone);
            WaystoneSyncManager.sendWaystoneRemovalToAll(this.f_58857_.m_7654_(), this.waystone, true);
        }
        this.waystone = InvalidWaystone.INSTANCE;
        this.shouldNotInitialize = true;
        DoubleBlockHalf half = (DoubleBlockHalf)this.m_58900_().m_61143_((Property)WaystoneBlock.HALF);
        BlockPos otherPos = half == DoubleBlockHalf.UPPER ? this.f_58858_.m_7495_() : this.f_58858_.m_7494_();
        BlockEntity blockEntity = Objects.requireNonNull(this.f_58857_).m_7702_(otherPos);
        if (blockEntity instanceof WaystoneBlockEntityBase) {
            WaystoneBlockEntityBase waystoneTile = (WaystoneBlockEntityBase)blockEntity;
            waystoneTile.waystone = InvalidWaystone.INSTANCE;
            waystoneTile.shouldNotInitialize = true;
        }
        this.m_6596_();
        this.sync();
    }

    public void setSilkTouched(boolean silkTouched) {
        this.silkTouched = silkTouched;
    }

    public boolean isSilkTouched() {
        return this.silkTouched;
    }

    public abstract MenuProvider getMenuProvider();

    @Nullable
    public abstract MenuProvider getSettingsMenuProvider();

    public int getMaxAttunementTicks() {
        return 30;
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public ContainerData getContainerData() {
        return this.dataAccess;
    }

    @Nullable
    protected WaystoneRecipe trySelectRecipe() {
        if (!this.readyForAttunement) {
            return null;
        }
        if (this.f_58857_ == null) {
            return null;
        }
        if (this.m_8020_(0).m_41613_() > 1) {
            return null;
        }
        return this.f_58857_.m_7465_().m_44015_(ModRecipes.waystoneRecipeType, (Container)this, this.f_58857_).map(RecipeHolder::f_291008_).orElse(null);
    }

    public void serverTick() {
        WaystoneRecipe recipe = this.trySelectRecipe();
        if (recipe != null) {
            ++this.attunementTicks;
            if (this.attunementTicks >= this.getMaxAttunementTicks()) {
                this.attunementTicks = 0;
                this.craft(recipe);
            }
        } else {
            this.attunementTicks = 0;
        }
    }

    protected void craft(WaystoneRecipe recipe) {
        ItemStack attunedShard = recipe.m_5874_((Container)this, (RegistryAccess)RegistryAccess.f_243945_);
        WaystonesAPI.setBoundWaystone(attunedShard, this.getWaystone());
        ItemStack centerStack = this.m_8020_(0);
        if (centerStack.m_41613_() > 1) {
            centerStack = centerStack.m_255036_(centerStack.m_41613_() - 1);
            if (!Minecraft.m_91087_().f_91074_.m_150109_().m_36054_(centerStack)) {
                Minecraft.m_91087_().f_91074_.m_36176_(centerStack, false);
            }
        }
        this.m_6836_(0, attunedShard);
        for (int i = 1; i <= 4; ++i) {
            this.m_8020_(i).m_41774_(1);
        }
        this.completedFirstAttunement = true;
    }

    public Collection<? extends Waystone> getAuxiliaryTargets() {
        ArrayList result = new ArrayList();
        for (ItemStack item : this.getItems()) {
            WaystonesAPI.getBoundWaystone(null, item).ifPresent(result::add);
        }
        return result;
    }

    public boolean shouldPerformInitialAttunement() {
        return false;
    }

    public boolean isCompletedFirstAttunement() {
        return !this.shouldPerformInitialAttunement() || this.completedFirstAttunement;
    }

    public void markReadyForAttunement() {
        this.readyForAttunement = true;
    }

    private void initializeInventory(ServerLevelAccessor levelAccessor) {
        WaystoneRecipe initializingRecipe = levelAccessor.m_6018_().m_7465_().m_44013_(ModRecipes.waystoneRecipeType).stream().filter(holder -> holder.f_291676_().m_135827_().equals("waystones") && holder.f_291676_().m_135815_().equals("attuned_shard")).map(RecipeHolder::f_291008_).findFirst().orElse(null);
        if (initializingRecipe == null) {
            Waystones.logger.error("Failed to find Attunement recipe for initial attunement");
            this.completedFirstAttunement = true;
            return;
        }
        for (int i = 0; i < 5; ++i) {
            Ingredient ingredient = (Ingredient)initializingRecipe.m_7527_().get(i);
            ItemStack[] ingredientItems = ingredient.m_43908_();
            ItemStack ingredientItem = ingredientItems.length > 0 ? ingredientItems[0] : ItemStack.f_41583_;
            this.m_6836_(i, ingredientItem.m_41777_());
        }
    }
}

