/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.menu;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.blay09.mods.balm.api.DeferredObject;
import net.blay09.mods.balm.api.menu.BalmMenus;
import net.blay09.mods.waystones.api.TeleportFlags;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.block.entity.SharestoneBlockEntity;
import net.blay09.mods.waystones.block.entity.WarpPlateBlockEntity;
import net.blay09.mods.waystones.block.entity.WaystoneBlockEntity;
import net.blay09.mods.waystones.block.entity.WaystoneBlockEntityBase;
import net.blay09.mods.waystones.core.WaystoneImpl;
import net.blay09.mods.waystones.menu.WarpPlateMenu;
import net.blay09.mods.waystones.menu.WaystoneMenu;
import net.blay09.mods.waystones.menu.WaystoneSelectionMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class ModMenus {
    public static DeferredObject<MenuType<WaystoneSelectionMenu>> waystoneSelection;
    public static DeferredObject<MenuType<WaystoneSelectionMenu>> warpScrollSelection;
    public static DeferredObject<MenuType<WaystoneSelectionMenu>> warpStoneSelection;
    public static DeferredObject<MenuType<WaystoneSelectionMenu>> portstoneSelection;
    public static DeferredObject<MenuType<WaystoneSelectionMenu>> inventorySelection;
    public static DeferredObject<MenuType<WaystoneSelectionMenu>> adminSelection;
    public static DeferredObject<MenuType<WaystoneSelectionMenu>> sharestoneSelection;
    public static DeferredObject<MenuType<WarpPlateMenu>> warpPlate;
    public static DeferredObject<MenuType<WaystoneMenu>> waystoneSettings;

    public static void initialize(BalmMenus menus) {
        waystoneSelection = menus.registerMenu(ModMenus.id("waystone_selection"), (windowId, inventory, buf) -> {
            BlockPos pos = buf.m_130135_();
            List<Waystone> waystones = WaystoneImpl.readList(buf);
            BlockEntity blockEntity = inventory.f_35978_.m_9236_().m_7702_(pos);
            if (blockEntity instanceof WaystoneBlockEntity) {
                WaystoneBlockEntity waystone = (WaystoneBlockEntity)blockEntity;
                return new WaystoneSelectionMenu((MenuType<WaystoneSelectionMenu>)((MenuType)waystoneSelection.get()), waystone.getWaystone(), windowId, waystones, Collections.emptySet());
            }
            return null;
        });
        warpScrollSelection = menus.registerMenu(ModMenus.id("warp_scroll_selection"), (windowId, inventory, buf) -> {
            List<Waystone> waystones = WaystoneImpl.readList(buf);
            return new WaystoneSelectionMenu((MenuType<WaystoneSelectionMenu>)((MenuType)warpScrollSelection.get()), null, windowId, waystones, Collections.emptySet());
        });
        warpStoneSelection = menus.registerMenu(ModMenus.id("warp_stone_selection"), (windowId, inventory, buf) -> {
            List<Waystone> waystones = WaystoneImpl.readList(buf);
            return new WaystoneSelectionMenu((MenuType<WaystoneSelectionMenu>)((MenuType)warpStoneSelection.get()), null, windowId, waystones, Collections.emptySet());
        });
        portstoneSelection = menus.registerMenu(ModMenus.id("portstone_selection"), (windowId, inventory, buf) -> {
            List<Waystone> waystones = WaystoneImpl.readList(buf);
            return new WaystoneSelectionMenu((MenuType<WaystoneSelectionMenu>)((MenuType)waystoneSelection.get()), null, windowId, waystones, Collections.emptySet());
        });
        sharestoneSelection = menus.registerMenu(ModMenus.id("sharestone_selection"), (syncId, inventory, buf) -> {
            BlockPos pos = buf.m_130135_();
            List<Waystone> waystones = WaystoneImpl.readList(buf);
            BlockEntity blockEntity = inventory.f_35978_.m_9236_().m_7702_(pos);
            if (blockEntity instanceof SharestoneBlockEntity) {
                SharestoneBlockEntity sharestone = (SharestoneBlockEntity)blockEntity;
                return new WaystoneSelectionMenu((MenuType<WaystoneSelectionMenu>)((MenuType)sharestoneSelection.get()), sharestone.getWaystone(), syncId, waystones, Collections.emptySet());
            }
            return null;
        });
        inventorySelection = menus.registerMenu(ModMenus.id("inventory_selection"), (syncId, inventory, buf) -> {
            List<Waystone> waystones = WaystoneImpl.readList(buf);
            return new WaystoneSelectionMenu((MenuType<WaystoneSelectionMenu>)((MenuType)inventorySelection.get()), null, syncId, waystones, Set.of(TeleportFlags.INVENTORY_BUTTON));
        });
        adminSelection = menus.registerMenu(ModMenus.id("admin_selection"), (syncId, inventory, buf) -> {
            List<Waystone> waystones = WaystoneImpl.readList(buf);
            return new WaystoneSelectionMenu((MenuType<WaystoneSelectionMenu>)((MenuType)adminSelection.get()), null, syncId, waystones, Set.of(TeleportFlags.ADMIN));
        });
        warpPlate = menus.registerMenu(ModMenus.id("warp_plate"), (windowId, inv, data) -> {
            BlockPos pos = data.m_130135_();
            BlockEntity blockEntity = inv.f_35978_.m_9236_().m_7702_(pos);
            if (blockEntity instanceof WarpPlateBlockEntity) {
                WarpPlateBlockEntity warpPlate = (WarpPlateBlockEntity)blockEntity;
                return new WarpPlateMenu(windowId, warpPlate, warpPlate.getContainerData(), inv);
            }
            return null;
        });
        waystoneSettings = menus.registerMenu(ModMenus.id("waystone"), (windowId, inv, data) -> {
            BlockPos pos = data.m_130135_();
            Waystone waystone = WaystoneImpl.read(data);
            boolean canEdit = data.readBoolean();
            BlockEntity blockEntity = inv.f_35978_.m_9236_().m_7702_(pos);
            if (blockEntity instanceof WaystoneBlockEntityBase) {
                WaystoneBlockEntityBase waystoneBlockEntity = (WaystoneBlockEntityBase)blockEntity;
                return new WaystoneMenu(windowId, waystone, waystoneBlockEntity, waystoneBlockEntity.getContainerData(), inv, canEdit);
            }
            return null;
        });
    }

    @NotNull
    private static ResourceLocation id(String name) {
        return new ResourceLocation("waystones", name);
    }
}

