/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.network.message;

import java.util.UUID;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class SortWaystoneMessage {
    public static final UUID SORT_FIRST = UUID.fromString("00000000-0000-0000-0000-000000000000");
    public static final UUID SORT_LAST = UUID.fromString("ffffffff-ffff-ffff-ffff-ffffffffffff");
    private final UUID waystoneUid;
    private final UUID otherWaystoneUid;

    public SortWaystoneMessage(UUID waystoneUid, UUID otherWaystoneUid) {
        this.waystoneUid = waystoneUid;
        this.otherWaystoneUid = otherWaystoneUid;
    }

    public static void encode(SortWaystoneMessage message, FriendlyByteBuf buf) {
        buf.m_130077_(message.waystoneUid);
        buf.m_130077_(message.otherWaystoneUid);
    }

    public static SortWaystoneMessage decode(FriendlyByteBuf buf) {
        UUID waystoneUid = buf.m_130259_();
        UUID otherWaystoneUid = buf.m_130259_();
        return new SortWaystoneMessage(waystoneUid, otherWaystoneUid);
    }

    public static void handle(ServerPlayer player, SortWaystoneMessage message) {
        if (player == null) {
            return;
        }
        if (message.waystoneUid.equals(SORT_FIRST)) {
            PlayerWaystoneManager.sortWaystoneAsFirst((Player)player, message.otherWaystoneUid);
        } else if (message.waystoneUid.equals(SORT_LAST)) {
            PlayerWaystoneManager.sortWaystoneAsLast((Player)player, message.otherWaystoneUid);
        } else {
            PlayerWaystoneManager.sortWaystoneSwap((Player)player, message.waystoneUid, message.otherWaystoneUid);
        }
    }
}

