/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.worldgen.namegen;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.worldgen.namegen.LiteralNameGenerator;
import net.blay09.mods.waystones.worldgen.namegen.NameGenerator;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;

public class TemplateNameGenerator
implements NameGenerator {
    private final String template;
    private final Map<String, NameGenerator> placeholders = new HashMap<String, NameGenerator>();

    public TemplateNameGenerator(String template) {
        this.template = template;
    }

    public TemplateNameGenerator with(String key, NameGenerator nameGenerator) {
        this.placeholders.put(key, nameGenerator);
        return this;
    }

    public TemplateNameGenerator with(String key, String value) {
        return this.with(key, new LiteralNameGenerator(value));
    }

    @Override
    public Optional<Component> generateName(LevelAccessor level, Waystone waystone, RandomSource rand) {
        String result = this.template;
        for (Map.Entry<String, NameGenerator> entry : this.placeholders.entrySet()) {
            String key = entry.getKey();
            Component value = entry.getValue().generateName(level, waystone, rand).orElse(null);
            if (value == null) continue;
            result = result.replaceAll("\\{" + key + "}", value.getString());
        }
        return Optional.of(Component.m_237113_((String)result));
    }
}

