/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.block;

import java.util.Collection;
import java.util.List;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.menu.BalmMenuProvider;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.block.WaystoneBlockBase;
import net.blay09.mods.waystones.block.entity.PortstoneBlockEntity;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.core.WarpMode;
import net.blay09.mods.waystones.core.Waystone;
import net.blay09.mods.waystones.menu.ModMenus;
import net.blay09.mods.waystones.menu.WaystoneSelectionMenu;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class PortstoneBlock
extends WaystoneBlockBase {
    private static final VoxelShape[] LOWER_SHAPES = new VoxelShape[]{Shapes.or((VoxelShape)PortstoneBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0), (VoxelShape[])new VoxelShape[]{PortstoneBlock.box((double)1.0, (double)3.0, (double)1.0, (double)15.0, (double)7.0, (double)15.0), PortstoneBlock.box((double)2.0, (double)7.0, (double)2.0, (double)14.0, (double)9.0, (double)14.0), PortstoneBlock.box((double)3.0, (double)9.0, (double)3.0, (double)13.0, (double)16.0, (double)7.0), PortstoneBlock.box((double)4.0, (double)9.0, (double)7.0, (double)12.0, (double)16.0, (double)10.0), PortstoneBlock.box((double)4.0, (double)9.0, (double)10.0, (double)12.0, (double)12.0, (double)12.0)}).optimize(), Shapes.or((VoxelShape)PortstoneBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0), (VoxelShape[])new VoxelShape[]{PortstoneBlock.box((double)1.0, (double)3.0, (double)1.0, (double)15.0, (double)7.0, (double)15.0), PortstoneBlock.box((double)2.0, (double)7.0, (double)2.0, (double)14.0, (double)9.0, (double)14.0), PortstoneBlock.box((double)9.0, (double)9.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0), PortstoneBlock.box((double)6.0, (double)9.0, (double)4.0, (double)9.0, (double)16.0, (double)12.0), PortstoneBlock.box((double)4.0, (double)9.0, (double)4.0, (double)6.0, (double)12.0, (double)12.0)}).optimize(), Shapes.or((VoxelShape)PortstoneBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0), (VoxelShape[])new VoxelShape[]{PortstoneBlock.box((double)1.0, (double)3.0, (double)1.0, (double)15.0, (double)7.0, (double)15.0), PortstoneBlock.box((double)2.0, (double)7.0, (double)2.0, (double)14.0, (double)9.0, (double)14.0), PortstoneBlock.box((double)3.0, (double)9.0, (double)9.0, (double)13.0, (double)16.0, (double)13.0), PortstoneBlock.box((double)4.0, (double)9.0, (double)6.0, (double)12.0, (double)16.0, (double)9.0), PortstoneBlock.box((double)4.0, (double)9.0, (double)4.0, (double)12.0, (double)12.0, (double)6.0)}).optimize(), Shapes.or((VoxelShape)PortstoneBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0), (VoxelShape[])new VoxelShape[]{PortstoneBlock.box((double)1.0, (double)3.0, (double)1.0, (double)15.0, (double)7.0, (double)15.0), PortstoneBlock.box((double)2.0, (double)7.0, (double)2.0, (double)14.0, (double)9.0, (double)14.0), PortstoneBlock.box((double)3.0, (double)9.0, (double)3.0, (double)7.0, (double)16.0, (double)13.0), PortstoneBlock.box((double)7.0, (double)9.0, (double)4.0, (double)10.0, (double)16.0, (double)12.0), PortstoneBlock.box((double)10.0, (double)9.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0)}).optimize()};
    private static final VoxelShape[] UPPER_SHAPES = new VoxelShape[]{Shapes.or((VoxelShape)PortstoneBlock.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)7.0, (double)7.0), (VoxelShape)PortstoneBlock.box((double)4.0, (double)0.0, (double)7.0, (double)12.0, (double)2.0, (double)9.0)).optimize(), Shapes.or((VoxelShape)PortstoneBlock.box((double)9.0, (double)0.0, (double)3.0, (double)13.0, (double)7.0, (double)13.0), (VoxelShape)PortstoneBlock.box((double)7.0, (double)0.0, (double)4.0, (double)9.0, (double)2.0, (double)12.0)).optimize(), Shapes.or((VoxelShape)PortstoneBlock.box((double)3.0, (double)0.0, (double)9.0, (double)13.0, (double)7.0, (double)13.0), (VoxelShape)PortstoneBlock.box((double)4.0, (double)0.0, (double)7.0, (double)12.0, (double)2.0, (double)9.0)).optimize(), Shapes.or((VoxelShape)PortstoneBlock.box((double)3.0, (double)0.0, (double)3.0, (double)7.0, (double)7.0, (double)13.0), (VoxelShape)PortstoneBlock.box((double)7.0, (double)0.0, (double)4.0, (double)9.0, (double)2.0, (double)12.0)).optimize()};

    public PortstoneBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        return state.getValue((Property)HALF) == DoubleBlockHalf.UPPER ? UPPER_SHAPES[direction.get2DDataValue()] : LOWER_SHAPES[direction.get2DDataValue()];
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new PortstoneBlockEntity(pos, state);
    }

    @Override
    public InteractionResult use(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult blockHitResult) {
        if (!world.isClientSide) {
            final Collection<IWaystone> waystones = PlayerWaystoneManager.getTargetsForPlayer(player);
            PlayerWaystoneManager.ensureSortingIndex(player, waystones);
            Balm.getNetworking().openGui(player, (MenuProvider)new BalmMenuProvider(){

                public Component getDisplayName() {
                    return Component.translatable((String)"block.waystones.portstone");
                }

                public AbstractContainerMenu createMenu(int windowId, Inventory inventory, Player player) {
                    return new WaystoneSelectionMenu((MenuType<WaystoneSelectionMenu>)((MenuType)ModMenus.portstoneSelection.get()), WarpMode.PORTSTONE_TO_WAYSTONE, null, windowId, waystones);
                }

                public void writeScreenOpeningData(ServerPlayer player, FriendlyByteBuf buf) {
                    Waystone.writeList(buf, waystones);
                }
            });
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{HALF});
    }

    public boolean isPathfindable(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, PathComputationType pathComputationType) {
        return false;
    }

    @Override
    public void appendHoverText(ItemStack stack, @Nullable BlockGetter world, List<Component> list, TooltipFlag flag) {
        MutableComponent component = Component.translatable((String)"tooltip.waystones.portstone");
        component.withStyle(ChatFormatting.GRAY);
        list.add((Component)component);
        super.appendHoverText(stack, world, list, flag);
    }
}

