/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.block;

import java.util.List;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.block.WaystoneBlockBase;
import net.blay09.mods.waystones.block.entity.ModBlockEntities;
import net.blay09.mods.waystones.block.entity.SharestoneBlockEntity;
import net.blay09.mods.waystones.block.entity.WaystoneBlockEntityBase;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class SharestoneBlock
extends WaystoneBlockBase {
    private static final VoxelShape LOWER_SHAPE = Shapes.or((VoxelShape)SharestoneBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0), (VoxelShape[])new VoxelShape[]{SharestoneBlock.box((double)1.0, (double)3.0, (double)1.0, (double)15.0, (double)7.0, (double)15.0), SharestoneBlock.box((double)2.0, (double)7.0, (double)2.0, (double)14.0, (double)9.0, (double)14.0), SharestoneBlock.box((double)3.0, (double)9.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0)}).optimize();
    private static final VoxelShape UPPER_SHAPE = Shapes.or((VoxelShape)SharestoneBlock.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)7.0, (double)13.0), (VoxelShape[])new VoxelShape[]{SharestoneBlock.box((double)2.0, (double)7.0, (double)2.0, (double)14.0, (double)9.0, (double)14.0), SharestoneBlock.box((double)1.0, (double)9.0, (double)1.0, (double)15.0, (double)13.0, (double)15.0), SharestoneBlock.box((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)}).optimize();
    @Nullable
    private final DyeColor color;

    public SharestoneBlock(BlockBehaviour.Properties properties, @Nullable DyeColor color) {
        super(properties);
        this.color = color;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new SharestoneBlockEntity(pos, state);
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return state.getValue((Property)HALF) == DoubleBlockHalf.UPPER ? UPPER_SHAPE : LOWER_SHAPE;
    }

    @Override
    protected InteractionResult handleActivation(Level world, BlockPos pos, Player player, WaystoneBlockEntityBase tileEntity, IWaystone waystone) {
        if (!world.isClientSide) {
            Balm.getNetworking().openGui(player, tileEntity.getMenuProvider());
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public void appendHoverText(ItemStack stack, @Nullable BlockGetter world, List<Component> list, TooltipFlag flag) {
        MutableComponent component = Component.translatable((String)(this.color != null ? "tooltip.waystones." + this.color.getSerializedName() + "_sharestone" : "tooltip.waystones.sharestone"));
        component.withStyle(ChatFormatting.GRAY);
        list.add((Component)component);
        super.appendHoverText(stack, world, list, flag);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{HALF});
    }

    @Nullable
    public DyeColor getColor() {
        return this.color;
    }

    @Override
    public BlockEntityType<? extends WaystoneBlockEntityBase> getTickingBlockEntityType() {
        return (BlockEntityType)ModBlockEntities.sharestone.get();
    }
}

