/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.block;

import java.util.List;
import java.util.Locale;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.block.WaystoneBlockBase;
import net.blay09.mods.waystones.block.entity.ModBlockEntities;
import net.blay09.mods.waystones.block.entity.WarpPlateBlockEntity;
import net.blay09.mods.waystones.block.entity.WaystoneBlockEntityBase;
import net.blay09.mods.waystones.core.WaystoneProxy;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class WarpPlateBlock
extends WaystoneBlockBase {
    private static final Style GALACTIC_STYLE = Style.EMPTY.withFont(new ResourceLocation("minecraft", "alt"));
    private static final VoxelShape SHAPE = Shapes.or((VoxelShape)WarpPlateBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), (VoxelShape)WarpPlateBlock.box((double)3.0, (double)1.0, (double)3.0, (double)13.0, (double)2.0, (double)13.0)).optimize();
    @Deprecated
    public static final BooleanProperty ACTIVE = BooleanProperty.create((String)"active");
    public static final EnumProperty<WarpPlateStatus> STATUS = EnumProperty.create((String)"status", WarpPlateStatus.class);

    public WarpPlateBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(false))).setValue(STATUS, (Comparable)((Object)WarpPlateStatus.IDLE)));
    }

    @Override
    protected boolean canSilkTouch() {
        return true;
    }

    @Override
    public void setPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity tileEntity;
        super.setPlacedBy(world, pos, state, placer, stack);
        if (stack.hasCustomHoverName() && (tileEntity = world.getBlockEntity(pos)) instanceof WarpPlateBlockEntity) {
            WarpPlateBlockEntity warpPlate = (WarpPlateBlockEntity)tileEntity;
            warpPlate.setCustomName(stack.getHoverName());
        }
    }

    public VoxelShape getShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return SHAPE;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{ACTIVE});
        builder.add(new Property[]{STATUS});
    }

    public void entityInside(BlockState blockState, Level world, BlockPos pos, Entity entity) {
        BlockEntity tileEntity;
        if (entity.getX() >= (double)pos.getX() && entity.getX() < (double)(pos.getX() + 1) && entity.getY() >= (double)pos.getY() && entity.getY() < (double)(pos.getY() + 1) && entity.getZ() >= (double)pos.getZ() && entity.getZ() < (double)(pos.getZ() + 1) && !world.isClientSide && (tileEntity = world.getBlockEntity(pos)) instanceof WarpPlateBlockEntity) {
            ((WarpPlateBlockEntity)tileEntity).onEntityCollision(entity);
        }
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        block3: {
            block2: {
                if (state.getValue(STATUS) != WarpPlateStatus.ACTIVE) break block2;
                for (int i = 0; i < 50; ++i) {
                    world.addParticle((ParticleOptions)ParticleTypes.CRIMSON_SPORE, (double)pos.getX() + Math.random(), (double)pos.getY() + Math.random() * 2.0, (double)pos.getZ() + Math.random(), 0.0, 0.0, 0.0);
                    world.addParticle((ParticleOptions)ParticleTypes.PORTAL, (double)pos.getX() + Math.random(), (double)pos.getY() + Math.random() * 2.0, (double)pos.getZ() + Math.random(), 0.0, 0.0, 0.0);
                }
                break block3;
            }
            if (state.getValue(STATUS) != WarpPlateStatus.INVALID) break block3;
            for (int i = 0; i < 10; ++i) {
                world.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)pos.getX() + Math.random(), (double)pos.getY(), (double)pos.getZ() + Math.random(), 0.0, (double)0.01f, 0.0);
            }
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new WarpPlateBlockEntity(pos, state);
    }

    @Override
    protected InteractionResult handleActivation(Level world, BlockPos pos, Player player, WaystoneBlockEntityBase tileEntity, IWaystone waystone) {
        if (!world.isClientSide) {
            Balm.getNetworking().openGui(player, tileEntity.getMenuProvider());
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    protected void addWaystoneNameToTooltip(List<Component> tooltip, WaystoneProxy waystone) {
        tooltip.add(WarpPlateBlock.getGalacticName(waystone));
    }

    public static ChatFormatting getColorForName(String name) {
        int colorIndex = Math.abs(name.hashCode()) % 15;
        ChatFormatting textFormatting = ChatFormatting.getById((int)colorIndex);
        if (textFormatting == ChatFormatting.GRAY) {
            return ChatFormatting.LIGHT_PURPLE;
        }
        if (textFormatting == ChatFormatting.DARK_GRAY) {
            return ChatFormatting.DARK_PURPLE;
        }
        if (textFormatting == ChatFormatting.BLACK) {
            return ChatFormatting.GOLD;
        }
        return textFormatting != null ? textFormatting : ChatFormatting.GRAY;
    }

    public static Component getGalacticName(IWaystone waystone) {
        String name = StringUtils.substringBeforeLast((String)waystone.getName(), (String)" ");
        MutableComponent galacticName = Component.literal((String)name);
        galacticName.withStyle(WarpPlateBlock.getColorForName(name));
        galacticName.withStyle(GALACTIC_STYLE);
        return galacticName;
    }

    @Override
    protected boolean shouldOpenMenuWhenPlaced() {
        return false;
    }

    @Override
    public BlockEntityType<? extends WaystoneBlockEntityBase> getTickingBlockEntityType() {
        return (BlockEntityType)ModBlockEntities.warpPlate.get();
    }

    public static enum WarpPlateStatus implements StringRepresentable
    {
        IDLE,
        ACTIVE,
        INVALID;


        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

