/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.block;

import java.util.List;
import java.util.Objects;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.waystones.api.IAttunementItem;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.api.WaystoneOrigin;
import net.blay09.mods.waystones.block.entity.WaystoneBlockEntityBase;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.core.Waystone;
import net.blay09.mods.waystones.core.WaystoneEditPermissions;
import net.blay09.mods.waystones.core.WaystoneManager;
import net.blay09.mods.waystones.core.WaystonePermissionManager;
import net.blay09.mods.waystones.core.WaystoneProxy;
import net.blay09.mods.waystones.core.WaystoneSyncManager;
import net.blay09.mods.waystones.item.ModItems;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.ObserverBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public abstract class WaystoneBlockBase
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.DOUBLE_BLOCK_HALF;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final EnumProperty<WaystoneOrigin> ORIGIN = EnumProperty.create((String)"origin", WaystoneOrigin.class);

    public WaystoneBlockBase(BlockBehaviour.Properties properties) {
        super(properties.pushReaction(PushReaction.BLOCK));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue(ORIGIN, (Comparable)((Object)WaystoneOrigin.UNKNOWN)));
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState directionState, LevelAccessor world, BlockPos pos, BlockPos directionPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            world.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        if (this.isDoubleBlock(state)) {
            DoubleBlockHalf half = (DoubleBlockHalf)state.getValue(HALF);
            if ((direction.getAxis() != Direction.Axis.Y || half == DoubleBlockHalf.LOWER != (direction == Direction.UP) || directionState.getBlock() == this && directionState.getValue(HALF) != half) && (half != DoubleBlockHalf.LOWER || direction != Direction.DOWN || state.canSurvive((LevelReader)world, pos))) {
                return state;
            }
            return Blocks.AIR.defaultBlockState();
        }
        return state;
    }

    public void playerDestroy(Level world, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, ItemStack stack) {
        if (this.isDoubleBlock(state)) {
            super.playerDestroy(world, player, pos, Blocks.AIR.defaultBlockState(), blockEntity, stack);
        } else {
            super.playerDestroy(world, player, pos, state, blockEntity, stack);
        }
    }

    private boolean isDoubleBlock(BlockState state) {
        return state.hasProperty(HALF);
    }

    protected boolean canSilkTouch() {
        return false;
    }

    public void playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        BlockState offsetState;
        boolean hasSilkTouch;
        BlockEntity blockEntity = world.getBlockEntity(pos);
        boolean isDoubleBlock = this.isDoubleBlock(state);
        DoubleBlockHalf half = isDoubleBlock ? (DoubleBlockHalf)state.getValue(HALF) : null;
        BlockPos offset = half == DoubleBlockHalf.LOWER ? pos.above() : pos.below();
        BlockEntity offsetTileEntity = isDoubleBlock ? world.getBlockEntity(offset) : null;
        boolean bl = hasSilkTouch = EnchantmentHelper.getEnchantmentLevel((Enchantment)Enchantments.SILK_TOUCH, (LivingEntity)player) > 0;
        if (hasSilkTouch && this.canSilkTouch()) {
            if (blockEntity instanceof WaystoneBlockEntityBase) {
                ((WaystoneBlockEntityBase)blockEntity).setSilkTouched(true);
            }
            if (isDoubleBlock && offsetTileEntity instanceof WaystoneBlockEntityBase) {
                ((WaystoneBlockEntityBase)offsetTileEntity).setSilkTouched(true);
            }
        }
        if (isDoubleBlock && (offsetState = world.getBlockState(offset)).getBlock() == this && offsetState.getValue(HALF) != half) {
            world.destroyBlock(half == DoubleBlockHalf.LOWER ? pos : offset, false, (Entity)player);
            if (!world.isClientSide && !player.getAbilities().instabuild) {
                WaystoneBlockBase.dropResources((BlockState)state, (Level)world, (BlockPos)pos, (BlockEntity)blockEntity, (Entity)player, (ItemStack)player.getMainHandItem());
                WaystoneBlockBase.dropResources((BlockState)offsetState, (Level)world, (BlockPos)offset, (BlockEntity)offsetTileEntity, (Entity)player, (ItemStack)player.getMainHandItem());
            }
        }
        if (blockEntity instanceof WaystoneBlockEntityBase) {
            WaystoneBlockEntityBase waystoneBlockEntity = (WaystoneBlockEntityBase)blockEntity;
            if (!player.getAbilities().instabuild && waystoneBlockEntity.isCompletedFirstAttunement()) {
                for (int i = 0; i < waystoneBlockEntity.getContainerSize(); ++i) {
                    IWaystone waystoneAttunedTo;
                    ItemStack itemStack = waystoneBlockEntity.getItem(i);
                    if (!hasSilkTouch && itemStack.getItem() == ModItems.attunedShard && (waystoneAttunedTo = ((IAttunementItem)ModItems.attunedShard).getWaystoneAttunedTo(world.getServer(), itemStack)) != null && waystoneAttunedTo.getWaystoneUid().equals(waystoneBlockEntity.getWaystone().getWaystoneUid())) continue;
                    WaystoneBlockBase.popResource((Level)world, (BlockPos)pos, (ItemStack)itemStack);
                }
            }
        }
        super.playerWillDestroy(world, pos, state, player);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, WATERLOGGED, ORIGIN});
    }

    public float getDestroyProgress(BlockState state, Player player, BlockGetter world, BlockPos pos) {
        if (!WaystonePermissionManager.mayBreakWaystone(player, world, pos)) {
            return -1.0f;
        }
        return super.getDestroyProgress(state, player, world, pos);
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        if (!this.isDoubleBlock(state)) {
            return true;
        }
        if (state.getValue(HALF) == DoubleBlockHalf.LOWER) {
            return true;
        }
        BlockState below = world.getBlockState(pos.below());
        return below.getBlock() == this && below.getValue(HALF) == DoubleBlockHalf.LOWER;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        if (!WaystonePermissionManager.mayPlaceWaystone(context.getPlayer())) {
            return null;
        }
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        FluidState fluidState = world.getFluidState(pos);
        if (pos.getY() < world.getHeight() - 1 && world.getBlockState(pos.above()).canBeReplaced(context)) {
            return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
        }
        return null;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    protected void notifyObserversOfAction(Level world, BlockPos pos) {
        if (!world.isClientSide) {
            for (Direction direction : Direction.values()) {
                BlockPos offset = pos.relative(direction);
                BlockState neighbourState = world.getBlockState(offset);
                Block neighbourBlock = neighbourState.getBlock();
                if (!(neighbourBlock instanceof ObserverBlock) || neighbourState.getValue((Property)ObserverBlock.FACING) != direction.getOpposite() || world.getBlockTicks().hasScheduledTick(offset, (Object)neighbourBlock)) continue;
                world.scheduleTick(offset, neighbourBlock, 2);
            }
        }
    }

    @Nullable
    protected InteractionResult handleEditActions(Level world, Player player, WaystoneBlockEntityBase tileEntity, IWaystone waystone) {
        if (player.isShiftKeyDown()) {
            MenuProvider settingsContainerProvider;
            WaystoneEditPermissions result = WaystonePermissionManager.mayEditWaystone(player, world, waystone);
            if (result != WaystoneEditPermissions.ALLOW) {
                if (result.getLangKey() != null) {
                    MutableComponent chatComponent = Component.translatable((String)result.getLangKey());
                    chatComponent.withStyle(ChatFormatting.RED);
                    player.displayClientMessage((Component)chatComponent, true);
                }
                return InteractionResult.SUCCESS;
            }
            if (!world.isClientSide && (settingsContainerProvider = tileEntity.getSettingsMenuProvider()) != null) {
                Balm.getNetworking().openGui(player, settingsContainerProvider);
            }
            return InteractionResult.SUCCESS;
        }
        return null;
    }

    protected boolean shouldOpenMenuWhenPlaced() {
        return true;
    }

    @Nullable
    protected InteractionResult handleDebugActions(Level world, Player player, InteractionHand hand, WaystoneBlockEntityBase tileEntity) {
        if (player.getAbilities().instabuild) {
            ItemStack heldItem = player.getItemInHand(hand);
            if (heldItem.getItem() == Items.BAMBOO) {
                if (!world.isClientSide) {
                    tileEntity.uninitializeWaystone();
                    player.displayClientMessage((Component)Component.literal((String)"Waystone was successfully reset - it will re-initialize once it is next loaded."), false);
                }
                return InteractionResult.SUCCESS;
            }
            if (heldItem.getItem() == Items.STICK) {
                if (!world.isClientSide) {
                    player.displayClientMessage((Component)Component.literal((String)("Server UUID: " + tileEntity.getWaystone().getWaystoneUid())), false);
                }
                if (world.isClientSide) {
                    player.displayClientMessage((Component)Component.literal((String)("Client UUID: " + tileEntity.getWaystone().getWaystoneUid())), false);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return null;
    }

    @Nullable
    protected InteractionResult handleActivation(Level world, BlockPos pos, Player player, WaystoneBlockEntityBase tileEntity, IWaystone waystone) {
        return null;
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.is(newState.getBlock())) {
            boolean wasNotSilkTouched;
            BlockEntity blockEntity = world.getBlockEntity(pos);
            IWaystone waystone = ((WaystoneBlockEntityBase)blockEntity).getWaystone();
            boolean bl = wasNotSilkTouched = blockEntity instanceof WaystoneBlockEntityBase && (!this.canSilkTouch() || !((WaystoneBlockEntityBase)blockEntity).isSilkTouched());
            if (wasNotSilkTouched) {
                WaystoneManager.get(world.getServer()).removeWaystone(waystone);
                PlayerWaystoneManager.removeKnownWaystone(world.getServer(), waystone);
            }
            WaystoneSyncManager.sendWaystoneRemovalToAll(world.getServer(), waystone, wasNotSilkTouched);
        }
        super.onRemove(state, world, pos, newState, isMoving);
    }

    public void appendHoverText(ItemStack stack, @Nullable BlockGetter world, List<Component> list, TooltipFlag flag) {
        WaystoneProxy waystone;
        super.appendHoverText(stack, world, list, flag);
        CompoundTag tag = stack.getTag();
        if (tag != null && tag.contains("UUID", 11) && (waystone = new WaystoneProxy(null, NbtUtils.loadUUID((Tag)Objects.requireNonNull(tag.get("UUID"))))).isValid()) {
            this.addWaystoneNameToTooltip(list, waystone);
        }
    }

    protected void addWaystoneNameToTooltip(List<Component> tooltip, WaystoneProxy waystone) {
        MutableComponent component = Component.literal((String)waystone.getName());
        component.withStyle(ChatFormatting.AQUA);
        tooltip.add((Component)component);
    }

    public InteractionResult use(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult blockHitResult) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof WaystoneBlockEntityBase) {
            WaystoneBlockEntityBase waystoneTileEntity = (WaystoneBlockEntityBase)blockEntity;
            InteractionResult result = this.handleDebugActions(world, player, hand, waystoneTileEntity);
            if (result != null) {
                return result;
            }
            IWaystone waystone = waystoneTileEntity.getWaystone();
            result = this.handleEditActions(world, player, waystoneTileEntity, waystone);
            if (result != null) {
                return result;
            }
            result = this.handleActivation(world, pos, player, waystoneTileEntity, waystone);
            if (result != null) {
                return result;
            }
        }
        return InteractionResult.FAIL;
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        BlockPos posAbove = pos.above();
        boolean isDoubleBlock = this.isDoubleBlock(state);
        if (isDoubleBlock) {
            FluidState fluidStateAbove = world.getFluidState(posAbove);
            world.setBlockAndUpdate(posAbove, (BlockState)((BlockState)((BlockState)state.setValue(HALF, (Comparable)DoubleBlockHalf.UPPER)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidStateAbove.getType() == Fluids.WATER))).setValue(ORIGIN, (Comparable)((Object)WaystoneOrigin.PLAYER)));
        }
        if (blockEntity instanceof WaystoneBlockEntityBase) {
            MenuProvider settingsContainerProvider;
            WaystoneBlockEntityBase waystoneTileEntity;
            ServerPlayer player;
            WaystoneEditPermissions result;
            if (!world.isClientSide) {
                BlockEntity waystoneEntityAbove;
                CompoundTag tag = stack.getTag();
                WaystoneProxy existingWaystone = null;
                if (tag != null && tag.contains("UUID", 11)) {
                    existingWaystone = new WaystoneProxy(world.getServer(), NbtUtils.loadUUID((Tag)Objects.requireNonNull(tag.get("UUID"))));
                }
                if (existingWaystone != null && existingWaystone.isValid() && existingWaystone.getBackingWaystone() instanceof Waystone) {
                    ((WaystoneBlockEntityBase)blockEntity).initializeFromExisting((ServerLevelAccessor)world, (Waystone)existingWaystone.getBackingWaystone(), stack);
                } else {
                    ((WaystoneBlockEntityBase)blockEntity).initializeWaystone((ServerLevelAccessor)world, placer, WaystoneOrigin.PLAYER);
                }
                if (isDoubleBlock && (waystoneEntityAbove = world.getBlockEntity(posAbove)) instanceof WaystoneBlockEntityBase) {
                    ((WaystoneBlockEntityBase)waystoneEntityAbove).initializeFromBase((WaystoneBlockEntityBase)blockEntity);
                }
            }
            if (placer instanceof Player) {
                IWaystone waystone = ((WaystoneBlockEntityBase)blockEntity).getWaystone();
                PlayerWaystoneManager.activateWaystone((Player)placer, waystone);
                if (!world.isClientSide) {
                    WaystoneSyncManager.sendActivatedWaystones((Player)placer);
                }
            }
            if (!world.isClientSide && placer instanceof ServerPlayer && (result = WaystonePermissionManager.mayEditWaystone((Player)(player = (ServerPlayer)placer), world, (waystoneTileEntity = (WaystoneBlockEntityBase)blockEntity).getWaystone())) == WaystoneEditPermissions.ALLOW && (settingsContainerProvider = waystoneTileEntity.getSettingsMenuProvider()) != null && this.shouldOpenMenuWhenPlaced()) {
                Balm.getNetworking().openGui((Player)player, settingsContainerProvider);
            }
        }
    }

    public RenderShape getRenderShape(BlockState blockState) {
        return RenderShape.MODEL;
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public BlockEntityType<? extends WaystoneBlockEntityBase> getTickingBlockEntityType() {
        return null;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        BlockEntityType<? extends WaystoneBlockEntityBase> tickingBlockEntityType = this.getTickingBlockEntityType();
        if (tickingBlockEntityType == null) {
            return null;
        }
        return world.isClientSide ? null : WaystoneBlockBase.createTickerHelper(type, tickingBlockEntityType, (level, pos, state2, blockEntity) -> blockEntity.serverTick());
    }
}

