/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.block.entity;

import net.blay09.mods.balm.api.menu.BalmMenuProvider;
import net.blay09.mods.waystones.api.WaystoneTypes;
import net.blay09.mods.waystones.block.entity.ModBlockEntities;
import net.blay09.mods.waystones.block.entity.WaystoneBlockEntityBase;
import net.blay09.mods.waystones.core.Waystone;
import net.blay09.mods.waystones.menu.WaystoneSettingsMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class LandingStoneBlockEntity
extends WaystoneBlockEntityBase {
    public LandingStoneBlockEntity(BlockPos worldPosition, BlockState state) {
        super((BlockEntityType)ModBlockEntities.landingStone.get(), worldPosition, state);
    }

    @Override
    protected ResourceLocation getWaystoneType() {
        return WaystoneTypes.LANDING_STONE;
    }

    @Override
    public MenuProvider getMenuProvider() {
        return new BalmMenuProvider(){

            public Component getDisplayName() {
                return Component.translatable((String)"container.waystones.landing_stone");
            }

            public AbstractContainerMenu createMenu(int windowId, Inventory playerInventory, Player playerEntity) {
                return new WaystoneSettingsMenu(windowId, LandingStoneBlockEntity.this.getWaystone(), LandingStoneBlockEntity.this, LandingStoneBlockEntity.this.dataAccess, playerInventory);
            }

            public void writeScreenOpeningData(ServerPlayer player, FriendlyByteBuf buf) {
                buf.writeBlockPos(LandingStoneBlockEntity.this.worldPosition);
                Waystone.write(buf, LandingStoneBlockEntity.this.getWaystone());
            }
        };
    }

    @Override
    @Nullable
    public MenuProvider getSettingsMenuProvider() {
        return this.getMenuProvider();
    }

    @Override
    public boolean shouldPerformInitialAttunement() {
        return true;
    }
}

