/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.client.gui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.mixin.ScreenAccessor;
import net.blay09.mods.waystones.api.ExperienceCost;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.api.WaystoneTypes;
import net.blay09.mods.waystones.api.WaystoneVisibility;
import net.blay09.mods.waystones.client.gui.widget.ITooltipProvider;
import net.blay09.mods.waystones.client.gui.widget.RemoveWaystoneButton;
import net.blay09.mods.waystones.client.gui.widget.SortWaystoneButton;
import net.blay09.mods.waystones.client.gui.widget.WaystoneButton;
import net.blay09.mods.waystones.comparator.UserSortingComparator;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.core.WaystoneEditPermissions;
import net.blay09.mods.waystones.core.WaystonePermissionManager;
import net.blay09.mods.waystones.core.WaystoneTeleportManager;
import net.blay09.mods.waystones.menu.WaystoneSelectionMenu;
import net.blay09.mods.waystones.network.message.RemoveWaystoneMessage;
import net.blay09.mods.waystones.network.message.RequestEditWaystoneMessage;
import net.blay09.mods.waystones.network.message.SelectWaystoneMessage;
import net.blay09.mods.waystones.network.message.SortWaystoneMessage;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public abstract class WaystoneSelectionScreenBase
extends AbstractContainerScreen<WaystoneSelectionMenu> {
    private final Collection<IWaystone> waystones;
    private List<IWaystone> filteredWaystones;
    private final List<ITooltipProvider> tooltipProviders = new ArrayList<ITooltipProvider>();
    private String searchText = "";
    private Button btnPrevPage;
    private Button btnNextPage;
    private EditBox searchBox;
    private int pageOffset;
    private int headerY;
    private boolean isLocationHeaderHovered;
    private int buttonsPerPage;
    private static final int headerHeight = 64;
    private static final int footerHeight = 25;
    private static final int entryHeight = 25;

    public WaystoneSelectionScreenBase(WaystoneSelectionMenu container, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)container, playerInventory, title);
        this.waystones = container.getWaystones();
        PlayerWaystoneManager.ensureSortingIndex((Player)Minecraft.getInstance().player, this.waystones);
        this.filteredWaystones = new ArrayList<IWaystone>(this.waystones);
        Comparator<IWaystone> sorting = this.getSorting();
        if (sorting != null) {
            this.filteredWaystones.sort(this.getSorting());
        }
        this.imageWidth = 270;
        this.imageHeight = 200;
    }

    public void init() {
        int maxContentHeight = (int)((float)this.height * 0.6f);
        int maxButtonsPerPage = (maxContentHeight - 64 - 25) / 25;
        this.buttonsPerPage = Math.max(4, Math.min(maxButtonsPerPage, this.waystones.size()));
        int contentHeight = 64 + this.buttonsPerPage * 25 + 25;
        this.imageWidth = this.width;
        this.imageHeight = contentHeight;
        super.init();
        this.tooltipProviders.clear();
        this.btnPrevPage = Button.builder((Component)Component.translatable((String)"gui.waystones.waystone_selection.previous_page"), button -> {
            this.pageOffset = Screen.hasShiftDown() ? 0 : this.pageOffset - 1;
            this.updateList();
        }).pos(this.width / 2 - 100, this.height / 2 + 40).size(95, 20).build();
        this.addRenderableWidget(this.btnPrevPage);
        this.btnNextPage = Button.builder((Component)Component.translatable((String)"gui.waystones.waystone_selection.next_page"), button -> {
            this.pageOffset = Screen.hasShiftDown() ? (this.waystones.size() - 1) / this.buttonsPerPage : this.pageOffset + 1;
            this.updateList();
        }).pos(this.width / 2 + 5, this.height / 2 + 40).size(95, 20).build();
        this.addRenderableWidget(this.btnNextPage);
        this.updateList();
        this.searchBox = new EditBox(this.font, this.width / 2 - 99, this.topPos + 64 - 24, 198, 20, (Component)Component.empty());
        this.searchBox.setResponder(text -> {
            this.pageOffset = 0;
            this.searchText = text;
            this.updateList();
        });
        this.addRenderableWidget(this.searchBox);
    }

    protected <T extends GuiEventListener & Renderable> T addRenderableWidget(T widget) {
        if (widget instanceof ITooltipProvider) {
            this.tooltipProviders.add((ITooltipProvider)widget);
        }
        return (T)super.addRenderableWidget(widget);
    }

    private void updateList() {
        ArrayList<IWaystone> list = new ArrayList<IWaystone>();
        for (IWaystone iWaystone : this.waystones) {
            if (!iWaystone.getName().toLowerCase().contains(this.searchText.toLowerCase())) continue;
            list.add(iWaystone);
        }
        Comparator<IWaystone> sorting = this.getSorting();
        if (sorting != null) {
            list.sort(sorting);
        }
        this.filteredWaystones = list;
        this.headerY = 0;
        this.btnPrevPage.active = this.pageOffset > 0;
        this.btnNextPage.active = this.pageOffset < (this.filteredWaystones.size() - 1) / this.buttonsPerPage;
        this.tooltipProviders.clear();
        Predicate<Object> removePredicate = button -> button instanceof WaystoneButton || button instanceof SortWaystoneButton || button instanceof RemoveWaystoneButton;
        ((ScreenAccessor)this).balm_getChildren().removeIf(removePredicate);
        ((ScreenAccessor)this).balm_getNarratables().removeIf(removePredicate);
        ((ScreenAccessor)this).balm_getRenderables().removeIf(removePredicate);
        int y = this.topPos + 64 + this.headerY;
        for (int i = 0; i < this.buttonsPerPage; ++i) {
            int entryIndex = this.pageOffset * this.buttonsPerPage + i;
            if (entryIndex < 0 || entryIndex >= this.filteredWaystones.size()) continue;
            IWaystone waystone = this.filteredWaystones.get(entryIndex);
            this.addRenderableWidget(this.createWaystoneButton(y, waystone));
            if (this.allowSorting()) {
                SortWaystoneButton sortUpButton = new SortWaystoneButton(this.width / 2 + 108, y + 2, -1, y, 20, it -> this.sortWaystone(waystone, -1));
                if (entryIndex == 0) {
                    sortUpButton.active = false;
                }
                this.addRenderableWidget(sortUpButton);
                SortWaystoneButton sortDownButton = new SortWaystoneButton(this.width / 2 + 108, y + 13, 1, y, 20, it -> this.sortWaystone(waystone, 1));
                if (entryIndex == this.filteredWaystones.size() - 1) {
                    sortDownButton.active = false;
                }
                this.addRenderableWidget(sortDownButton);
            }
            if (this.allowDeletion(waystone)) {
                RemoveWaystoneButton removeButton = new RemoveWaystoneButton(this.width / 2 + 122, y + 4, y, 20, waystone, button -> {
                    LocalPlayer player = Minecraft.getInstance().player;
                    PlayerWaystoneManager.deactivateWaystone((Player)Objects.requireNonNull(player), waystone);
                    this.waystones.remove(waystone);
                    Balm.getNetworking().sendToServer((Object)new RemoveWaystoneMessage(waystone.getWaystoneUid()));
                    this.updateList();
                });
                this.addRenderableWidget(removeButton);
            }
            y += 22;
        }
        this.btnPrevPage.setY(this.topPos + this.headerY + 64 + this.buttonsPerPage * 22 + (this.filteredWaystones.size() > 0 ? 10 : 0));
        this.btnNextPage.setY(this.topPos + this.headerY + 64 + this.buttonsPerPage * 22 + (this.filteredWaystones.size() > 0 ? 10 : 0));
    }

    private boolean allowDeletion(IWaystone waystone) {
        if (waystone.getVisibility() == WaystoneVisibility.GLOBAL && !Minecraft.getInstance().player.getAbilities().instabuild) {
            return false;
        }
        if (!waystone.getWaystoneType().equals((Object)WaystoneTypes.WAYSTONE)) {
            return false;
        }
        return this.allowDeletion();
    }

    private WaystoneButton createWaystoneButton(int y, IWaystone waystone) {
        IWaystone waystoneFrom = ((WaystoneSelectionMenu)this.menu).getWaystoneFrom();
        LocalPlayer player = Minecraft.getInstance().player;
        ExperienceCost xpCost = WaystoneTeleportManager.predictExperienceLevelCost((Entity)Objects.requireNonNull(player), waystone, ((WaystoneSelectionMenu)this.menu).getWarpMode(), waystoneFrom);
        WaystoneButton btnWaystone = new WaystoneButton(this.width / 2 - 100, y, waystone, xpCost, button -> this.onWaystoneSelected(waystone));
        if (waystoneFrom != null && waystone.getWaystoneUid().equals(waystoneFrom.getWaystoneUid())) {
            btnWaystone.active = false;
        }
        return btnWaystone;
    }

    protected void onWaystoneSelected(IWaystone waystone) {
        Balm.getNetworking().sendToServer((Object)new SelectWaystoneMessage(waystone.getWaystoneUid()));
    }

    private void sortWaystone(IWaystone waystone, int sortDir) {
        UUID waystoneUid = waystone.getWaystoneUid();
        if (Screen.hasShiftDown()) {
            if (sortDir == -1) {
                PlayerWaystoneManager.sortWaystoneAsFirst((Player)Minecraft.getInstance().player, waystoneUid);
                Balm.getNetworking().sendToServer((Object)new SortWaystoneMessage(waystoneUid, SortWaystoneMessage.SORT_FIRST));
            } else if (sortDir == 1) {
                PlayerWaystoneManager.sortWaystoneAsLast((Player)Minecraft.getInstance().player, waystoneUid);
                Balm.getNetworking().sendToServer((Object)new SortWaystoneMessage(waystoneUid, SortWaystoneMessage.SORT_LAST));
            }
        } else {
            int index = this.filteredWaystones.indexOf(waystone);
            int otherIndex = index + sortDir;
            if (index == -1 || otherIndex < 0 || otherIndex >= this.waystones.size()) {
                return;
            }
            IWaystone otherWaystone = this.filteredWaystones.get(otherIndex);
            UUID otherWaystoneUid = otherWaystone.getWaystoneUid();
            PlayerWaystoneManager.sortWaystoneSwap((Player)Minecraft.getInstance().player, waystoneUid, otherWaystoneUid);
            Balm.getNetworking().sendToServer((Object)new SortWaystoneMessage(waystoneUid, otherWaystoneUid));
        }
        this.updateList();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (this.isLocationHeaderHovered && ((WaystoneSelectionMenu)this.menu).getWaystoneFrom() != null) {
            Balm.getNetworking().sendToServer((Object)new RequestEditWaystoneMessage(((WaystoneSelectionMenu)this.menu).getWaystoneFrom().getPos()));
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        for (ITooltipProvider tooltipProvider : this.tooltipProviders) {
            if (!tooltipProvider.shouldShowTooltip()) continue;
            guiGraphics.renderTooltip(Minecraft.getInstance().font, tooltipProvider.getTooltipComponents(), Optional.empty(), mouseX, mouseY);
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float p_230450_2_, int p_230450_3_, int p_230450_4_) {
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        Font font = Minecraft.getInstance().font;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        IWaystone fromWaystone = ((WaystoneSelectionMenu)this.menu).getWaystoneFrom();
        guiGraphics.drawCenteredString(font, this.getTitle(), this.imageWidth / 2, this.headerY + (fromWaystone != null ? 20 : 0), 0xFFFFFF);
        if (fromWaystone != null) {
            this.drawLocationHeader(guiGraphics, fromWaystone, mouseX, mouseY, this.imageWidth / 2, this.headerY);
        }
        if (this.waystones.size() == 0) {
            guiGraphics.drawCenteredString(font, ChatFormatting.RED + I18n.get((String)"gui.waystones.waystone_selection.no_waystones_activated", (Object[])new Object[0]), this.imageWidth / 2, this.imageHeight / 2 - 20, 0xFFFFFF);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void drawLocationHeader(GuiGraphics guiGraphics, IWaystone waystone, int mouseX, int mouseY, int x, int y) {
        font = Minecraft.getInstance().font;
        locationPrefix = ChatFormatting.YELLOW + I18n.get((String)"gui.waystones.waystone_selection.current_location", (Object[])new Object[0]) + " ";
        locationPrefixWidth = font.width(locationPrefix);
        effectiveName = waystone.getName();
        if (effectiveName.isEmpty()) {
            effectiveName = I18n.get((String)"gui.waystones.waystone_selection.unnamed_waystone", (Object[])new Object[0]);
        }
        locationWidth = font.width(effectiveName);
        fullWidth = locationPrefixWidth + locationWidth;
        startX = x - fullWidth / 2 + locationPrefixWidth;
        startY = y + this.topPos;
        if (mouseX < startX || mouseX >= startX + locationWidth + 16 || mouseY < startY) ** GOTO lbl-1000
        Objects.requireNonNull(font);
        if (mouseY < startY + 9) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        this.isLocationHeaderHovered = v0;
        player = Minecraft.getInstance().player;
        waystoneEditPermissions = WaystonePermissionManager.mayEditWaystone((Player)player, player.level(), waystone);
        fullText = locationPrefix + ChatFormatting.WHITE;
        if (this.isLocationHeaderHovered && waystoneEditPermissions == WaystoneEditPermissions.ALLOW) {
            fullText = fullText + ChatFormatting.UNDERLINE;
        }
        fullText = fullText + effectiveName;
        guiGraphics.drawString(font, fullText, x - fullWidth / 2, y, 0xFFFFFF);
        if (this.isLocationHeaderHovered && waystoneEditPermissions == WaystoneEditPermissions.ALLOW) {
            poseStack = guiGraphics.pose();
            poseStack.pushPose();
            scale = 0.5f;
            poseStack.translate((float)x + (float)fullWidth / 2.0f + 4.0f, (float)y, 0.0f);
            poseStack.scale(scale, scale, scale);
            guiGraphics.renderItem(new ItemStack((ItemLike)Items.WRITABLE_BOOK), 0, 0);
            poseStack.popPose();
        }
    }

    protected boolean allowSorting() {
        return true;
    }

    protected boolean allowDeletion() {
        return true;
    }

    public boolean keyPressed(int key, int scanCode, int modifiers) {
        if (!this.searchBox.isFocused() || key == 256 && this.shouldCloseOnEsc()) {
            return super.keyPressed(key, scanCode, modifiers);
        }
        return this.searchBox.keyPressed(key, scanCode, modifiers);
    }

    public Comparator<IWaystone> getSorting() {
        LocalPlayer player = Minecraft.getInstance().player;
        List<UUID> sortingIndex = PlayerWaystoneManager.getSortingIndex((Player)player);
        return new UserSortingComparator(sortingIndex);
    }
}

