/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.client.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import net.blay09.mods.waystones.api.ExperienceCost;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.api.WaystoneTypes;
import net.blay09.mods.waystones.api.WaystoneVisibility;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class WaystoneButton
extends Button {
    private static final ResourceLocation[] ENABLED_LEVEL_SPRITES = new ResourceLocation[]{new ResourceLocation("container/enchanting_table/level_1"), new ResourceLocation("container/enchanting_table/level_2"), new ResourceLocation("container/enchanting_table/level_3")};
    private static final ResourceLocation[] DISABLED_LEVEL_SPRITES = new ResourceLocation[]{new ResourceLocation("container/enchanting_table/level_1_disabled"), new ResourceLocation("container/enchanting_table/level_2_disabled"), new ResourceLocation("container/enchanting_table/level_3_disabled")};
    private final ExperienceCost xpCost;
    private final IWaystone waystone;

    public WaystoneButton(int x, int y, IWaystone waystone, ExperienceCost xpCost, Button.OnPress pressable) {
        super(x, y, 200, 20, WaystoneButton.getWaystoneNameComponent(waystone), pressable, Button.DEFAULT_NARRATION);
        LocalPlayer player = Minecraft.getInstance().player;
        this.xpCost = xpCost;
        this.waystone = waystone;
        if (player == null || !PlayerWaystoneManager.mayTeleportToWaystone((Player)player, waystone)) {
            this.active = false;
        } else if (!xpCost.canAfford((Player)player) && !player.getAbilities().instabuild) {
            this.active = false;
        }
    }

    private static Component getWaystoneNameComponent(IWaystone waystone) {
        String effectiveName = waystone.getName();
        if (effectiveName.isEmpty()) {
            effectiveName = I18n.get((String)"gui.waystones.waystone_selection.unnamed_waystone", (Object[])new Object[0]);
        }
        MutableComponent textComponent = Component.literal((String)effectiveName);
        if (waystone.getVisibility() == WaystoneVisibility.GLOBAL && waystone.getWaystoneType().equals((Object)WaystoneTypes.WAYSTONE)) {
            textComponent.withStyle(ChatFormatting.YELLOW);
        }
        return textComponent;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.renderWidget(guiGraphics, mouseX, mouseY, partialTicks);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft mc = Minecraft.getInstance();
        if (this.waystone.getDimension() == mc.player.level().dimension() && this.isActive()) {
            int distance = (int)mc.player.position().distanceTo(this.waystone.getPos().getCenter());
            String distanceStr = distance < 10000 && (mc.font.width((FormattedText)this.getMessage()) < 120 || distance < 1000) ? distance + "m" : String.format("%.1f", Float.valueOf((float)distance / 1000.0f)).replace(",0", "").replace(".0", "") + "km";
            int xOffset = this.getWidth() - mc.font.width(distanceStr);
            guiGraphics.drawString(mc.font, distanceStr, this.getX() + xOffset - 4, this.getY() + 6, 0xFFFFFF);
        }
        if (!this.xpCost.isEmpty()) {
            boolean canAfford = this.xpCost.canAfford((Player)mc.player);
            int xpCostAsLevels = this.xpCost.getCostAsLevels((Player)mc.player);
            int spriteIndex = Math.max(0, Math.min(xpCostAsLevels, 3) - 1);
            guiGraphics.blitSprite(canAfford ? ENABLED_LEVEL_SPRITES[spriteIndex] : DISABLED_LEVEL_SPRITES[spriteIndex], this.getX() + 2, this.getY() + 2, 16, 16);
            if (xpCostAsLevels > 3) {
                guiGraphics.drawString(mc.font, "+", this.getX() + 17, this.getY() + 6, 0xC8FF8F);
            }
            if (this.isHovered && mouseX <= this.getX() + 16) {
                ArrayList<Component> tooltip = new ArrayList<Component>();
                Component xpCostText = this.xpCost.getCostAsTooltip((Player)mc.player);
                if (xpCostText instanceof MutableComponent) {
                    MutableComponent mutableComponent = (MutableComponent)xpCostText;
                    mutableComponent.withStyle(canAfford ? ChatFormatting.GREEN : ChatFormatting.RED);
                }
                tooltip.add(xpCostText);
                Font font = mc.font;
                Optional optional = Optional.empty();
                Objects.requireNonNull(mc.font);
                guiGraphics.renderTooltip(font, tooltip, optional, mouseX, mouseY + 9);
            }
        }
    }
}

