/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.client.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import java.util.function.Supplier;
import net.blay09.mods.balm.mixin.AbstractContainerScreenAccessor;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.item.ModItems;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class WaystoneInventoryButton
extends Button {
    private static final ResourceLocation INVENTORY_BUTTON_TEXTURE = new ResourceLocation("waystones", "textures/gui/inventory_button.png");
    private final AbstractContainerScreen<?> parentScreen;
    private final ItemStack iconItem;
    private final ItemStack iconItemHovered;
    private final Supplier<Boolean> visiblePredicate;
    private final Supplier<Integer> xPosition;
    private final Supplier<Integer> yPosition;

    public WaystoneInventoryButton(AbstractContainerScreen<?> parentScreen, Button.OnPress pressable, Supplier<Boolean> visiblePredicate, Supplier<Integer> xPosition, Supplier<Integer> yPosition) {
        super(0, 0, 16, 16, (Component)Component.empty(), pressable, Button.DEFAULT_NARRATION);
        this.parentScreen = parentScreen;
        this.visiblePredicate = visiblePredicate;
        this.xPosition = xPosition;
        this.yPosition = yPosition;
        this.iconItem = new ItemStack((ItemLike)ModItems.boundScroll);
        this.iconItemHovered = new ItemStack((ItemLike)ModItems.warpScroll);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.visible = this.visiblePredicate.get();
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.visible) {
            this.setX(((AbstractContainerScreenAccessor)this.parentScreen).getLeftPos() + this.xPosition.get());
            this.setY(((AbstractContainerScreenAccessor)this.parentScreen).getTopPos() + this.yPosition.get());
            this.isHovered = mouseX >= this.getX() && mouseY >= this.getY() && mouseX < this.getX() + this.width && mouseY < this.getY() + this.height;
            LocalPlayer player = Minecraft.getInstance().player;
            if (PlayerWaystoneManager.canUseInventoryButton((Player)Objects.requireNonNull(player))) {
                ItemStack icon = this.isHovered ? this.iconItemHovered : this.iconItem;
                guiGraphics.renderItem(icon, this.getX(), this.getY());
                guiGraphics.renderItemDecorations(Minecraft.getInstance().font, icon, this.getX(), this.getY());
            } else {
                RenderSystem.enableBlend();
                guiGraphics.setColor(1.0f, 1.0f, 1.0f, 0.5f);
                guiGraphics.blit(INVENTORY_BUTTON_TEXTURE, this.getX(), this.getY(), 0.0f, 0.0f, 16, 16, 16, 16);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.disableBlend();
            }
        }
    }
}

