/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import java.util.List;
import net.blay09.mods.balm.api.command.BalmCommands;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.command.CountWaystonesCommand;
import net.blay09.mods.waystones.command.OpenPlayerWaystonesGuiCommand;
import net.blay09.mods.waystones.comparator.WaystoneComparators;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class ModCommands {
    public static void initialize(BalmCommands commands) {
        commands.register(dispatcher -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"waystones").requires(source -> source.isPlayer() && source.hasPermission(2))).then(Commands.literal((String)"count").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes((Command)new CountWaystonesCommand())))).then(Commands.literal((String)"list").then(((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(ctx -> {
            ServerPlayer caller = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            ServerPlayer target = ((EntitySelector)ctx.getArgument("player", EntitySelector.class)).findSinglePlayer((CommandSourceStack)ctx.getSource());
            List<IWaystone> waystones = PlayerWaystoneManager.getActivatedWaystones((Player)target).stream().filter(it -> it.isOwner((Player)target)).sorted(WaystoneComparators.forAdminInspection((Player)caller, (Player)target)).toList();
            ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.translatable((String)"commands.waystones.list.header", (Object[])new Object[]{target.getScoreboardName()}));
            for (IWaystone waystone : waystones) {
                ((CommandSourceStack)ctx.getSource()).sendSystemMessage(ModCommands.componentForWaystoneList(caller, target, waystone));
            }
            MutableComponent result = Component.translatable((String)"commands.waystones.list.footer", (Object[])new Object[]{waystones.size()});
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> result, false);
            return waystones.size();
        })).then(Commands.literal((String)"all").executes(ctx -> {
            ServerPlayer caller = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            ServerPlayer target = ((EntitySelector)ctx.getArgument("player", EntitySelector.class)).findSinglePlayer((CommandSourceStack)ctx.getSource());
            List<IWaystone> waystones = PlayerWaystoneManager.getActivatedWaystones((Player)target).stream().sorted(WaystoneComparators.forAdminInspection((Player)caller, (Player)target)).toList();
            ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.translatable((String)"commands.waystones.list.all.header", (Object[])new Object[]{target.getScoreboardName()}));
            for (IWaystone waystone : waystones) {
                ((CommandSourceStack)ctx.getSource()).sendSystemMessage(ModCommands.componentForWaystoneList(caller, target, waystone));
            }
            long ownedCount = waystones.stream().filter(it -> it.isOwner((Player)target)).count();
            MutableComponent result = Component.translatable((String)"commands.waystones.list.all.footer", (Object[])new Object[]{waystones.size(), ownedCount});
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> result, false);
            return waystones.size();
        }))))).then(Commands.literal((String)"gui").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes((Command)new OpenPlayerWaystonesGuiCommand())))));
    }

    private static Component componentForWaystoneList(ServerPlayer caller, ServerPlayer target, IWaystone waystone) {
        MutableComponent location;
        ResourceLocation waystoneDimensionId = waystone.getDimension().location();
        BlockPos waystonePos = waystone.getPos();
        if (waystone.getDimension() != caller.level().dimension()) {
            location = Component.translatable((String)"commands.waystones.list.in_dimension", (Object[])new Object[]{waystoneDimensionId});
        } else {
            int distance = (int)caller.position().distanceTo(waystonePos.getCenter());
            location = Component.translatable((String)"commands.waystones.list.at_distance", (Object[])new Object[]{distance});
        }
        String suggestedCommand = String.format("/execute in %s run teleport %d %d %d", waystoneDimensionId, waystonePos.getX(), waystonePos.getY(), waystonePos.getZ());
        MutableComponent coordinates = Component.translatable((String)"commands.waystones.list.coordinates", (Object[])new Object[]{waystonePos.getX(), waystonePos.getY(), waystonePos.getZ()}).withStyle(ChatFormatting.YELLOW).withStyle(Style.EMPTY.withClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, suggestedCommand)));
        MutableComponent waystoneName = Component.literal((String)waystone.getName()).withStyle(ChatFormatting.GREEN).withStyle(Style.EMPTY.withClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, suggestedCommand)));
        String entryKey = waystone.isOwner((Player)target) ? "commands.waystones.list.entry.owned" : "commands.waystones.list.entry.activated";
        return Component.translatable((String)entryKey, (Object[])new Object[]{location, coordinates, waystoneName});
    }
}

