/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.BalmEnvironment;
import net.blay09.mods.waystones.api.ExperienceCost;
import net.blay09.mods.waystones.api.IMutableWaystone;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.api.WaystoneActivatedEvent;
import net.blay09.mods.waystones.api.WaystoneTeleportError;
import net.blay09.mods.waystones.api.WaystoneTypes;
import net.blay09.mods.waystones.api.WaystoneVisibility;
import net.blay09.mods.waystones.block.entity.WaystoneBlockEntityBase;
import net.blay09.mods.waystones.config.DimensionalWarp;
import net.blay09.mods.waystones.config.InventoryButtonMode;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.blay09.mods.waystones.core.IPlayerWaystoneData;
import net.blay09.mods.waystones.core.InMemoryPlayerWaystoneData;
import net.blay09.mods.waystones.core.PersistentPlayerWaystoneData;
import net.blay09.mods.waystones.core.WarpMode;
import net.blay09.mods.waystones.core.WaystoneManager;
import net.blay09.mods.waystones.core.WaystoneSyncManager;
import net.blay09.mods.waystones.core.WaystoneTeleportManager;
import net.blay09.mods.waystones.tag.ModItemTags;
import net.blay09.mods.waystones.worldgen.namegen.NameGenerationMode;
import net.blay09.mods.waystones.worldgen.namegen.NameGenerator;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class PlayerWaystoneManager {
    private static final Logger logger = LogManager.getLogger();
    private static final IPlayerWaystoneData persistentPlayerWaystoneData = new PersistentPlayerWaystoneData();
    private static final IPlayerWaystoneData inMemoryPlayerWaystoneData = new InMemoryPlayerWaystoneData();

    public static boolean isWaystoneActivated(Player player, IWaystone waystone) {
        return PlayerWaystoneManager.getPlayerWaystoneData(player.level()).isWaystoneActivated(player, waystone);
    }

    public static void activateWaystone(Player player, IWaystone waystone) {
        if (!waystone.hasName() && waystone instanceof IMutableWaystone && waystone.wasGenerated()) {
            NameGenerationMode nameGenerationMode = WaystonesConfig.getActive().worldGen.nameGenerationMode;
            String name = NameGenerator.get(player.getServer()).getName((LevelAccessor)player.level(), waystone, player.level().random, nameGenerationMode);
            ((IMutableWaystone)((Object)waystone)).setName(name);
        }
        if (!waystone.hasOwner() && waystone instanceof IMutableWaystone) {
            ((IMutableWaystone)((Object)waystone)).setOwnerUid(player.getUUID());
        }
        if (player.getServer() != null) {
            WaystoneManager.get(player.getServer()).setDirty();
        }
        if (!PlayerWaystoneManager.isWaystoneActivated(player, waystone) && waystone.getWaystoneType().equals((Object)WaystoneTypes.WAYSTONE)) {
            PlayerWaystoneManager.getPlayerWaystoneData(player.level()).activateWaystone(player, waystone);
            Balm.getEvents().fireEvent((Object)new WaystoneActivatedEvent(player, waystone));
        }
    }

    @Nullable
    public static IWaystone getInventoryButtonTarget(Player player) {
        InventoryButtonMode inventoryButtonMode = WaystonesConfig.getActive().getInventoryButtonMode();
        if (inventoryButtonMode.isReturnToNearest()) {
            return PlayerWaystoneManager.getNearestWaystone(player);
        }
        if (inventoryButtonMode.hasNamedTarget()) {
            return WaystoneManager.get(player.getServer()).findWaystoneByName(inventoryButtonMode.getNamedTarget()).orElse(null);
        }
        return null;
    }

    public static boolean canUseInventoryButton(Player player) {
        IWaystone waystone = PlayerWaystoneManager.getInventoryButtonTarget(player);
        ExperienceCost xpCost = waystone != null ? WaystoneTeleportManager.predictExperienceLevelCost((Entity)player, waystone, WarpMode.INVENTORY_BUTTON, null) : ExperienceCost.NoExperienceCost.INSTANCE;
        return PlayerWaystoneManager.getInventoryButtonCooldownLeft(player) <= 0L && xpCost.canAfford(player);
    }

    public static boolean canUseWarpStone(Player player, ItemStack heldItem) {
        return PlayerWaystoneManager.getWarpStoneCooldownLeft(player) <= 0L;
    }

    public static double getCooldownMultiplier(IWaystone waystone) {
        return waystone.getVisibility() == WaystoneVisibility.GLOBAL ? WaystonesConfig.getActive().cooldowns.globalWaystoneCooldownMultiplier : 1.0;
    }

    private static void informPlayer(Entity entity, String translationKey) {
        if (entity instanceof Player) {
            MutableComponent chatComponent = Component.translatable((String)translationKey);
            chatComponent.withStyle(ChatFormatting.RED);
            ((Player)entity).displayClientMessage((Component)chatComponent, false);
        }
    }

    public static Consumer<WaystoneTeleportError> informRejectedTeleport(Entity entityToInform) {
        return error -> {
            logger.info("Rejected teleport: " + error.getClass().getSimpleName());
            if (error.getTranslationKey() != null) {
                PlayerWaystoneManager.informPlayer(entityToInform, error.getTranslationKey());
            }
        };
    }

    public static void applyCooldown(WarpMode warpMode, Player player, int cooldown) {
        if (cooldown > 0) {
            Level level = player.level();
            switch (warpMode) {
                case INVENTORY_BUTTON: {
                    PlayerWaystoneManager.getPlayerWaystoneData(level).setInventoryButtonCooldownUntil(player, System.currentTimeMillis() + (long)cooldown * 1000L);
                    break;
                }
                case WARP_STONE: {
                    PlayerWaystoneManager.getPlayerWaystoneData(level).setWarpStoneCooldownUntil(player, System.currentTimeMillis() + (long)cooldown * 1000L);
                }
            }
            WaystoneSyncManager.sendWaystoneCooldowns(player);
        }
    }

    public static int getCooldownPeriod(WarpMode warpMode, IWaystone waystone) {
        return (int)((double)PlayerWaystoneManager.getCooldownPeriod(warpMode) * PlayerWaystoneManager.getCooldownMultiplier(waystone));
    }

    private static int getCooldownPeriod(WarpMode warpMode) {
        return switch (warpMode) {
            case WarpMode.INVENTORY_BUTTON -> WaystonesConfig.getActive().cooldowns.inventoryButtonCooldown;
            case WarpMode.WARP_STONE -> WaystonesConfig.getActive().cooldowns.warpStoneCooldown;
            default -> 0;
        };
    }

    public static boolean canDimensionalWarpBetween(Entity player, IWaystone waystone) {
        ResourceLocation fromDimension = player.level().dimension().location();
        ResourceLocation toDimension = waystone.getDimension().location();
        List<String> dimensionAllowList = WaystonesConfig.getActive().restrictions.dimensionalWarpAllowList;
        List<String> dimensionDenyList = WaystonesConfig.getActive().restrictions.dimensionalWarpDenyList;
        if (!(dimensionAllowList.isEmpty() || dimensionAllowList.contains(toDimension.toString()) && dimensionAllowList.contains(fromDimension.toString()))) {
            return false;
        }
        if (!dimensionDenyList.isEmpty() && (dimensionDenyList.contains(toDimension.toString()) || dimensionDenyList.contains(fromDimension.toString()))) {
            return false;
        }
        DimensionalWarp dimensionalWarpMode = WaystonesConfig.getActive().restrictions.dimensionalWarp;
        return dimensionalWarpMode == DimensionalWarp.ALLOW || dimensionalWarpMode == DimensionalWarp.GLOBAL_ONLY && waystone.getVisibility() == WaystoneVisibility.GLOBAL;
    }

    public static ItemStack findWarpItem(Entity entity, WarpMode warpMode) {
        return switch (warpMode) {
            case WarpMode.WARP_SCROLL -> PlayerWaystoneManager.findWarpItem(entity, ModItemTags.WARP_SCROLLS);
            case WarpMode.WARP_STONE -> PlayerWaystoneManager.findWarpItem(entity, ModItemTags.WARP_STONES);
            case WarpMode.RETURN_SCROLL -> PlayerWaystoneManager.findWarpItem(entity, ModItemTags.RETURN_SCROLLS);
            case WarpMode.BOUND_SCROLL -> PlayerWaystoneManager.findWarpItem(entity, ModItemTags.BOUND_SCROLLS);
            default -> ItemStack.EMPTY;
        };
    }

    private static ItemStack findWarpItem(Entity entity, TagKey<Item> warpItemTag) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (livingEntity.getMainHandItem().is(warpItemTag)) {
                return livingEntity.getMainHandItem();
            }
            if (livingEntity.getOffhandItem().is(warpItemTag)) {
                return livingEntity.getOffhandItem();
            }
        }
        return ItemStack.EMPTY;
    }

    public static void deactivateWaystone(Player player, IWaystone waystone) {
        PlayerWaystoneManager.getPlayerWaystoneData(player.level()).deactivateWaystone(player, waystone);
    }

    public static boolean canUseWarpMode(Entity entity, WarpMode warpMode, ItemStack heldItem, @Nullable IWaystone fromWaystone) {
        return switch (warpMode) {
            default -> throw new IncompatibleClassChangeError();
            case WarpMode.INVENTORY_BUTTON -> {
                if (entity instanceof Player && PlayerWaystoneManager.canUseInventoryButton((Player)entity)) {
                    yield true;
                }
                yield false;
            }
            case WarpMode.WARP_SCROLL -> {
                if (!heldItem.isEmpty() && heldItem.is(ModItemTags.WARP_SCROLLS)) {
                    yield true;
                }
                yield false;
            }
            case WarpMode.BOUND_SCROLL -> {
                if (!heldItem.isEmpty() && heldItem.is(ModItemTags.BOUND_SCROLLS)) {
                    yield true;
                }
                yield false;
            }
            case WarpMode.RETURN_SCROLL -> {
                if (!heldItem.isEmpty() && heldItem.is(ModItemTags.RETURN_SCROLLS)) {
                    yield true;
                }
                yield false;
            }
            case WarpMode.WARP_STONE -> {
                if (!heldItem.isEmpty() && heldItem.is(ModItemTags.WARP_STONES) && entity instanceof Player && PlayerWaystoneManager.canUseWarpStone((Player)entity, heldItem)) {
                    yield true;
                }
                yield false;
            }
            case WarpMode.WAYSTONE_TO_WAYSTONE -> {
                if (WaystonesConfig.getActive().restrictions.allowWaystoneToWaystoneTeleport && fromWaystone != null && fromWaystone.isValid() && fromWaystone.getWaystoneType().equals((Object)WaystoneTypes.WAYSTONE)) {
                    yield true;
                }
                yield false;
            }
            case WarpMode.SHARESTONE_TO_SHARESTONE -> {
                if (fromWaystone != null && fromWaystone.isValid() && WaystoneTypes.isSharestone(fromWaystone.getWaystoneType())) {
                    yield true;
                }
                yield false;
            }
            case WarpMode.WARP_PLATE -> {
                if (fromWaystone != null && fromWaystone.isValid() && fromWaystone.getWaystoneType().equals((Object)WaystoneTypes.WARP_PLATE)) {
                    yield true;
                }
                yield false;
            }
            case WarpMode.PORTSTONE_TO_WAYSTONE -> {
                if (fromWaystone != null && fromWaystone.isValid() && fromWaystone.getWaystoneType().equals((Object)WaystoneTypes.PORTSTONE)) {
                    yield true;
                }
                yield false;
            }
            case WarpMode.CUSTOM -> true;
        };
    }

    public static long getWarpStoneCooldownUntil(Player player) {
        return PlayerWaystoneManager.getPlayerWaystoneData(player.level()).getWarpStoneCooldownUntil(player);
    }

    public static long getWarpStoneCooldownLeft(Player player) {
        long cooldownUntil = PlayerWaystoneManager.getWarpStoneCooldownUntil(player);
        return Math.max(0L, cooldownUntil - System.currentTimeMillis());
    }

    public static void setWarpStoneCooldownUntil(Player player, long timeStamp) {
        PlayerWaystoneManager.getPlayerWaystoneData(player.level()).setWarpStoneCooldownUntil(player, timeStamp);
    }

    public static long getInventoryButtonCooldownUntil(Player player) {
        return PlayerWaystoneManager.getPlayerWaystoneData(player.level()).getInventoryButtonCooldownUntil(player);
    }

    public static long getInventoryButtonCooldownLeft(Player player) {
        long cooldownUntil = PlayerWaystoneManager.getInventoryButtonCooldownUntil(player);
        return Math.max(0L, cooldownUntil - System.currentTimeMillis());
    }

    public static void setInventoryButtonCooldownUntil(Player player, long timeStamp) {
        PlayerWaystoneManager.getPlayerWaystoneData(player.level()).setInventoryButtonCooldownUntil(player, timeStamp);
    }

    @Nullable
    public static IWaystone getNearestWaystone(Player player) {
        return PlayerWaystoneManager.getPlayerWaystoneData(player.level()).getWaystones(player).stream().filter(it -> it.getDimension() == player.level().dimension()).min((first, second) -> {
            double firstDist = first.getPos().distToCenterSqr(player.getX(), player.getY(), player.getZ());
            double secondDist = second.getPos().distToCenterSqr(player.getX(), player.getY(), player.getZ());
            return (int)Math.round(firstDist) - (int)Math.round(secondDist);
        }).orElse(null);
    }

    public static Collection<IWaystone> getActivatedWaystones(Player player) {
        return PlayerWaystoneManager.getPlayerWaystoneData(player.level()).getWaystones(player);
    }

    public static IPlayerWaystoneData getPlayerWaystoneData(@Nullable Level world) {
        return world == null || world.isClientSide ? inMemoryPlayerWaystoneData : persistentPlayerWaystoneData;
    }

    public static IPlayerWaystoneData getPlayerWaystoneData(BalmEnvironment side) {
        return side.isClient() ? inMemoryPlayerWaystoneData : persistentPlayerWaystoneData;
    }

    public static boolean mayTeleportToWaystone(Player player, IWaystone waystone) {
        return true;
    }

    public static List<UUID> getSortingIndex(Player player) {
        return PlayerWaystoneManager.getPlayerWaystoneData(player.level()).getSortingIndex(player);
    }

    public static List<UUID> ensureSortingIndex(Player player, Collection<IWaystone> waystones) {
        return PlayerWaystoneManager.getPlayerWaystoneData(player.level()).ensureSortingIndex(player, waystones);
    }

    public static void sortWaystoneAsFirst(Player player, UUID waystoneUid) {
        PlayerWaystoneManager.getPlayerWaystoneData(player.level()).sortWaystoneAsFirst(player, waystoneUid);
    }

    public static void sortWaystoneAsLast(Player player, UUID waystoneUid) {
        PlayerWaystoneManager.getPlayerWaystoneData(player.level()).sortWaystoneAsLast(player, waystoneUid);
    }

    public static void sortWaystoneSwap(Player player, UUID waystoneUid, UUID otherWaystoneUid) {
        PlayerWaystoneManager.getPlayerWaystoneData(player.level()).sortWaystoneSwap(player, waystoneUid, otherWaystoneUid);
    }

    public static boolean mayEditGlobalWaystones(Player player) {
        return player.getAbilities().instabuild || !WaystonesConfig.getActive().restrictions.globalWaystoneSetupRequiresCreativeMode;
    }

    public static void activeWaystoneForEveryone(@Nullable MinecraftServer server, IWaystone waystone) {
        if (server == null) {
            return;
        }
        List players = server.getPlayerList().getPlayers();
        for (ServerPlayer player : players) {
            if (PlayerWaystoneManager.isWaystoneActivated((Player)player, waystone)) continue;
            PlayerWaystoneManager.activateWaystone((Player)player, waystone);
        }
    }

    public static void removeKnownWaystone(@Nullable MinecraftServer server, IWaystone waystone) {
        if (server == null) {
            return;
        }
        List players = server.getPlayerList().getPlayers();
        for (ServerPlayer player : players) {
            PlayerWaystoneManager.deactivateWaystone((Player)player, waystone);
            WaystoneSyncManager.sendActivatedWaystones((Player)player);
        }
    }

    public static Collection<IWaystone> getTargetsForPlayer(Player player) {
        return PlayerWaystoneManager.getActivatedWaystones(player);
    }

    public static Collection<IWaystone> getTargetsForItem(Player player, ItemStack itemStack) {
        return PlayerWaystoneManager.getActivatedWaystones(player);
    }

    public static Collection<IWaystone> getTargetsForWaystone(Player player, IWaystone waystone) {
        ResourceLocation waystoneType = waystone.getWaystoneType();
        ArrayList<IWaystone> result = new ArrayList<IWaystone>();
        if (WaystoneTypes.isSharestone(waystoneType)) {
            result.addAll(WaystoneManager.get(player.getServer()).getWaystonesByType(waystoneType).toList());
        } else {
            result.addAll(PlayerWaystoneManager.getActivatedWaystones(player));
        }
        BlockEntity blockEntity = player.level().getBlockEntity(waystone.getPos());
        if (blockEntity instanceof WaystoneBlockEntityBase) {
            WaystoneBlockEntityBase waystoneBlockEntity = (WaystoneBlockEntityBase)blockEntity;
            result.addAll(waystoneBlockEntity.getAuxiliaryTargets());
        }
        return result;
    }

    public static Collection<IWaystone> getTargetsForInventoryButton(ServerPlayer player) {
        return PlayerWaystoneManager.getActivatedWaystones((Player)player);
    }
}

