/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.core;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.blay09.mods.waystones.api.IMutableWaystone;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.api.TeleportDestination;
import net.blay09.mods.waystones.api.WaystoneOrigin;
import net.blay09.mods.waystones.api.WaystoneTypes;
import net.blay09.mods.waystones.api.WaystoneVisibility;
import net.blay09.mods.waystones.block.WaystoneBlock;
import net.blay09.mods.waystones.tag.ModBlockTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Waystone
implements IWaystone,
IMutableWaystone {
    private final ResourceLocation waystoneType;
    private final UUID waystoneUid;
    private final WaystoneOrigin origin;
    private ResourceKey<Level> dimension;
    private BlockPos pos;
    private String name = "";
    private WaystoneVisibility visibility;
    private UUID ownerUid;

    public Waystone(ResourceLocation waystoneType, UUID waystoneUid, ResourceKey<Level> dimension, BlockPos pos, WaystoneOrigin origin, @Nullable UUID ownerUid) {
        this.waystoneType = waystoneType;
        this.waystoneUid = waystoneUid;
        this.dimension = dimension;
        this.pos = pos;
        this.origin = origin;
        this.ownerUid = ownerUid;
        this.visibility = WaystoneTypes.isSharestone(waystoneType) ? WaystoneVisibility.GLOBAL : (waystoneType.equals((Object)WaystoneTypes.WARP_PLATE) ? WaystoneVisibility.SHARD_ONLY : (waystoneType.equals((Object)WaystoneTypes.LANDING_STONE) ? WaystoneVisibility.SHARD_ONLY : WaystoneVisibility.ACTIVATION));
    }

    @Override
    public UUID getWaystoneUid() {
        return this.waystoneUid;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public ResourceKey<Level> getDimension() {
        return this.dimension;
    }

    @Override
    public WaystoneOrigin getOrigin() {
        return this.origin;
    }

    @Override
    public boolean isGlobal() {
        return this.visibility == WaystoneVisibility.GLOBAL;
    }

    @Override
    public void setGlobal(boolean global) {
        this.visibility = global ? WaystoneVisibility.GLOBAL : WaystoneVisibility.ACTIVATION;
    }

    @Override
    public WaystoneVisibility getVisibility() {
        return this.visibility;
    }

    @Override
    public void setVisibility(WaystoneVisibility visibility) {
        this.visibility = visibility;
    }

    @Override
    public boolean isOwner(Player player) {
        return this.ownerUid == null || player.getGameProfile().getId().equals(this.ownerUid) || player.getAbilities().instabuild;
    }

    @Override
    public void setOwnerUid(@Nullable UUID ownerUid) {
        this.ownerUid = ownerUid;
    }

    @Override
    public BlockPos getPos() {
        return this.pos;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public UUID getOwnerUid() {
        return this.ownerUid;
    }

    @Override
    public void setDimension(ResourceKey<Level> dimension) {
        this.dimension = dimension;
    }

    @Override
    public void setPos(BlockPos pos) {
        this.pos = pos;
    }

    @Override
    public ResourceLocation getWaystoneType() {
        return this.waystoneType;
    }

    @Override
    public boolean isValidInLevel(ServerLevel level) {
        BlockState state = level.getBlockState(this.pos);
        return state.is(ModBlockTags.IS_TELEPORT_TARGET);
    }

    @Override
    public TeleportDestination resolveDestination(ServerLevel level) {
        BlockState state = level.getBlockState(this.pos);
        Direction direction = (Direction)state.getValue((Property)WaystoneBlock.FACING);
        ArrayList directionCandidates = Lists.newArrayList((Object[])new Direction[]{direction, Direction.EAST, Direction.WEST, Direction.SOUTH, Direction.NORTH});
        for (Direction candidate : directionCandidates) {
            BlockPos offsetPos = this.pos.relative(candidate);
            BlockPos offsetPosUp = offsetPos.above();
            if (level.getBlockState(offsetPos).isSuffocating((BlockGetter)level, offsetPos) || level.getBlockState(offsetPosUp).isSuffocating((BlockGetter)level, offsetPosUp)) continue;
            direction = candidate;
            break;
        }
        BlockPos targetPos = this.getWaystoneType().equals((Object)WaystoneTypes.WARP_PLATE) || this.getWaystoneType().equals((Object)WaystoneTypes.LANDING_STONE) ? this.getPos() : this.getPos().relative(direction);
        Vec3 location = new Vec3((double)targetPos.getX() + 0.5, (double)targetPos.getY() + 0.5, (double)targetPos.getZ() + 0.5);
        return new TeleportDestination(level, location, direction);
    }

    public static List<IWaystone> readList(FriendlyByteBuf buf) {
        int size = buf.readShort();
        ArrayList<IWaystone> waystones = new ArrayList<IWaystone>(size);
        for (int i = 0; i < size; ++i) {
            waystones.add(Waystone.read(buf));
        }
        return waystones;
    }

    public static IWaystone read(FriendlyByteBuf buf) {
        UUID waystoneUid = buf.readUUID();
        ResourceLocation waystoneType = buf.readResourceLocation();
        String name = buf.readUtf();
        WaystoneVisibility visibility = (WaystoneVisibility)buf.readEnum(WaystoneVisibility.class);
        ResourceKey dimension = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)new ResourceLocation(buf.readUtf(250)));
        BlockPos pos = buf.readBlockPos();
        WaystoneOrigin origin = (WaystoneOrigin)buf.readEnum(WaystoneOrigin.class);
        Waystone waystone = new Waystone(waystoneType, waystoneUid, (ResourceKey<Level>)dimension, pos, origin, null);
        waystone.setName(name);
        waystone.setVisibility(visibility);
        return waystone;
    }

    public static IWaystone read(CompoundTag compound) {
        WaystoneOrigin origin;
        UUID waystoneUid = NbtUtils.loadUUID((Tag)Objects.requireNonNull(compound.get("WaystoneUid")));
        String name = compound.getString("Name");
        ResourceKey dimensionType = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)new ResourceLocation(compound.getString("World")));
        BlockPos pos = NbtUtils.readBlockPos((CompoundTag)compound.getCompound("BlockPos"));
        boolean wasGenerated = compound.getBoolean("WasGenerated");
        WaystoneOrigin waystoneOrigin = origin = wasGenerated ? WaystoneOrigin.WILDERNESS : WaystoneOrigin.UNKNOWN;
        if (compound.contains("Origin")) {
            try {
                origin = WaystoneOrigin.valueOf(compound.getString("Origin"));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        UUID ownerUid = compound.contains("OwnerUid") ? NbtUtils.loadUUID((Tag)Objects.requireNonNull(compound.get("OwnerUid"))) : null;
        ResourceLocation waystoneType = compound.contains("Type") ? new ResourceLocation(compound.getString("Type")) : WaystoneTypes.WAYSTONE;
        Waystone waystone = new Waystone(waystoneType, waystoneUid, (ResourceKey<Level>)dimensionType, pos, origin, ownerUid);
        waystone.setName(name);
        if (compound.contains("Visibility")) {
            waystone.setVisibility(WaystoneVisibility.valueOf(compound.getString("Visibility")));
        } else {
            waystone.setVisibility(compound.getBoolean("IsGlobal") ? WaystoneVisibility.GLOBAL : WaystoneVisibility.ACTIVATION);
        }
        return waystone;
    }

    public static void writeList(FriendlyByteBuf buf, Collection<IWaystone> waystones) {
        buf.writeShort(waystones.size());
        for (IWaystone waystone : waystones) {
            Waystone.write(buf, waystone);
        }
    }

    public static void write(FriendlyByteBuf buf, IWaystone waystone) {
        buf.writeUUID(waystone.getWaystoneUid());
        buf.writeResourceLocation(waystone.getWaystoneType());
        buf.writeUtf(waystone.getName());
        buf.writeEnum((Enum)waystone.getVisibility());
        buf.writeResourceLocation(waystone.getDimension().location());
        buf.writeBlockPos(waystone.getPos());
        buf.writeEnum((Enum)waystone.getOrigin());
    }

    public static CompoundTag write(IWaystone waystone, CompoundTag compound) {
        compound.put("WaystoneUid", (Tag)NbtUtils.createUUID((UUID)waystone.getWaystoneUid()));
        compound.putString("Type", waystone.getWaystoneType().toString());
        compound.putString("Name", waystone.getName());
        compound.putString("World", waystone.getDimension().location().toString());
        compound.put("BlockPos", (Tag)NbtUtils.writeBlockPos((BlockPos)waystone.getPos()));
        compound.putString("Origin", waystone.getOrigin().name());
        if (waystone.getOwnerUid() != null) {
            compound.put("OwnerUid", (Tag)NbtUtils.createUUID((UUID)waystone.getOwnerUid()));
        }
        compound.putString("Visibility", waystone.getVisibility().name());
        return compound;
    }
}

