/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.core;

import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.waystones.api.ExperienceCost;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.api.IWaystoneTeleportContext;
import net.blay09.mods.waystones.api.TeleportDestination;
import net.blay09.mods.waystones.api.WaystoneTeleportError;
import net.blay09.mods.waystones.api.WaystoneTeleportEvent;
import net.blay09.mods.waystones.api.WaystoneVisibility;
import net.blay09.mods.waystones.api.WaystonesAPI;
import net.blay09.mods.waystones.block.entity.WarpPlateBlockEntity;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.core.WarpMode;
import net.blay09.mods.waystones.core.WaystoneTeleportContext;
import net.blay09.mods.waystones.network.message.TeleportEffectMessage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetExperiencePacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class WaystoneTeleportManager {
    public static Collection<? extends Entity> findPets(Entity entity) {
        return entity.level().getEntitiesOfClass(TamableAnimal.class, new AABB(entity.blockPosition()).inflate(10.0), pet -> entity.getUUID().equals(pet.getOwnerUUID()) && !pet.isOrderedToSit());
    }

    public static List<Mob> findLeashedAnimals(Entity player) {
        return player.level().getEntitiesOfClass(Mob.class, new AABB(player.blockPosition()).inflate(10.0), e -> player.equals((Object)e.getLeashHolder()));
    }

    public static ExperienceCost predictExperienceLevelCost(Entity player, IWaystone waystone, WarpMode warpMode, @Nullable IWaystone fromWaystone) {
        WaystoneTeleportContext context = new WaystoneTeleportContext(player, waystone, null);
        context.getLeashedEntities().addAll(WaystoneTeleportManager.findLeashedAnimals(player));
        context.setFromWaystone(fromWaystone);
        context.setWarpMode(warpMode);
        return WaystoneTeleportManager.getExperienceLevelCost(context);
    }

    public static ExperienceCost getExperienceLevelCost(IWaystoneTeleportContext context) {
        int xpCost = WaystoneTeleportManager.getExperienceLevelCost(context.getEntity(), context.getTargetWaystone(), context.getWarpMode(), context);
        if (WaystonesConfig.getActive().xpCost.xpCostsFullLevels) {
            return ExperienceCost.fromLevels(xpCost);
        }
        return ExperienceCost.fromExperience(xpCost);
    }

    @Deprecated
    public static int getExperienceLevelCost(Entity entity, IWaystone waystone, WarpMode warpMode, IWaystoneTeleportContext context) {
        double xpLevelCost;
        if (!(entity instanceof Player)) {
            return 0;
        }
        Player player = (Player)entity;
        if (context.getFromWaystone() != null && waystone.getWaystoneUid().equals(context.getFromWaystone().getWaystoneUid())) {
            return 0;
        }
        boolean enableXPCost = !player.getAbilities().instabuild;
        int xpForLeashed = WaystonesConfig.getActive().xpCost.xpCostPerLeashed * context.getLeashedEntities().size();
        double xpCostMultiplier = warpMode.getXpCostMultiplier();
        if (waystone.getVisibility() == WaystoneVisibility.GLOBAL) {
            xpCostMultiplier *= WaystonesConfig.getActive().xpCost.globalWaystoneXpCostMultiplier;
        }
        BlockPos pos = waystone.getPos();
        double dist = Math.sqrt(player.distanceToSqr((double)pos.getX(), player.getY(), (double)pos.getZ()));
        double minimumXpCost = WaystonesConfig.getActive().xpCost.minimumBaseXpCost;
        double maximumXpCost = WaystonesConfig.getActive().xpCost.maximumBaseXpCost;
        if (waystone.getDimension() != player.level().dimension()) {
            int dimensionalWarpXpCost = WaystonesConfig.getActive().xpCost.dimensionalWarpXpCost;
            xpLevelCost = Mth.clamp((double)dimensionalWarpXpCost, (double)minimumXpCost, (double)dimensionalWarpXpCost);
        } else if (WaystonesConfig.getActive().xpCost.blocksPerXpLevel > 0) {
            xpLevelCost = Mth.clamp((double)Math.floor(dist / (double)WaystonesConfig.getActive().xpCost.blocksPerXpLevel), (double)minimumXpCost, (double)maximumXpCost);
            if (WaystonesConfig.getActive().xpCost.inverseXpCost) {
                xpLevelCost = maximumXpCost - xpLevelCost;
            }
        } else {
            xpLevelCost = minimumXpCost;
        }
        return enableXPCost ? (int)Math.round((xpLevelCost + (double)xpForLeashed) * xpCostMultiplier) : 0;
    }

    public static List<Entity> doTeleport(IWaystoneTeleportContext context) {
        List<Entity> teleportedEntities = WaystoneTeleportManager.teleportEntityAndAttached(context.getEntity(), context);
        context.getAdditionalEntities().forEach(additionalEntity -> teleportedEntities.addAll(WaystoneTeleportManager.teleportEntityAndAttached(additionalEntity, context)));
        ServerLevel sourceWorld = (ServerLevel)context.getEntity().level();
        BlockPos sourcePos = context.getEntity().blockPosition();
        TeleportDestination destination = context.getDestination();
        ServerLevel targetLevel = destination.getLevel();
        BlockPos targetPos = BlockPos.containing((Position)destination.getLocation());
        BlockEntity targetTileEntity = targetLevel.getBlockEntity(targetPos);
        if (targetTileEntity instanceof WarpPlateBlockEntity) {
            WarpPlateBlockEntity warpPlate = (WarpPlateBlockEntity)targetTileEntity;
            teleportedEntities.forEach(warpPlate::markEntityForCooldown);
        }
        if (context.playsSound()) {
            sourceWorld.playSound(context.getEntity(), sourcePos, SoundEvents.PORTAL_TRAVEL, SoundSource.PLAYERS, 0.01f, 1.0f);
            targetLevel.playSound(null, targetPos, SoundEvents.PORTAL_TRAVEL, SoundSource.PLAYERS, 0.05f, 1.0f);
        }
        if (context.playsEffect()) {
            teleportedEntities.forEach(additionalEntity -> Balm.getNetworking().sendToTracking(sourceWorld, sourcePos, (Object)new TeleportEffectMessage(sourcePos)));
            Balm.getNetworking().sendToTracking(targetLevel, targetPos, (Object)new TeleportEffectMessage(targetPos));
        }
        return teleportedEntities;
    }

    private static List<Entity> teleportEntityAndAttached(Entity entity, IWaystoneTeleportContext context) {
        ArrayList<Entity> teleportedEntities = new ArrayList<Entity>();
        TeleportDestination destination = context.getDestination();
        ServerLevel targetLevel = destination.getLevel();
        Vec3 targetLocation = destination.getLocation();
        Direction targetDirection = destination.getDirection();
        Entity mount = entity.getVehicle();
        Entity teleportedMount = null;
        if (mount != null) {
            teleportedMount = WaystoneTeleportManager.teleportEntity(mount, targetLevel, targetLocation, targetDirection);
            teleportedEntities.add(teleportedMount);
        }
        List<Mob> leashedEntities = context.getLeashedEntities();
        ArrayList teleportedLeashedEntities = new ArrayList();
        leashedEntities.forEach(leashedEntity -> {
            Entity teleportedLeashedEntity = WaystoneTeleportManager.teleportEntity((Entity)leashedEntity, targetLevel, targetLocation, targetDirection);
            teleportedEntities.add(teleportedLeashedEntity);
            teleportedLeashedEntities.add(teleportedLeashedEntity);
        });
        Entity teleportedEntity = WaystoneTeleportManager.teleportEntity(entity, targetLevel, targetLocation, targetDirection);
        teleportedEntities.add(teleportedEntity);
        teleportedLeashedEntities.forEach(teleportedLeashedEntity -> {
            if (teleportedLeashedEntity instanceof Mob) {
                Mob teleportedLeashedMob = (Mob)teleportedLeashedEntity;
                teleportedLeashedMob.setLeashedTo(teleportedEntity, true);
            }
        });
        if (teleportedMount != null) {
            // empty if block
        }
        return teleportedEntities;
    }

    private static Entity teleportEntity(Entity entity, ServerLevel targetWorld, Vec3 targetPos3d, Direction direction) {
        float yaw = direction.toYRot();
        double x = targetPos3d.x;
        double y = targetPos3d.y;
        double z = targetPos3d.z;
        if (entity instanceof ServerPlayer) {
            ChunkPos chunkPos = new ChunkPos(BlockPos.containing((double)x, (double)y, (double)z));
            targetWorld.getChunkSource().addRegionTicket(TicketType.POST_TELEPORT, chunkPos, 1, (Object)entity.getId());
            entity.stopRiding();
            if (((ServerPlayer)entity).isSleeping()) {
                ((ServerPlayer)entity).stopSleepInBed(true, true);
            }
            if (targetWorld == entity.level()) {
                ((ServerPlayer)entity).connection.teleport(x, y, z, yaw, entity.getXRot(), Collections.emptySet());
            } else {
                ((ServerPlayer)entity).teleportTo(targetWorld, x, y, z, yaw, entity.getXRot());
            }
            entity.setYHeadRot(yaw);
        } else {
            float pitch = Mth.clamp((float)entity.getXRot(), (float)-90.0f, (float)90.0f);
            if (targetWorld == entity.level()) {
                entity.moveTo(x, y, z, yaw, pitch);
                entity.setYHeadRot(yaw);
            } else {
                entity.unRide();
                Entity oldEntity = entity;
                entity = entity.getType().create((Level)targetWorld);
                if (entity == null) {
                    return oldEntity;
                }
                entity.restoreFrom(oldEntity);
                entity.moveTo(x, y, z, yaw, pitch);
                entity.setYHeadRot(yaw);
                oldEntity.setRemoved(Entity.RemovalReason.CHANGED_DIMENSION);
                targetWorld.addDuringTeleport(entity);
            }
        }
        if (!(entity instanceof LivingEntity) || !((LivingEntity)entity).isFallFlying()) {
            entity.setDeltaMovement(entity.getDeltaMovement().multiply(1.0, 0.0, 1.0));
            entity.setOnGround(true);
        }
        if (entity instanceof PathfinderMob) {
            ((PathfinderMob)entity).getNavigation().stop();
        }
        WaystoneTeleportManager.sendHackySyncPacketsAfterTeleport(entity);
        return entity;
    }

    private static void sendHackySyncPacketsAfterTeleport(Entity entity) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            player.connection.send((Packet)new ClientboundSetExperiencePacket(player.experienceProgress, player.totalExperience, player.experienceLevel));
        }
    }

    public static Either<List<Entity>, WaystoneTeleportError> tryTeleportToWaystone(Entity entity, IWaystone waystone, WarpMode warpMode, @Nullable IWaystone fromWaystone) {
        return WaystonesAPI.createDefaultTeleportContext(entity, waystone, warpMode, fromWaystone).flatMap(WaystoneTeleportManager::tryTeleport).ifRight(PlayerWaystoneManager.informRejectedTeleport(entity));
    }

    public static Either<List<Entity>, WaystoneTeleportError> tryTeleport(IWaystoneTeleportContext context) {
        boolean isCreativeMode;
        WarpMode warpMode;
        WaystoneTeleportEvent.Pre event = new WaystoneTeleportEvent.Pre(context);
        Balm.getEvents().fireEvent((Object)event);
        if (event.isCanceled()) {
            return Either.right((Object)new WaystoneTeleportError.CancelledByEvent());
        }
        IWaystone waystone = context.getTargetWaystone();
        Entity entity = context.getEntity();
        if (!PlayerWaystoneManager.canUseWarpMode(entity, warpMode = context.getWarpMode(), context.getWarpItem(), context.getFromWaystone())) {
            return Either.right((Object)new WaystoneTeleportError.WarpModeRejected());
        }
        if (context.isDimensionalTeleport() && !event.getDimensionalTeleportResult().withDefault(() -> PlayerWaystoneManager.canDimensionalWarpBetween(entity, waystone))) {
            return Either.right((Object)new WaystoneTeleportError.DimensionalWarpDenied());
        }
        if (!context.getLeashedEntities().isEmpty()) {
            if (!WaystonesConfig.getActive().restrictions.transportLeashed) {
                return Either.right((Object)new WaystoneTeleportError.LeashedWarpDenied());
            }
            List<ResourceLocation> forbidden = WaystonesConfig.getActive().restrictions.leashedDenyList.stream().map(ResourceLocation::new).toList();
            if (context.getLeashedEntities().stream().anyMatch(e -> forbidden.contains(BuiltInRegistries.ENTITY_TYPE.getKey((Object)e.getType())))) {
                return Either.right((Object)new WaystoneTeleportError.SpecificLeashedWarpDenied());
            }
            if (context.isDimensionalTeleport() && !WaystonesConfig.getActive().restrictions.transportLeashedDimensional) {
                return Either.right((Object)new WaystoneTeleportError.LeashedDimensionalWarpDenied());
            }
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!context.getExperienceCost().canAfford(player)) {
                return Either.right((Object)new WaystoneTeleportError.NotEnoughXp());
            }
        }
        boolean bl = isCreativeMode = entity instanceof Player && ((Player)entity).getAbilities().instabuild;
        if (!context.getWarpItem().isEmpty() && event.getConsumeItemResult().withDefault(() -> !isCreativeMode && context.consumesWarpItem())) {
            context.getWarpItem().shrink(1);
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            PlayerWaystoneManager.applyCooldown(warpMode, player, context.getCooldown());
            context.getExperienceCost().consume(player);
        }
        List<Entity> teleportedEntities = WaystoneTeleportManager.doTeleport(context);
        Balm.getEvents().fireEvent((Object)new WaystoneTeleportEvent.Post(context, teleportedEntities));
        return Either.left(teleportedEntities);
    }
}

