/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.item;

import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.waystones.api.IAttunementItem;
import net.blay09.mods.waystones.api.IFOVOnUse;
import net.blay09.mods.waystones.api.IResetUseOnDamage;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.api.WaystonesAPI;
import net.blay09.mods.waystones.block.entity.WaystoneBlockEntity;
import net.blay09.mods.waystones.compat.Compat;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.core.WarpMode;
import net.blay09.mods.waystones.core.WaystoneProxy;
import net.blay09.mods.waystones.core.WaystoneTeleportManager;
import net.blay09.mods.waystones.item.ScrollItemBase;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class BoundScrollItem
extends ScrollItemBase
implements IResetUseOnDamage,
IFOVOnUse,
IAttunementItem {
    public BoundScrollItem(Item.Properties properties) {
        super(properties);
    }

    public int getUseDuration(ItemStack itemStack) {
        return WaystonesConfig.getActive().cooldowns.scrollUseTime;
    }

    @Deprecated
    public static void setBoundTo(ItemStack itemStack, @Nullable IWaystone entry) {
        WaystonesAPI.setBoundWaystone(itemStack, entry);
    }

    @Deprecated
    @Nullable
    protected IWaystone getBoundTo(Player player, ItemStack itemStack) {
        return this.getWaystoneAttunedTo(player.getServer(), itemStack);
    }

    @Override
    public void setWaystoneAttunedTo(ItemStack itemStack, @Nullable IWaystone waystone) {
        CompoundTag tagCompound = itemStack.getTag();
        if (tagCompound == null) {
            tagCompound = new CompoundTag();
            itemStack.setTag(tagCompound);
        }
        if (waystone != null) {
            tagCompound.put("WaystonesBoundTo", (Tag)NbtUtils.createUUID((UUID)waystone.getWaystoneUid()));
        } else {
            tagCompound.remove("WaystonesBoundTo");
        }
    }

    @Override
    @Nullable
    public IWaystone getWaystoneAttunedTo(@Nullable MinecraftServer server, ItemStack itemStack) {
        CompoundTag tagCompound = itemStack.getTag();
        if (tagCompound != null && tagCompound.contains("WaystonesBoundTo", 11)) {
            return new WaystoneProxy(server, NbtUtils.loadUUID((Tag)Objects.requireNonNull(tagCompound.get("WaystonesBoundTo"))));
        }
        return null;
    }

    protected WarpMode getWarpMode() {
        return WarpMode.BOUND_SCROLL;
    }

    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        if (player == null) {
            return InteractionResult.PASS;
        }
        ItemStack heldItem = player.getItemInHand(context.getHand());
        Level world = context.getLevel();
        BlockEntity tileEntity = world.getBlockEntity(context.getClickedPos());
        if (tileEntity instanceof WaystoneBlockEntity) {
            IWaystone waystone = ((WaystoneBlockEntity)tileEntity).getWaystone();
            if (!PlayerWaystoneManager.isWaystoneActivated(player, waystone)) {
                PlayerWaystoneManager.activateWaystone(player, waystone);
            }
            if (!world.isClientSide) {
                ItemStack boundItem = heldItem.getCount() == 1 ? heldItem : heldItem.split(1);
                WaystonesAPI.setBoundWaystone(boundItem, waystone);
                if (boundItem != heldItem && !player.addItem(boundItem)) {
                    player.drop(boundItem, false);
                }
                MutableComponent chatComponent = Component.translatable((String)"chat.waystones.scroll_bound", (Object[])new Object[]{waystone.getName()});
                chatComponent.withStyle(ChatFormatting.YELLOW);
                player.displayClientMessage((Component)chatComponent, true);
                world.playSound(null, context.getClickedPos(), SoundEvents.PLAYER_LEVELUP, SoundSource.BLOCKS, 0.2f, 2.0f);
            }
            return !world.isClientSide ? InteractionResult.SUCCESS : InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }

    public ItemStack finishUsingItem(ItemStack stack, Level world, LivingEntity entity) {
        Player player;
        IWaystone boundTo;
        if (!world.isClientSide && entity instanceof ServerPlayer && (boundTo = this.getBoundTo(player = (Player)entity, stack)) != null) {
            double distance = entity.distanceToSqr((double)boundTo.getPos().getX(), (double)boundTo.getPos().getY(), (double)boundTo.getPos().getZ());
            if (distance <= 3.0) {
                return stack;
            }
            WaystoneTeleportManager.tryTeleportToWaystone((Entity)player, boundTo, this.getWarpMode(), null);
        }
        return stack;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        IWaystone boundTo = this.getBoundTo(player, itemStack);
        if (boundTo != null) {
            if (!player.isUsingItem() && world.isClientSide) {
                world.playSound(null, (Entity)player, SoundEvents.PORTAL_TRIGGER, SoundSource.PLAYERS, 0.1f, 2.0f);
            }
            if (this.getUseDuration(itemStack) <= 0 || Compat.isVivecraftInstalled) {
                this.finishUsingItem(itemStack, world, (LivingEntity)player);
            } else {
                player.startUsingItem(hand);
            }
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemStack);
        }
        MutableComponent chatComponent = Component.translatable((String)"chat.waystones.scroll_not_yet_bound");
        chatComponent.withStyle(ChatFormatting.RED);
        player.displayClientMessage((Component)chatComponent, true);
        return new InteractionResultHolder(InteractionResult.FAIL, (Object)itemStack);
    }

    public void appendHoverText(ItemStack stack, @Nullable Level world, List<Component> list, TooltipFlag flag) {
        MutableComponent targetText;
        Player player = Balm.getProxy().getClientPlayer();
        if (player == null) {
            return;
        }
        IWaystone boundTo = this.getBoundTo(player, stack);
        MutableComponent mutableComponent = targetText = boundTo != null ? Component.literal((String)boundTo.getName()) : Component.translatable((String)"tooltip.waystones.bound_to_none");
        if (boundTo != null) {
            targetText.withStyle(ChatFormatting.AQUA);
        }
        MutableComponent boundToText = Component.translatable((String)"tooltip.waystones.bound_to", (Object[])new Object[]{targetText});
        boundToText.withStyle(ChatFormatting.GRAY);
        list.add((Component)boundToText);
    }
}

