/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.item;

import java.util.Collection;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.menu.BalmMenuProvider;
import net.blay09.mods.waystones.api.IResetUseOnDamage;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.compat.Compat;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.core.WarpMode;
import net.blay09.mods.waystones.core.Waystone;
import net.blay09.mods.waystones.item.ScrollItemBase;
import net.blay09.mods.waystones.menu.ModMenus;
import net.blay09.mods.waystones.menu.WaystoneSelectionMenu;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class WarpScrollItem
extends ScrollItemBase
implements IResetUseOnDamage {
    public WarpScrollItem(Item.Properties properties) {
        super(properties);
    }

    public int getUseDuration(ItemStack itemStack) {
        return WaystonesConfig.getActive().cooldowns.scrollUseTime;
    }

    public ItemStack finishUsingItem(ItemStack itemStack, Level world, LivingEntity entity) {
        if (!world.isClientSide && entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            final Collection<IWaystone> waystones = PlayerWaystoneManager.getTargetsForItem((Player)player, itemStack);
            PlayerWaystoneManager.ensureSortingIndex((Player)player, waystones);
            Balm.getNetworking().openGui((Player)((ServerPlayer)entity), (MenuProvider)new BalmMenuProvider(){

                public Component getDisplayName() {
                    return Component.translatable((String)"container.waystones.waystone_selection");
                }

                public AbstractContainerMenu createMenu(int windowId, Inventory playerInventory, Player player) {
                    return new WaystoneSelectionMenu((MenuType<WaystoneSelectionMenu>)((MenuType)ModMenus.warpScrollSelection.get()), WarpMode.WARP_SCROLL, null, windowId, waystones);
                }

                public void writeScreenOpeningData(ServerPlayer player, FriendlyByteBuf buf) {
                    Waystone.writeList(buf, waystones);
                }
            });
        }
        return itemStack;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (!player.isUsingItem() && !world.isClientSide) {
            world.playSound(null, (Entity)player, SoundEvents.PORTAL_TRIGGER, SoundSource.PLAYERS, 0.1f, 2.0f);
        }
        if (this.getUseDuration(itemStack) <= 0 || Compat.isVivecraftInstalled) {
            this.finishUsingItem(itemStack, world, (LivingEntity)player);
        } else {
            player.startUsingItem(hand);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemStack);
    }

    public boolean isFoil(ItemStack itemStack) {
        return true;
    }
}

