/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.menu;

import java.util.List;
import net.blay09.mods.balm.api.DeferredObject;
import net.blay09.mods.balm.api.menu.BalmMenus;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.block.entity.SharestoneBlockEntity;
import net.blay09.mods.waystones.block.entity.WarpPlateBlockEntity;
import net.blay09.mods.waystones.block.entity.WaystoneBlockEntity;
import net.blay09.mods.waystones.block.entity.WaystoneBlockEntityBase;
import net.blay09.mods.waystones.core.WarpMode;
import net.blay09.mods.waystones.core.Waystone;
import net.blay09.mods.waystones.menu.WarpPlateMenu;
import net.blay09.mods.waystones.menu.WaystoneSelectionMenu;
import net.blay09.mods.waystones.menu.WaystoneSettingsMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class ModMenus {
    public static DeferredObject<MenuType<WaystoneSelectionMenu>> waystoneSelection;
    public static DeferredObject<MenuType<WaystoneSelectionMenu>> warpScrollSelection;
    public static DeferredObject<MenuType<WaystoneSelectionMenu>> warpStoneSelection;
    public static DeferredObject<MenuType<WaystoneSelectionMenu>> portstoneSelection;
    public static DeferredObject<MenuType<WaystoneSelectionMenu>> inventorySelection;
    public static DeferredObject<MenuType<WaystoneSelectionMenu>> adminSelection;
    public static DeferredObject<MenuType<WaystoneSelectionMenu>> sharestoneSelection;
    public static DeferredObject<MenuType<WarpPlateMenu>> warpPlate;
    public static DeferredObject<MenuType<WaystoneSettingsMenu>> waystoneSettings;

    public static void initialize(BalmMenus menus) {
        waystoneSelection = menus.registerMenu(ModMenus.id("waystone_selection"), (windowId, inventory, buf) -> {
            BlockPos pos = buf.readBlockPos();
            List<IWaystone> waystones = Waystone.readList(buf);
            BlockEntity blockEntity = inventory.player.level().getBlockEntity(pos);
            if (blockEntity instanceof WaystoneBlockEntity) {
                WaystoneBlockEntity waystone = (WaystoneBlockEntity)blockEntity;
                return new WaystoneSelectionMenu((MenuType<WaystoneSelectionMenu>)((MenuType)waystoneSelection.get()), WarpMode.WAYSTONE_TO_WAYSTONE, waystone.getWaystone(), windowId, waystones);
            }
            return null;
        });
        warpScrollSelection = menus.registerMenu(ModMenus.id("warp_scroll_selection"), (windowId, inventory, buf) -> {
            List<IWaystone> waystones = Waystone.readList(buf);
            return new WaystoneSelectionMenu((MenuType<WaystoneSelectionMenu>)((MenuType)warpScrollSelection.get()), WarpMode.WARP_SCROLL, null, windowId, waystones);
        });
        warpStoneSelection = menus.registerMenu(ModMenus.id("warp_stone_selection"), (windowId, inventory, buf) -> {
            List<IWaystone> waystones = Waystone.readList(buf);
            return new WaystoneSelectionMenu((MenuType<WaystoneSelectionMenu>)((MenuType)warpStoneSelection.get()), WarpMode.WARP_STONE, null, windowId, waystones);
        });
        portstoneSelection = menus.registerMenu(ModMenus.id("portstone_selection"), (windowId, inventory, buf) -> {
            List<IWaystone> waystones = Waystone.readList(buf);
            return new WaystoneSelectionMenu((MenuType<WaystoneSelectionMenu>)((MenuType)waystoneSelection.get()), WarpMode.PORTSTONE_TO_WAYSTONE, null, windowId, waystones);
        });
        sharestoneSelection = menus.registerMenu(ModMenus.id("sharestone_selection"), (syncId, inventory, buf) -> {
            BlockPos pos = buf.readBlockPos();
            List<IWaystone> waystones = Waystone.readList(buf);
            BlockEntity blockEntity = inventory.player.level().getBlockEntity(pos);
            if (blockEntity instanceof SharestoneBlockEntity) {
                SharestoneBlockEntity sharestone = (SharestoneBlockEntity)blockEntity;
                return new WaystoneSelectionMenu((MenuType<WaystoneSelectionMenu>)((MenuType)sharestoneSelection.get()), WarpMode.SHARESTONE_TO_SHARESTONE, sharestone.getWaystone(), syncId, waystones);
            }
            return null;
        });
        inventorySelection = menus.registerMenu(ModMenus.id("inventory_selection"), (syncId, inventory, buf) -> {
            List<IWaystone> waystones = Waystone.readList(buf);
            return new WaystoneSelectionMenu((MenuType<WaystoneSelectionMenu>)((MenuType)inventorySelection.get()), WarpMode.INVENTORY_BUTTON, null, syncId, waystones);
        });
        adminSelection = menus.registerMenu(ModMenus.id("admin_selection"), (syncId, inventory, buf) -> {
            List<IWaystone> waystones = Waystone.readList(buf);
            return new WaystoneSelectionMenu((MenuType<WaystoneSelectionMenu>)((MenuType)adminSelection.get()), WarpMode.CUSTOM, null, syncId, waystones);
        });
        warpPlate = menus.registerMenu(ModMenus.id("warp_plate"), (windowId, inv, data) -> {
            BlockPos pos = data.readBlockPos();
            BlockEntity blockEntity = inv.player.level().getBlockEntity(pos);
            if (blockEntity instanceof WarpPlateBlockEntity) {
                WarpPlateBlockEntity warpPlate = (WarpPlateBlockEntity)blockEntity;
                return new WarpPlateMenu(windowId, warpPlate, warpPlate.getContainerData(), inv);
            }
            return null;
        });
        waystoneSettings = menus.registerMenu(ModMenus.id("waystone_settings"), (windowId, inv, data) -> {
            BlockPos pos = data.readBlockPos();
            IWaystone waystone = Waystone.read(data);
            BlockEntity blockEntity = inv.player.level().getBlockEntity(pos);
            if (blockEntity instanceof WaystoneBlockEntityBase) {
                WaystoneBlockEntityBase waystoneBlockEntity = (WaystoneBlockEntityBase)blockEntity;
                return new WaystoneSettingsMenu(windowId, waystone, waystoneBlockEntity, waystoneBlockEntity.getContainerData(), inv);
            }
            return null;
        });
    }

    @NotNull
    private static ResourceLocation id(String name) {
        return new ResourceLocation("waystones", name);
    }
}

