/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.network.message;

import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.block.entity.WaystoneBlockEntityBase;
import net.blay09.mods.waystones.core.WaystoneEditPermissions;
import net.blay09.mods.waystones.core.WaystonePermissionManager;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;

public class RequestEditWaystoneMessage {
    private final BlockPos pos;

    public RequestEditWaystoneMessage(BlockPos pos) {
        this.pos = pos;
    }

    public static void encode(RequestEditWaystoneMessage message, FriendlyByteBuf buf) {
        buf.writeBlockPos(message.pos);
    }

    public static RequestEditWaystoneMessage decode(FriendlyByteBuf buf) {
        BlockPos pos = buf.readBlockPos();
        return new RequestEditWaystoneMessage(pos);
    }

    public static void handle(ServerPlayer player, RequestEditWaystoneMessage message) {
        BlockPos pos = message.pos;
        if (player.distanceToSqr((double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f)) > 64.0) {
            return;
        }
        BlockEntity blockEntity = player.level().getBlockEntity(pos);
        if (blockEntity instanceof WaystoneBlockEntityBase) {
            WaystoneBlockEntityBase waystoneBlockEntity = (WaystoneBlockEntityBase)blockEntity;
            IWaystone waystone = waystoneBlockEntity.getWaystone();
            WaystoneEditPermissions permissions = WaystonePermissionManager.mayEditWaystone((Player)player, player.level(), waystone);
            if (permissions != WaystoneEditPermissions.ALLOW) {
                return;
            }
            MenuProvider menuProvider = waystoneBlockEntity.getSettingsMenuProvider();
            if (menuProvider != null) {
                Balm.getNetworking().openGui((Player)player, menuProvider);
            }
        }
    }
}

