/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.network.message;

import java.util.UUID;
import net.blay09.mods.waystones.Waystones;
import net.blay09.mods.waystones.core.WaystoneProxy;
import net.blay09.mods.waystones.core.WaystoneTeleportManager;
import net.blay09.mods.waystones.menu.WaystoneSelectionMenu;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class SelectWaystoneMessage {
    private final UUID waystoneUid;

    public SelectWaystoneMessage(UUID waystoneUid) {
        this.waystoneUid = waystoneUid;
    }

    public static void encode(SelectWaystoneMessage message, FriendlyByteBuf buf) {
        buf.writeUUID(message.waystoneUid);
    }

    public static SelectWaystoneMessage decode(FriendlyByteBuf buf) {
        UUID waystoneUid = buf.readUUID();
        return new SelectWaystoneMessage(waystoneUid);
    }

    public static void handle(ServerPlayer player, SelectWaystoneMessage message) {
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (!(abstractContainerMenu instanceof WaystoneSelectionMenu)) {
            return;
        }
        WaystoneSelectionMenu selectionMenu = (WaystoneSelectionMenu)abstractContainerMenu;
        WaystoneProxy waystone = new WaystoneProxy(player.server, message.waystoneUid);
        if (selectionMenu.getWaystones().stream().noneMatch(it -> it.getWaystoneUid().equals(waystone.getWaystoneUid()))) {
            Waystones.logger.warn("{} tried to teleport to waystone {} that they don't have access to.", (Object)player.getName().getString(), (Object)waystone.getWaystoneUid());
            return;
        }
        WaystoneTeleportManager.tryTeleportToWaystone((Entity)player, waystone, selectionMenu.getWarpMode(), selectionMenu.getWaystoneFrom());
        player.closeContainer();
    }
}

