/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.worldgen.namegen;

import java.util.HashMap;
import java.util.Map;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.worldgen.namegen.INameGenerator;
import net.blay09.mods.waystones.worldgen.namegen.LiteralNameGenerator;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;

public class TemplateNameGenerator
implements INameGenerator {
    private final String template;
    private final Map<String, INameGenerator> placeholders = new HashMap<String, INameGenerator>();

    public TemplateNameGenerator(String template) {
        this.template = template;
    }

    public TemplateNameGenerator with(String key, INameGenerator nameGenerator) {
        this.placeholders.put(key, nameGenerator);
        return this;
    }

    public TemplateNameGenerator with(String key, String value) {
        return this.with(key, new LiteralNameGenerator(value));
    }

    @Override
    public String generateName(LevelAccessor level, IWaystone waystone, RandomSource rand) {
        String result = this.template;
        for (Map.Entry<String, INameGenerator> entry : this.placeholders.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue().generateName(level, waystone, rand);
            if (value == null) continue;
            result = result.replaceAll("\\{" + key + "}", value);
        }
        return result;
    }
}

