/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.xp;

import net.blay09.mods.waystones.api.ExperienceCost;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

public class ExperiencePointsCost
implements ExperienceCost {
    private final int points;

    public ExperiencePointsCost(int points) {
        this.points = Math.max(0, points);
    }

    @Override
    public boolean canAfford(Player player) {
        double xpForProgress;
        int xpForLevel = ExperiencePointsCost.getCumulativeXpNeededForLevel(player.experienceLevel);
        double totalXp = (double)xpForLevel + (xpForProgress = Math.floor(player.experienceProgress * (float)ExperiencePointsCost.getXpNeededForNextLevel(player.experienceLevel)));
        return totalXp >= (double)this.points;
    }

    @Override
    public void consume(Player player) {
        player.giveExperiencePoints(-this.points);
    }

    @Override
    public int getCostAsLevels(Player player) {
        return ExperiencePointsCost.calculateLevelCostFromExperiencePoints(player.experienceLevel, this.points);
    }

    @Override
    public Component getCostAsTooltip(Player player) {
        return Component.translatable((String)"gui.waystones.waystone_selection.xp_requirement", (Object[])new Object[]{this.points});
    }

    @Override
    public boolean isEmpty() {
        return this.points == 0;
    }

    private static int calculateLevelCostFromExperiencePoints(int currentLevel, int xpLoss) {
        return currentLevel - ExperiencePointsCost.calculateLevelMinusExperiencePoints(currentLevel, xpLoss);
    }

    private static int calculateLevelMinusExperiencePoints(int currentLevel, int xpLoss) {
        int currentCumulativeXp = ExperiencePointsCost.getCumulativeXpNeededForLevel(currentLevel);
        int remainingXp = currentCumulativeXp - xpLoss;
        int newLevel = 0;
        int newCumulativeXp = 0;
        for (int level = 0; level <= currentLevel; ++level) {
            if (remainingXp >= (newCumulativeXp += ExperiencePointsCost.getXpNeededForNextLevel(level))) continue;
            newLevel = level;
            break;
        }
        return newLevel;
    }

    private static int getXpNeededForNextLevel(int level) {
        if (level >= 30) {
            return 112 + (level - 30) * 9;
        }
        return level >= 15 ? 37 + (level - 15) * 5 : 7 + level * 2;
    }

    private static int getCumulativeXpNeededForLevel(int targetLevel) {
        int currentCumulativeXp = 0;
        for (int level = 0; level < targetLevel; ++level) {
            currentCumulativeXp += ExperiencePointsCost.getXpNeededForNextLevel(level);
        }
        return currentCumulativeXp;
    }
}

