/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.block.entity;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.menu.BalmMenuProvider;
import net.blay09.mods.waystones.api.MutableWaystone;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.api.WaystoneOrigin;
import net.blay09.mods.waystones.api.WaystoneTeleportContext;
import net.blay09.mods.waystones.api.WaystoneTypes;
import net.blay09.mods.waystones.api.WaystonesAPI;
import net.blay09.mods.waystones.api.error.WaystoneTeleportError;
import net.blay09.mods.waystones.block.WarpPlateBlock;
import net.blay09.mods.waystones.block.entity.ModBlockEntities;
import net.blay09.mods.waystones.block.entity.WaystoneBlockEntityBase;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.blay09.mods.waystones.core.InvalidWaystone;
import net.blay09.mods.waystones.core.WaystonePermissionManager;
import net.blay09.mods.waystones.core.WaystoneSyncManager;
import net.blay09.mods.waystones.menu.WarpPlateMenu;
import net.blay09.mods.waystones.tag.ModItemTags;
import net.blay09.mods.waystones.worldgen.namegen.NameGenerationMode;
import net.blay09.mods.waystones.worldgen.namegen.NameGeneratorManager;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class WarpPlateBlockEntity
extends WaystoneBlockEntityBase
implements Nameable {
    private final WeakHashMap<Entity, Integer> ticksPassedPerEntity = new WeakHashMap();
    private final Random random = new Random();
    private int lastAttunementSlot;
    private Component customName;

    public WarpPlateBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.warpPlate.get(), blockPos, blockState);
    }

    @Override
    public void initializeWaystone(ServerLevelAccessor world, @Nullable LivingEntity player, WaystoneOrigin origin) {
        super.initializeWaystone(world, player, origin);
        Waystone waystone = this.getWaystone();
        if (waystone instanceof MutableWaystone) {
            Component name = NameGeneratorManager.get(world.getServer()).getName((LevelAccessor)world, waystone, world.getRandom(), NameGenerationMode.RANDOM_ONLY);
            ((MutableWaystone)((Object)waystone)).setName(name);
        }
        WaystoneSyncManager.sendWaystoneUpdateToAll(world.getServer(), waystone);
    }

    @Override
    protected ResourceLocation getWaystoneType() {
        return WaystoneTypes.WARP_PLATE;
    }

    @Override
    public void saveAdditional(CompoundTag tag) {
        super.saveAdditional(tag);
        if (this.customName != null) {
            tag.putString("CustomName", Component.Serializer.toJson((Component)this.customName));
        }
        tag.putInt("LastAttunementSlot", this.lastAttunementSlot);
    }

    @Override
    public void load(CompoundTag compound) {
        super.load(compound);
        if (compound.contains("CustomName")) {
            this.customName = Component.Serializer.fromJson((String)compound.getString("CustomName"));
        }
        this.lastAttunementSlot = compound.getInt("LastAttunementSlot");
    }

    @Override
    public MenuProvider getMenuProvider() {
        return this.getSettingsMenuProvider();
    }

    @Override
    public MenuProvider getSettingsMenuProvider() {
        return new BalmMenuProvider(){

            public Component getDisplayName() {
                return WarpPlateBlockEntity.this.getDisplayName();
            }

            public AbstractContainerMenu createMenu(int i, Inventory playerInventory, Player player) {
                return new WarpPlateMenu(i, WarpPlateBlockEntity.this, WarpPlateBlockEntity.this.dataAccess, playerInventory);
            }

            public void writeScreenOpeningData(ServerPlayer player, FriendlyByteBuf buf) {
                buf.writeBlockPos(WarpPlateBlockEntity.this.worldPosition);
            }
        };
    }

    public void onEntityCollision(Entity entity) {
        if (WaystonePermissionManager.isEntityDeniedTeleports(entity)) {
            return;
        }
        Integer ticksPassed = this.ticksPassedPerEntity.putIfAbsent(entity, 0);
        if (ticksPassed == null || ticksPassed != -1) {
            Waystone targetWaystone = this.getTargetWaystone().orElse(InvalidWaystone.INSTANCE);
            WarpPlateBlock.WarpPlateStatus status = targetWaystone.isValid() ? WarpPlateBlock.WarpPlateStatus.ACTIVE : WarpPlateBlock.WarpPlateStatus.INVALID;
            Boolean canAfford = WaystonesAPI.createDefaultTeleportContext(entity, targetWaystone, it -> it.setFromWaystone(this.getWaystone())).mapLeft(WaystoneTeleportContext::getRequirements).mapLeft(it -> {
                boolean bl;
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    if (!player.getAbilities().instabuild && !it.canAfford(player)) {
                        bl = false;
                        return bl;
                    }
                }
                bl = true;
                return bl;
            }).left().orElse(true);
            this.level.setBlock(this.worldPosition, (BlockState)this.getBlockState().setValue(WarpPlateBlock.STATUS, (Comparable)((Object)(canAfford != false ? status : WarpPlateBlock.WarpPlateStatus.INVALID))), 3);
        }
    }

    private boolean isEntityOnWarpPlate(Entity entity) {
        return entity.getX() >= (double)this.worldPosition.getX() && entity.getX() < (double)(this.worldPosition.getX() + 1) && entity.getY() >= (double)this.worldPosition.getY() && entity.getY() < (double)(this.worldPosition.getY() + 1) && entity.getZ() >= (double)this.worldPosition.getZ() && entity.getZ() < (double)(this.worldPosition.getZ() + 1);
    }

    @Override
    public void serverTick() {
        AABB boundsAbove;
        List entities;
        super.serverTick();
        if (this.getBlockState().getValue(WarpPlateBlock.STATUS) != WarpPlateBlock.WarpPlateStatus.IDLE && (entities = this.level.getEntities((Entity)null, boundsAbove = new AABB((double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ(), (double)(this.worldPosition.getX() + 1), (double)(this.worldPosition.getY() + 1), (double)(this.worldPosition.getZ() + 1)), EntitySelector.ENTITY_STILL_ALIVE)).isEmpty()) {
            this.level.setBlock(this.worldPosition, (BlockState)this.getBlockState().setValue(WarpPlateBlock.STATUS, (Comparable)((Object)WarpPlateBlock.WarpPlateStatus.IDLE)), 3);
            this.ticksPassedPerEntity.clear();
        }
        int useTime = this.getWarpPlateUseTime();
        Iterator<Map.Entry<Entity, Integer>> iterator = this.ticksPassedPerEntity.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Entity, Integer> entry = iterator.next();
            Entity entity = entry.getKey();
            Integer ticksPassed = entry.getValue();
            if (!entity.isAlive() || !this.isEntityOnWarpPlate(entity)) {
                iterator.remove();
                continue;
            }
            if (ticksPassed > useTime) {
                ItemStack targetAttunementStack = this.getTargetAttunementStack();
                Waystone targetWaystone = WaystonesAPI.getBoundWaystone(null, targetAttunementStack).orElse(null);
                if (targetWaystone != null && targetWaystone.isValid()) {
                    this.teleportToTarget(entity, targetWaystone, targetAttunementStack);
                }
                if (entity instanceof Player) {
                    if (targetWaystone == null) {
                        chatComponent = Component.translatable((String)"chat.waystones.warp_plate_has_no_target");
                        chatComponent.withStyle(ChatFormatting.DARK_RED);
                        ((Player)entity).displayClientMessage((Component)chatComponent, true);
                    } else if (!targetWaystone.isValid()) {
                        chatComponent = Component.translatable((String)"chat.waystones.warp_plate_has_invalid_target");
                        chatComponent.withStyle(ChatFormatting.DARK_RED);
                        ((Player)entity).displayClientMessage((Component)chatComponent, true);
                    }
                }
                iterator.remove();
                continue;
            }
            if (ticksPassed == -1) continue;
            entry.setValue(ticksPassed + 1);
        }
    }

    private int getWarpPlateUseTime() {
        float useTimeMultiplier = 1.0f;
        for (int i = 0; i < this.getContainerSize(); ++i) {
            ItemStack itemStack = this.getItem(i);
            if (itemStack.getItem() == Items.AMETHYST_SHARD) {
                useTimeMultiplier -= 0.016f * (float)itemStack.getCount();
                continue;
            }
            if (itemStack.getItem() != Items.SLIME_BALL) continue;
            useTimeMultiplier += 0.016f * (float)itemStack.getCount();
        }
        int configuredUseTime = WaystonesConfig.getActive().general.warpPlateUseTime;
        return Mth.clamp((int)((int)((float)configuredUseTime * useTimeMultiplier)), (int)1, (int)(configuredUseTime * 2));
    }

    private void teleportToTarget(Entity entity, Waystone targetWaystone, ItemStack targetAttunementStack) {
        WaystonesAPI.createDefaultTeleportContext(entity, targetWaystone, it -> {
            it.setFromWaystone(this.getWaystone());
            it.setWarpItem(targetAttunementStack);
        }).flatMap(WaystonesAPI::tryTeleport).ifRight(this.informRejectedTeleport(entity)).ifLeft(entities -> {
            block2: {
                block3: {
                    if (!targetAttunementStack.is(ModItemTags.SINGLE_USE_WARP_SHARDS)) break block2;
                    if (!(entity instanceof Player)) break block3;
                    Player player = (Player)entity;
                    if (player.getAbilities().instabuild) break block2;
                }
                targetAttunementStack.shrink(1);
            }
        }).ifLeft(entities -> entities.forEach(this::applyWarpPlateEffects)).left();
    }

    private Consumer<WaystoneTeleportError> informRejectedTeleport(Entity entityToInform) {
        return error -> {
            if (error.getTranslationKey() != null && entityToInform instanceof Player) {
                Player player = (Player)entityToInform;
                MutableComponent chatComponent = Component.translatable((String)error.getTranslationKey());
                chatComponent.withStyle(ChatFormatting.DARK_RED);
                player.displayClientMessage((Component)chatComponent, true);
            }
        };
    }

    private void applyWarpPlateEffects(Entity entity) {
        int fireSeconds = 0;
        int poisonSeconds = 0;
        int blindSeconds = 0;
        int featherFallSeconds = 0;
        int fireResistanceSeconds = 0;
        int witherSeconds = 0;
        int potency = 1;
        ArrayList<ItemStack> curativeItems = new ArrayList<ItemStack>();
        for (int i = 0; i < this.getContainerSize(); ++i) {
            ItemStack itemStack = this.getItem(i);
            if (itemStack.getItem() == Items.BLAZE_POWDER) {
                fireSeconds += itemStack.getCount();
                continue;
            }
            if (itemStack.getItem() == Items.POISONOUS_POTATO) {
                poisonSeconds += itemStack.getCount();
                continue;
            }
            if (itemStack.getItem() == Items.INK_SAC) {
                blindSeconds += itemStack.getCount();
                continue;
            }
            if (itemStack.getItem() == Items.MILK_BUCKET || itemStack.getItem() == Items.HONEY_BLOCK) {
                curativeItems.add(itemStack);
                continue;
            }
            if (itemStack.getItem() == Items.DIAMOND) {
                potency = Math.min(4, potency + itemStack.getCount());
                continue;
            }
            if (itemStack.getItem() == Items.FEATHER) {
                featherFallSeconds = Math.min(8, featherFallSeconds + itemStack.getCount());
                continue;
            }
            if (itemStack.getItem() == Items.MAGMA_CREAM) {
                fireResistanceSeconds = Math.min(8, fireResistanceSeconds + itemStack.getCount());
                continue;
            }
            if (itemStack.getItem() != Items.WITHER_ROSE) continue;
            witherSeconds += itemStack.getCount();
        }
        if (entity instanceof LivingEntity) {
            if (fireSeconds > 0) {
                entity.setSecondsOnFire(fireSeconds);
            }
            if (poisonSeconds > 0) {
                ((LivingEntity)entity).addEffect(new MobEffectInstance(MobEffects.POISON, poisonSeconds * 20, potency));
            }
            if (blindSeconds > 0) {
                ((LivingEntity)entity).addEffect(new MobEffectInstance(MobEffects.BLINDNESS, blindSeconds * 20, potency));
            }
            if (featherFallSeconds > 0) {
                ((LivingEntity)entity).addEffect(new MobEffectInstance(MobEffects.SLOW_FALLING, featherFallSeconds * 20, potency));
            }
            if (fireResistanceSeconds > 0) {
                ((LivingEntity)entity).addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, fireResistanceSeconds * 20, potency));
            }
            if (witherSeconds > 0) {
                ((LivingEntity)entity).addEffect(new MobEffectInstance(MobEffects.WITHER, witherSeconds * 20, potency));
            }
            for (ItemStack curativeItem : curativeItems) {
                Balm.getHooks().curePotionEffects((LivingEntity)entity, curativeItem);
            }
        }
    }

    public ItemStack getTargetAttunementStack() {
        boolean shouldRoundRobin = false;
        boolean shouldPrioritizeSingleUseShards = false;
        ArrayList<ItemStack> attunedShards = new ArrayList<ItemStack>();
        for (int i = 0; i < this.getContainerSize(); ++i) {
            ItemStack itemStack = this.getItem(i);
            if (itemStack.is(ModItemTags.WARP_SHARDS)) {
                Waystone waystoneAttunedTo = WaystonesAPI.getBoundWaystone(null, itemStack).orElse(null);
                if (waystoneAttunedTo == null || waystoneAttunedTo.getWaystoneUid().equals(this.getWaystone().getWaystoneUid())) continue;
                attunedShards.add(itemStack);
                continue;
            }
            if (itemStack.getItem() == Items.QUARTZ) {
                shouldRoundRobin = true;
                continue;
            }
            if (itemStack.getItem() != Items.SPIDER_EYE) continue;
            shouldPrioritizeSingleUseShards = true;
        }
        if (shouldPrioritizeSingleUseShards && attunedShards.stream().anyMatch(stack -> stack.is(ModItemTags.SINGLE_USE_WARP_SHARDS))) {
            attunedShards.removeIf(stack -> !stack.is(ModItemTags.SINGLE_USE_WARP_SHARDS));
        }
        if (!attunedShards.isEmpty()) {
            this.lastAttunementSlot = (this.lastAttunementSlot + 1) % attunedShards.size();
            return shouldRoundRobin ? (ItemStack)attunedShards.get(this.lastAttunementSlot) : (ItemStack)attunedShards.get(this.random.nextInt(attunedShards.size()));
        }
        return ItemStack.EMPTY;
    }

    public Optional<Waystone> getTargetWaystone() {
        return WaystonesAPI.getBoundWaystone(null, this.getTargetAttunementStack());
    }

    public void markEntityForCooldown(Entity entity) {
        this.ticksPassedPerEntity.put(entity, -1);
    }

    public Component getDisplayName() {
        return this.hasCustomName() ? this.getCustomName() : this.getName();
    }

    @Nullable
    public Component getCustomName() {
        return this.customName;
    }

    public void setCustomName(@Nullable Component customName) {
        this.customName = customName;
    }

    public Component getName() {
        return Component.translatable((String)"container.waystones.warp_plate");
    }

    @Override
    public boolean shouldPerformInitialAttunement() {
        return true;
    }
}

