/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.client;

import java.util.Locale;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.client.BalmClient;
import net.blay09.mods.balm.api.event.client.UseItemInputEvent;
import net.blay09.mods.waystones.InternalClientMethodsImpl;
import net.blay09.mods.waystones.api.client.WaystonesClientAPI;
import net.blay09.mods.waystones.block.entity.WaystoneBlockEntityBase;
import net.blay09.mods.waystones.client.InventoryButtonGuiHandler;
import net.blay09.mods.waystones.client.ModClientEventHandlers;
import net.blay09.mods.waystones.client.ModRenderers;
import net.blay09.mods.waystones.client.ModScreens;
import net.blay09.mods.waystones.client.ModTextures;
import net.blay09.mods.waystones.client.requirement.RequirementClientRegistry;
import net.blay09.mods.waystones.compat.Compat;
import net.blay09.mods.waystones.network.message.RequestEditWaystoneMessage;
import net.minecraft.client.ClientBrandRetriever;
import net.minecraft.client.Minecraft;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class WaystonesClient {
    public static void initialize() {
        WaystonesClientAPI.__internalMethods = new InternalClientMethodsImpl();
        RequirementClientRegistry.registerDefaults();
        ModClientEventHandlers.initialize();
        ModRenderers.initialize(BalmClient.getRenderers());
        ModScreens.initialize(BalmClient.getScreens());
        ModTextures.initialize(BalmClient.getTextures());
        InventoryButtonGuiHandler.initialize();
        Compat.isVivecraftInstalled = ClientBrandRetriever.getClientModName().toLowerCase(Locale.ENGLISH).contains("vivecraft");
        Balm.getEvents().onEvent(UseItemInputEvent.class, event -> {
            BlockHitResult blockHitResult;
            BlockEntity targetBlockEntity;
            Minecraft mc = Minecraft.getInstance();
            if (mc.level == null || mc.player == null || mc.hitResult == null || mc.hitResult.getType() != HitResult.Type.BLOCK) {
                return;
            }
            if (mc.player.isShiftKeyDown() && (targetBlockEntity = mc.level.getBlockEntity((blockHitResult = (BlockHitResult)mc.hitResult).getBlockPos())) instanceof WaystoneBlockEntityBase) {
                WaystoneBlockEntityBase waystoneBlockEntity = (WaystoneBlockEntityBase)targetBlockEntity;
                Balm.getNetworking().sendToServer((Object)new RequestEditWaystoneMessage(waystoneBlockEntity.getBlockPos()));
                mc.player.swing(event.getHand());
                event.setCanceled(true);
            }
        });
    }
}

