/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.client.gui.widget;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.blay09.mods.waystones.api.WaystoneVisibility;
import net.blay09.mods.waystones.client.gui.widget.ITooltipProvider;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class WaystoneVisbilityButton
extends Button
implements ITooltipProvider {
    private static final ResourceLocation WAYSTONE_GUI_TEXTURES = new ResourceLocation("waystones", "textures/gui/menu/waystone.png");
    private final List<WaystoneVisibility> options;
    private final boolean canEdit;
    private WaystoneVisibility visibility;

    public WaystoneVisbilityButton(int x, int y, WaystoneVisibility visibility, List<WaystoneVisibility> options, boolean canEdit) {
        super(x, y, 18, 18, (Component)Component.empty(), button -> {}, Button.DEFAULT_NARRATION);
        this.options = options;
        this.visibility = visibility;
        this.canEdit = canEdit;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partial) {
        guiGraphics.blit(WAYSTONE_GUI_TEXTURES, this.getX(), this.getY(), 176 + (this.isHovered ? 18 : 0), 14, 18, 18);
        guiGraphics.blit(WAYSTONE_GUI_TEXTURES, this.getX(), this.getY(), 176, 32 + this.visibility.ordinal() * 18, 18, 18);
    }

    @Override
    public boolean shouldShowTooltip() {
        return this.isHovered;
    }

    @Override
    public List<Component> getTooltipComponents() {
        MutableComponent visibilityValueComponent = Component.translatable((String)("tooltip.waystones.visibility." + this.visibility.name().toLowerCase(Locale.ROOT))).withStyle(ChatFormatting.WHITE);
        ArrayList<Component> result = new ArrayList<Component>();
        result.add((Component)Component.translatable((String)"tooltip.waystones.visibility", (Object[])new Object[]{visibilityValueComponent}).withStyle(ChatFormatting.YELLOW));
        if (!this.canEdit) {
            result.add((Component)Component.translatable((String)"tooltip.waystones.edit_restricted", (Object[])new Object[]{visibilityValueComponent}).withStyle(ChatFormatting.RED));
        }
        return result;
    }

    public WaystoneVisibility getVisibility() {
        return this.visibility;
    }

    public void onPress() {
        if (this.canEdit) {
            int index = this.options.indexOf((Object)this.visibility);
            this.visibility = this.options.get((index + 1) % this.options.size());
        }
    }
}

