/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import java.util.Set;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.menu.BalmMenuProvider;
import net.blay09.mods.waystones.api.TeleportFlags;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.comparator.WaystoneComparators;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.core.WaystoneImpl;
import net.blay09.mods.waystones.menu.ModMenus;
import net.blay09.mods.waystones.menu.WaystoneSelectionMenu;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;

public class OpenPlayerWaystonesGuiCommand
implements Command<CommandSourceStack> {
    public int run(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        final ServerPlayer target = ((EntitySelector)ctx.getArgument("player", EntitySelector.class)).findSinglePlayer((CommandSourceStack)ctx.getSource());
        ServerPlayer op = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
        final List<Waystone> waystones = PlayerWaystoneManager.getActivatedWaystones((Player)target).stream().sorted(WaystoneComparators.forAdminInspection((Player)op, (Player)target)).toList();
        BalmMenuProvider menuProvider = new BalmMenuProvider(){

            public Component getDisplayName() {
                return Component.translatable((String)"container.waystones.waystone_admin_selection", (Object[])new Object[]{target.getScoreboardName()});
            }

            public AbstractContainerMenu createMenu(int windowId, Inventory playerInventory, Player playerEntity) {
                return new WaystoneSelectionMenu((MenuType<WaystoneSelectionMenu>)((MenuType)ModMenus.adminSelection.get()), null, windowId, waystones, Set.of(TeleportFlags.ADMIN));
            }

            public void writeScreenOpeningData(ServerPlayer player, FriendlyByteBuf buf) {
                WaystoneImpl.writeList(buf, waystones);
            }
        };
        Balm.getNetworking().openGui((Player)op, (MenuProvider)menuProvider);
        return 0;
    }
}

