/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.item;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.api.WaystonesAPI;
import net.blay09.mods.waystones.api.trait.IAttunementItem;
import net.blay09.mods.waystones.api.trait.IFOVOnUse;
import net.blay09.mods.waystones.api.trait.IResetUseOnDamage;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.blay09.mods.waystones.core.WaystoneProxy;
import net.blay09.mods.waystones.item.ScrollItemBase;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class BoundScrollItem
extends ScrollItemBase
implements IResetUseOnDamage,
IFOVOnUse,
IAttunementItem {
    public BoundScrollItem(Item.Properties properties) {
        super(properties);
    }

    public int getUseDuration(ItemStack itemStack) {
        return WaystonesConfig.getActive().general.scrollUseTime;
    }

    public ItemStack finishUsingItem(ItemStack stack, Level world, LivingEntity entity) {
        if (!world.isClientSide && entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            Optional<Waystone> boundTo = this.getWaystoneAttunedTo(player.getServer(), (Player)player, stack);
            boundTo.ifPresent(targetWaystone -> WaystonesAPI.createDefaultTeleportContext((Entity)player, targetWaystone, it -> it.setWarpItem(stack)).mapLeft(WaystonesAPI::tryTeleport).ifLeft(it -> {
                if (!player.getAbilities().instabuild) {
                    stack.shrink(1);
                }
            }));
        }
        return stack;
    }

    @Override
    public Optional<Waystone> getWaystoneAttunedTo(MinecraftServer server, Player player, ItemStack itemStack) {
        CompoundTag compound = itemStack.getTag();
        if (compound != null && compound.contains("AttunedToWaystone", 11)) {
            return Optional.of(new WaystoneProxy(server, NbtUtils.loadUUID((Tag)Objects.requireNonNull(compound.get("AttunedToWaystone")))));
        }
        return Optional.empty();
    }

    @Override
    public void setWaystoneAttunedTo(ItemStack itemStack, @Nullable Waystone waystone) {
        CompoundTag tagCompound = itemStack.getTag();
        if (tagCompound == null) {
            tagCompound = new CompoundTag();
            itemStack.setTag(tagCompound);
        }
        if (waystone != null) {
            tagCompound.put("AttunedToWaystone", (Tag)NbtUtils.createUUID((UUID)waystone.getWaystoneUid()));
        } else {
            tagCompound.remove("AttunedToWaystone");
        }
    }

    public void appendHoverText(ItemStack itemStack, @Nullable Level world, List<Component> list, TooltipFlag flag) {
        Player player = Balm.getProxy().getClientPlayer();
        if (player == null) {
            return;
        }
        Optional<Waystone> boundTo = this.getWaystoneAttunedTo(player.getServer(), player, itemStack);
        boundTo.ifPresent(it -> {
            MutableComponent boundToValueComponent = it.getName().copy().withStyle(ChatFormatting.AQUA);
            list.add((Component)Component.translatable((String)"tooltip.waystones.bound_to", (Object[])new Object[]{boundToValueComponent}).withStyle(ChatFormatting.GRAY));
        });
    }

    public boolean isFoil(ItemStack itemStack) {
        return true;
    }
}

