/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.item;

import java.util.List;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.core.InvalidWaystone;
import net.blay09.mods.waystones.item.AbstractAttunedShardItem;
import net.blay09.mods.waystones.menu.WarpPlateMenu;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class CrumblingAttunedShardItem
extends AbstractAttunedShardItem {
    public CrumblingAttunedShardItem(Item.Properties properties) {
        super(properties.stacksTo(4));
    }

    @Override
    public void appendHoverText(ItemStack stack, @Nullable Level world, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(stack, world, list, flag);
        Waystone attunedWarpPlate = this.getWaystoneAttunedTo(null, null, stack).orElse(InvalidWaystone.INSTANCE);
        if (attunedWarpPlate.isValid()) {
            AbstractContainerMenu abstractContainerMenu;
            MutableComponent textComponent = Component.translatable((String)"tooltip.waystones.attuned_shard.attunement_crumbling");
            textComponent.withStyle(ChatFormatting.WHITE).withStyle(ChatFormatting.ITALIC);
            Player player = Balm.getProxy().getClientPlayer();
            if (player != null && (abstractContainerMenu = player.containerMenu) instanceof WarpPlateMenu) {
                WarpPlateMenu wpc = (WarpPlateMenu)abstractContainerMenu;
                if (!attunedWarpPlate.getWaystoneUid().equals(wpc.getWaystone().getWaystoneUid())) {
                    list.add((Component)textComponent);
                }
            } else {
                list.add((Component)textComponent);
            }
        }
    }
}

