/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.menu;

import java.util.ArrayList;
import java.util.List;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.api.WaystoneTypes;
import net.blay09.mods.waystones.api.WaystoneVisibility;
import net.blay09.mods.waystones.block.entity.WaystoneBlockEntityBase;
import net.blay09.mods.waystones.core.WaystonePermissionManager;
import net.blay09.mods.waystones.menu.ModMenus;
import net.blay09.mods.waystones.menu.WarpPlateAttunementSlot;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class WaystoneMenu
extends AbstractContainerMenu {
    private final Player player;
    private final Waystone waystone;
    private final WaystoneBlockEntityBase blockEntity;
    private final ContainerData containerData;
    private final boolean canEdit;

    public WaystoneMenu(int windowId, Waystone waystone, WaystoneBlockEntityBase blockEntity, ContainerData containerData, Inventory playerInventory, boolean canEdit) {
        super((MenuType)ModMenus.waystoneSettings.get(), windowId);
        this.player = playerInventory.player;
        this.waystone = waystone;
        this.blockEntity = blockEntity;
        this.containerData = containerData;
        this.canEdit = canEdit;
        blockEntity.markReadyForAttunement();
        WaystoneMenu.checkContainerDataCount((ContainerData)containerData, (int)1);
        this.addSlot(new WarpPlateAttunementSlot(blockEntity, 0, 80, 64));
        this.addSlot(new WarpPlateAttunementSlot(blockEntity, 1, 80, 36));
        this.addSlot(new WarpPlateAttunementSlot(blockEntity, 2, 108, 64));
        this.addSlot(new WarpPlateAttunementSlot(blockEntity, 3, 80, 92));
        this.addSlot(new WarpPlateAttunementSlot(blockEntity, 4, 52, 64));
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 128 + i * 18));
            }
        }
        for (int j = 0; j < 9; ++j) {
            this.addSlot(new Slot((Container)playerInventory, j, 8 + j * 18, 186));
        }
        this.addDataSlots(containerData);
    }

    public float getAttunementProgress() {
        return (float)this.containerData.get(0) / (float)this.blockEntity.getMaxAttunementTicks();
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            itemStack = slotStack.copy();
            if (index < 5 ? !this.moveItemStackTo(slotStack, 5, this.slots.size(), true) : (!this.getSlot(0).hasItem() ? !this.moveItemStackTo(slotStack.split(1), 0, 1, false) : !this.moveItemStackTo(slotStack, 1, 5, false))) {
                return ItemStack.EMPTY;
            }
            if (slotStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemStack;
    }

    public boolean stillValid(Player player) {
        BlockPos pos = this.blockEntity.getBlockPos();
        return player.distanceToSqr((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5) <= 64.0;
    }

    public Waystone getWaystone() {
        return this.waystone;
    }

    public List<WaystoneVisibility> getVisibilityOptions() {
        if (WaystoneTypes.isSharestone(this.waystone.getWaystoneType())) {
            return List.of(WaystoneVisibility.GLOBAL);
        }
        if (this.waystone.getWaystoneType().equals((Object)WaystoneTypes.WARP_PLATE)) {
            return List.of(WaystoneVisibility.SHARD_ONLY);
        }
        if (this.waystone.getWaystoneType().equals((Object)WaystoneTypes.LANDING_STONE)) {
            return List.of(WaystoneVisibility.SHARD_ONLY);
        }
        ArrayList<WaystoneVisibility> result = new ArrayList<WaystoneVisibility>();
        result.add(WaystoneVisibility.ACTIVATION);
        if (WaystonePermissionManager.isAllowedVisibility(WaystoneVisibility.GLOBAL) || WaystonePermissionManager.skipsPermissions(this.player)) {
            result.add(WaystoneVisibility.GLOBAL);
        }
        return result;
    }

    public boolean canEdit() {
        return this.canEdit;
    }
}

