/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.network.message;

import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.menu.BalmMenuProvider;
import net.blay09.mods.waystones.api.TeleportFlags;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.api.WaystonesAPI;
import net.blay09.mods.waystones.config.InventoryButtonMode;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.core.WaystoneImpl;
import net.blay09.mods.waystones.menu.ModMenus;
import net.blay09.mods.waystones.menu.WaystoneSelectionMenu;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;

public class InventoryButtonMessage {
    public static void encode(InventoryButtonMessage message, FriendlyByteBuf buf) {
    }

    public static InventoryButtonMessage decode(FriendlyByteBuf buf) {
        return new InventoryButtonMessage();
    }

    public static void handle(ServerPlayer player, InventoryButtonMessage message) {
        Optional<Waystone> waystone;
        InventoryButtonMode inventoryButtonMode = WaystonesConfig.getActive().getInventoryButtonMode();
        if (!inventoryButtonMode.isEnabled()) {
            return;
        }
        if (player == null) {
            return;
        }
        if (player.getAbilities().instabuild) {
            PlayerWaystoneManager.resetCooldowns((Player)player);
        }
        if ((waystone = PlayerWaystoneManager.getInventoryButtonTarget((Player)player)).isPresent()) {
            WaystonesAPI.createDefaultTeleportContext((Entity)player, waystone.get(), it -> it.addFlag(TeleportFlags.INVENTORY_BUTTON)).mapLeft(WaystonesAPI::tryTeleport);
        } else if (inventoryButtonMode.isReturnToAny()) {
            final Collection<Waystone> waystones = PlayerWaystoneManager.getTargetsForInventoryButton(player);
            PlayerWaystoneManager.ensureSortingIndex((Player)player, waystones);
            BalmMenuProvider containerProvider = new BalmMenuProvider(){

                public Component getDisplayName() {
                    return Component.translatable((String)"container.waystones.waystone_selection");
                }

                public AbstractContainerMenu createMenu(int windowId, Inventory playerInventory, Player playerEntity) {
                    return new WaystoneSelectionMenu((MenuType<WaystoneSelectionMenu>)((MenuType)ModMenus.inventorySelection.get()), null, windowId, waystones, Set.of(TeleportFlags.INVENTORY_BUTTON));
                }

                public void writeScreenOpeningData(ServerPlayer player, FriendlyByteBuf buf) {
                    WaystoneImpl.writeList(buf, waystones);
                }
            };
            Balm.getNetworking().openGui((Player)player, (MenuProvider)containerProvider);
        }
    }
}

