/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.network.message;

import java.util.Objects;
import java.util.UUID;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.api.WaystoneVisibility;
import net.blay09.mods.waystones.block.WaystoneBlock;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.core.WaystoneImpl;
import net.blay09.mods.waystones.core.WaystoneManagerImpl;
import net.blay09.mods.waystones.core.WaystoneProxy;
import net.blay09.mods.waystones.core.WaystoneSyncManager;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;

public class RemoveWaystoneMessage {
    private final UUID waystoneUid;

    public RemoveWaystoneMessage(UUID waystoneUid) {
        this.waystoneUid = waystoneUid;
    }

    public static void encode(RemoveWaystoneMessage message, FriendlyByteBuf buf) {
        buf.writeUUID(message.waystoneUid);
    }

    public static RemoveWaystoneMessage decode(FriendlyByteBuf buf) {
        UUID waystoneUid = buf.readUUID();
        return new RemoveWaystoneMessage(waystoneUid);
    }

    public static void handle(ServerPlayer player, RemoveWaystoneMessage message) {
        Waystone backingWaystone;
        WaystoneProxy waystone = new WaystoneProxy(player.server, message.waystoneUid);
        PlayerWaystoneManager.deactivateWaystone((Player)player, waystone);
        if (waystone.getVisibility() == WaystoneVisibility.GLOBAL && player.getAbilities().instabuild && (backingWaystone = waystone.getBackingWaystone()) instanceof WaystoneImpl) {
            BlockState state;
            ((WaystoneImpl)backingWaystone).setVisibility(WaystoneVisibility.ACTIVATION);
            ServerLevel targetWorld = Objects.requireNonNull(player.level().getServer()).getLevel(backingWaystone.getDimension());
            BlockPos pos = backingWaystone.getPos();
            BlockState blockState = state = targetWorld != null ? targetWorld.getBlockState(pos) : null;
            if (targetWorld == null || !(state.getBlock() instanceof WaystoneBlock)) {
                WaystoneManagerImpl.get(player.server).removeWaystone(backingWaystone);
                PlayerWaystoneManager.removeKnownWaystone(player.server, backingWaystone);
                WaystoneSyncManager.sendWaystoneRemovalToAll(player.server, backingWaystone, true);
            }
        }
    }
}

