/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.mods;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.List;
import net.minecraft.class_1159;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5321;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;
import xaero.common.AXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.graphics.renderer.multitexture.MultiTextureRenderTypeRenderer;
import xaero.common.graphics.renderer.multitexture.MultiTextureRenderTypeRendererProvider;
import xaero.common.gui.ScreenBase;
import xaero.common.minimap.region.MinimapTile;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.WorldMapSession;
import xaero.map.graphics.CustomRenderTypes;
import xaero.map.graphics.shader.MapShaders;
import xaero.map.gui.GuiWorldMapSettings;
import xaero.map.misc.Misc;
import xaero.map.region.MapRegion;
import xaero.map.region.MapTileChunk;
import xaero.map.region.texture.LeafRegionTexture;
import xaero.map.settings.ModOptions;
import xaero.map.world.MapDimension;

public class SupportXaeroWorldmap {
    public static int WORLDMAP_COMPATIBILITY_VERSION = 7;
    public int compatibilityVersion;
    private static final HashMap<MapTileChunk, Long> seedsUsed = new HashMap();
    public static final int black = -16777216;
    public static final int slime = -2142047936;
    private AXaeroMinimap modMain;

    public SupportXaeroWorldmap(AXaeroMinimap modMain) {
        this.modMain = modMain;
        try {
            this.compatibilityVersion = WorldMap.MINIMAP_COMPATIBILITY_VERSION;
        }
        catch (NoSuchFieldError noSuchFieldError) {
            // empty catch block
        }
        if (this.compatibilityVersion < 3) {
            throw new RuntimeException("Xaero's World Map 1.11.0 or newer required!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawMinimap(XaeroMinimapSession minimapSession, class_4587 matrixStack, MinimapRendererHelper helper, int xFloored, int zFloored, int minViewX, int minViewZ, int maxViewX, int maxViewZ, boolean zooming, double zoom, class_4588 overlayBufferBuilder, MultiTextureRenderTypeRendererProvider multiTextureRenderTypeRenderers) {
        WorldMapSession worldmapSession = WorldMapSession.getCurrentSession();
        MapProcessor mapProcessor = worldmapSession.getMapProcessor();
        Object object = mapProcessor.renderThreadPauseSync;
        synchronized (object) {
            if (!mapProcessor.isRenderingPaused()) {
                if (mapProcessor.getCurrentDimension() == null) {
                    return;
                }
                String worldString = mapProcessor.getCurrentWorldId();
                if (worldString == null) {
                    return;
                }
                int mapX = xFloored >> 4;
                int mapZ = zFloored >> 4;
                int chunkX = mapX >> 2;
                int chunkZ = mapZ >> 2;
                int tileX = mapX & 3;
                int tileZ = mapZ & 3;
                int insideX = xFloored & 0xF;
                int insideZ = zFloored & 0xF;
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.enableBlend();
                int minX = (mapX >> 2) - 4;
                int maxX = (mapX >> 2) + 4;
                int minZ = (mapZ >> 2) - 4;
                int maxZ = (mapZ >> 2) + 4;
                float brightness = this.getMinimapBrightness();
                int globalRegionCacheHashCode = WorldMap.settings.getRegionCacheHashCode();
                boolean reloadEverything = WorldMap.settings.reloadEverything;
                int globalReloadVersion = WorldMap.settings.reloadVersion;
                boolean slimeChunks = this.modMain.getSettings().getSlimeChunks(minimapSession.getWaypointsManager());
                MultiTextureRenderTypeRenderer mapWithLightRenderer = null;
                MultiTextureRenderTypeRenderer mapNoLightRenderer = null;
                mapWithLightRenderer = multiTextureRenderTypeRenderers.getRenderer(t -> RenderSystem.setShaderTexture((int)0, (int)t), MultiTextureRenderTypeRendererProvider::defaultTextureBind, CustomRenderTypes.MAP);
                mapNoLightRenderer = multiTextureRenderTypeRenderers.getRenderer(t -> RenderSystem.setShaderTexture((int)0, (int)t), MultiTextureRenderTypeRendererProvider::defaultTextureBind, CustomRenderTypes.MAP);
                class_1159 matrix = matrixStack.method_23760().method_23761();
                for (int i = minX; i <= maxX; ++i) {
                    for (int j = minZ; j <= maxZ; ++j) {
                        boolean newSeed;
                        MapTileChunk chunk;
                        MapRegion region = mapProcessor.getMapRegion(i >> 3, j >> 3, mapProcessor.regionExists(i >> 3, j >> 3));
                        if (region == null) continue;
                        MapRegion mapRegion = region;
                        synchronized (mapRegion) {
                            int regionHashCode = region.getCacheHashCode();
                            int regionReloadVersion = region.getReloadVersion();
                            if (!region.recacheHasBeenRequested() && !region.reloadHasBeenRequested() && (region.getLoadState() == 4 || region.getLoadState() == 2 && region.isBeingWritten() || region.getLoadState() == 0) && (reloadEverything && regionReloadVersion != globalReloadVersion || regionHashCode != globalRegionCacheHashCode || region.getVersion() != mapProcessor.getGlobalVersion() || region.getLoadState() != 2 && region.shouldCache())) {
                                if (region.getLoadState() == 2) {
                                    region.requestRefresh(mapProcessor);
                                } else {
                                    mapProcessor.getMapSaveLoad().requestLoad(region, "Minimap", false);
                                    mapProcessor.getMapSaveLoad().setNextToLoadByViewing(region);
                                }
                            }
                        }
                        if (!mapProcessor.isUploadingPaused() && region.isLoaded()) {
                            mapProcessor.getMapWorld().getCurrentDimension().getMapRegions().bumpLoadedRegion(region);
                        }
                        if (i < minViewX || i > maxViewX || j < minViewZ || j > maxViewZ || (chunk = region.getChunk(i & 7, j & 7)) == null || chunk.getGlColorTexture() == -1) continue;
                        this.bindMapTextureWithLighting(chunk, zooming);
                        GL11.glTexParameterf((int)3553, (int)33082, (float)0.0f);
                        int drawX = 64 * (chunk.getX() - chunkX) - 16 * tileX - insideX;
                        int drawZ = 64 * (chunk.getZ() - chunkZ) - 16 * tileZ - insideZ;
                        this.prepareMapTexturedRect(matrix, drawX, drawZ, 0, 0, 64.0f, 64.0f, chunk, mapNoLightRenderer, mapWithLightRenderer, helper);
                        if (!slimeChunks) continue;
                        Long seed = this.modMain.getSettings().getSlimeChunksSeed(minimapSession.getWaypointsManager().getCurrentContainerAndWorldID());
                        Long savedSeed = seedsUsed.get(chunk);
                        boolean bl = newSeed = seed == null && savedSeed != null || seed != null && !seed.equals(savedSeed);
                        if (newSeed) {
                            seedsUsed.put(chunk, seed);
                        }
                        for (int t2 = 0; t2 < 16; ++t2) {
                            if (newSeed || (chunk.getTileGridsCache()[t2 % 4][t2 / 4] & 1) == 0) {
                                chunk.getTileGridsCache()[t2 % 4][t2 / 4] = (byte)(1 | (MinimapTile.isSlimeChunk(this.modMain.getSettings(), chunk.getX() * 4 + t2 % 4, chunk.getZ() * 4 + t2 / 4, seed) ? 2 : 0));
                            }
                            if ((chunk.getTileGridsCache()[t2 % 4][t2 / 4] & 2) == 0) continue;
                            int slimeDrawX = drawX + 16 * (t2 % 4);
                            int slimeDrawZ = drawZ + 16 * (t2 / 4);
                            helper.addColoredRectToExistingBuffer(matrixStack.method_23760().method_23761(), overlayBufferBuilder, slimeDrawX, slimeDrawZ, 16, 16, -2142047936);
                        }
                    }
                }
                MapShaders.WORLD_MAP.setBrightness(brightness);
                MapShaders.WORLD_MAP.setWithLight(true);
                multiTextureRenderTypeRenderers.draw(mapWithLightRenderer);
                MapShaders.WORLD_MAP.setWithLight(false);
                multiTextureRenderTypeRenderers.draw(mapNoLightRenderer);
                GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)0);
                RenderSystem.disableBlend();
            }
        }
    }

    public boolean getWorldMapWaypoints() {
        return WorldMap.settings.waypoints;
    }

    public int getWorldMapColours() {
        return WorldMap.settings.colours;
    }

    public boolean getWorldMapFlowers() {
        return WorldMap.settings.flowers;
    }

    public boolean getWorldMapLighting() {
        return WorldMap.settings.lighting;
    }

    public boolean getWorldMapTerrainDepth() {
        return WorldMap.settings.terrainDepth;
    }

    public int getWorldMapTerrainSlopes() {
        int wmSetting = WorldMap.settings.terrainSlopes;
        return wmSetting;
    }

    public boolean getWorldMapBiomeColorsVanillaMode() {
        return WorldMap.settings.biomeColorsVanillaMode;
    }

    public boolean getWorldMapIgnoreHeightmaps() {
        return WorldMap.settings.getClientBooleanValue(ModOptions.IGNORE_HEIGHTMAPS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMultiworldId(class_5321<class_1937> dimId) {
        WorldMapSession worldmapSession = WorldMapSession.getCurrentSession();
        MapProcessor mapProcessor = worldmapSession.getMapProcessor();
        Object object = mapProcessor.uiSync;
        synchronized (object) {
            MapDimension mapDim;
            MapDimension mapDimension = mapDim = !mapProcessor.isMapWorldUsable() || mapProcessor.isWaitingForWorldUpdate() ? null : mapProcessor.getMapWorld().createDimensionUnsynced(dimId);
            return mapDim == null ? null : (!mapDim.currentMultiworldWritable ? "minimap" : mapDim.getCurrentMultiworld());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getPotentialMultiworldIds(class_5321<class_1937> dimId) {
        WorldMapSession worldmapSession = WorldMapSession.getCurrentSession();
        MapProcessor mapProcessor = worldmapSession.getMapProcessor();
        Object object = mapProcessor.uiSync;
        synchronized (object) {
            MapDimension mapDim = mapProcessor.getMapWorld().createDimensionUnsynced(dimId);
            return mapDim == null || !mapProcessor.isWaitingForWorldUpdate() && mapDim.currentMultiworldWritable ? null : mapDim.getMultiworldIdsCopy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getMultiworldIds(class_5321<class_1937> dimId) {
        WorldMapSession worldmapSession = WorldMapSession.getCurrentSession();
        MapProcessor mapProcessor = worldmapSession.getMapProcessor();
        Object object = mapProcessor.uiSync;
        synchronized (object) {
            MapDimension mapDim = mapProcessor.getMapWorld().createDimensionUnsynced(dimId);
            return mapDim == null ? null : mapDim.getMultiworldIdsCopy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMultiworldName(class_5321<class_1937> dimId, String multiworldId) {
        WorldMapSession worldmapSession = WorldMapSession.getCurrentSession();
        MapProcessor mapProcessor = worldmapSession.getMapProcessor();
        Object object = mapProcessor.uiSync;
        synchronized (object) {
            MapDimension mapDim = !mapProcessor.isMapWorldUsable() ? null : mapProcessor.getMapWorld().createDimensionUnsynced(dimId);
            return mapDim == null ? null : mapDim.getMultiworldName(multiworldId);
        }
    }

    public void openSettings() {
        class_437 current = class_310.method_1551().field_1755;
        class_437 currentEscScreen = current instanceof ScreenBase ? ((ScreenBase)current).escape : null;
        class_310.method_1551().method_1507((class_437)new GuiWorldMapSettings(current, currentEscScreen));
    }

    public float getMinimapBrightness() {
        WorldMapSession worldmapSession = WorldMapSession.getCurrentSession();
        MapProcessor mapProcessor = worldmapSession.getMapProcessor();
        return mapProcessor.getBrightness(this.modMain.getSettings().getLighting());
    }

    private void bindMapTextureWithLighting(MapTileChunk chunk, boolean zooming) {
        chunk.getLeafTexture().bindColorTexture(false, zooming ? 9729 : 9728);
    }

    public boolean screenShouldSkipWorldRender(class_437 screen) {
        return Misc.screenShouldSkipWorldRender((class_437)screen, (boolean)false);
    }

    public void prepareMapTexturedRect(class_1159 matrix, float x, float y, int textureX, int textureY, float width, float height, MapTileChunk chunk, MultiTextureRenderTypeRenderer noLightRenderer, MultiTextureRenderTypeRenderer withLightrenderer, MinimapRendererHelper helper) {
        LeafRegionTexture texture = chunk.getLeafTexture();
        helper.prepareMyTexturedModalRect(matrix, x, y, textureX, (int)height, width, height, -height, 64.0f, texture.getGlColorTexture(), texture.getTextureHasLight() ? withLightrenderer : noLightRenderer);
    }
}

