/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.graphics;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.resources.language.I18n;

public class CursorBox {
    private static final int BOX_OFFSET_X = 12;
    private static final int BOX_OFFSET_Y = -10;
    private static final int USUAL_WIDTH = 200;
    private ArrayList<String> strings;
    private String language;
    private String fullCode = "";
    private String formatting;
    private int boxWidth = 15;
    private static final int color = -939524096;
    private boolean customLines;
    private boolean flippedByDefault;

    public CursorBox(String code) {
        this(code, "");
    }

    public CursorBox(String code, String formatting) {
        this(code, formatting, false);
    }

    public CursorBox(String code, String formatting, boolean flippedByDefault) {
        this.fullCode = code;
        this.formatting = formatting;
        this.flippedByDefault = flippedByDefault;
    }

    public CursorBox(int size) {
        this.strings = new ArrayList();
        for (int i = 0; i < size; ++i) {
            this.strings.add("");
        }
        this.customLines = true;
    }

    public void setBoxWidth(int boxWidth) {
        this.boxWidth = boxWidth;
    }

    private String currentLanguage() {
        return Minecraft.m_91087_().m_91102_().m_118983_().getCode();
    }

    public void createLines(String text) {
        try {
            this.language = this.currentLanguage();
        }
        catch (NullPointerException e) {
            this.language = "en_us";
        }
        this.strings = new ArrayList();
        String[] words = text.split(" ");
        int spaceWidth = Minecraft.m_91087_().f_91062_.m_92895_(" ");
        StringBuilder line = new StringBuilder();
        int width = 0;
        for (int i = 0; i < words.length; ++i) {
            int wordWidth = Minecraft.m_91087_().f_91062_.m_92895_(words[i]);
            if (width + spaceWidth + wordWidth <= 185) {
                this.boxWidth = Math.max(this.boxWidth, Math.min(200, width + spaceWidth + wordWidth + 15));
            }
            if (width == 0 && wordWidth > this.boxWidth - 15) {
                this.boxWidth = wordWidth + 15;
            }
            if (!words[i].equals("\n") && width + wordWidth <= this.boxWidth - 15) {
                width += spaceWidth + wordWidth;
                line.append(words[i]).append(" ");
            } else {
                this.strings.add(this.formatting + line.toString());
                line.delete(0, line.length());
                width = 0;
                if (!words[i].equals("\n")) {
                    --i;
                }
            }
            if (i != words.length - 1) continue;
            this.strings.add(this.formatting + line.toString());
        }
    }

    public String getString(int line) {
        return this.strings.get(line);
    }

    public void drawBox(PoseStack matrixStack, int x, int y, int width, int height) {
        int h;
        int overEdgeY;
        try {
            if (!(this.customLines || this.language != null && this.language.equals(this.currentLanguage()))) {
                this.createLines(I18n.m_118938_((String)this.fullCode, (Object[])new Object[0]));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        int drawX = x + 12;
        int drawY = y + -10;
        int overEdgeX = drawX + this.boxWidth - width;
        if (this.flippedByDefault || overEdgeX > 9) {
            drawX = x - 12 - this.boxWidth;
        } else if (overEdgeX > 0) {
            drawX -= overEdgeX;
        }
        if (drawX < 0) {
            drawX = 0;
        }
        if ((overEdgeY = drawY + (h = 5 + this.strings.size() * 10 + 5) - height) > h / 2) {
            drawY = y - -10 - h;
        } else if (overEdgeY > 0) {
            drawY -= overEdgeY;
        }
        if (drawY < 0) {
            drawY = 0;
        }
        GuiComponent.m_93172_((PoseStack)matrixStack, (int)drawX, (int)drawY, (int)(drawX + this.boxWidth), (int)(drawY + h), (int)-939524096);
        for (int i = 0; i < this.strings.size(); ++i) {
            String s = this.getString(i);
            Minecraft.m_91087_().f_91062_.m_92883_(matrixStack, "\u00a7f" + s, (float)(drawX + 10), (float)(drawY + 5 + 10 * i), 0xFFFFFF);
        }
    }

    public CursorBox withWidth(int boxWidth) {
        this.boxWidth = boxWidth;
        return this;
    }
}

