/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import java.io.IOException;
import java.util.ArrayList;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.FormattedCharSequence;
import xaero.common.IXaeroMinimap;
import xaero.common.gui.GuiDropDown;
import xaero.common.gui.GuiWaypointContainers;
import xaero.common.gui.GuiWaypointSets;
import xaero.common.gui.GuiWaypointWorlds;
import xaero.common.gui.IDropDownCallback;
import xaero.common.gui.MySmallButton;
import xaero.common.gui.MySuperTinyButton;
import xaero.common.gui.MyTinyButton;
import xaero.common.gui.ScreenBase;
import xaero.common.gui.WaypointEditForm;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.minimap.waypoints.WaypointSet;
import xaero.common.minimap.waypoints.WaypointWorld;
import xaero.common.minimap.waypoints.WaypointsManager;
import xaero.common.misc.Misc;
import xaero.common.misc.OptimizedMath;
import xaero.common.settings.ModSettings;
import xaero.common.validator.NumericFieldValidator;

public class GuiAddWaypoint
extends ScreenBase
implements IDropDownCallback {
    private WaypointsManager waypointsManager;
    protected String screenTitle;
    private Button leftButton;
    private Button rightButton;
    private Button modeSwitchButton;
    private Button resetButton;
    private EditBox nameTextField;
    private EditBox xTextField;
    private EditBox yTextField;
    private EditBox zTextField;
    private EditBox yawTextField;
    private EditBox initialTextField;
    private WaypointEditForm mutualForm;
    private ArrayList<WaypointEditForm> editForms;
    private int selectedWaypointIndex;
    private ArrayList<GuiDropDown> dropDowns;
    private int defaultContainer;
    private WaypointWorld defaultWorld;
    private GuiWaypointContainers containers;
    private GuiWaypointWorlds worlds;
    private GuiWaypointSets sets;
    private GuiDropDown containersDD;
    private GuiDropDown worldsDD;
    private GuiDropDown setsDD;
    private GuiDropDown colorDD;
    private String fromSet;
    private ArrayList<Waypoint> waypointsEdited;
    private boolean dropped;
    private MySuperTinyButton disableButton;
    private MySuperTinyButton globalButton;
    private NumericFieldValidator fieldValidator;
    private NumericFieldValidator fieldYValidator;
    private boolean adding;
    private boolean prefilled;
    private boolean startPrefilled;
    private String namePlaceholder;
    private String xPlaceholder;
    private String yPlaceholder;
    private String zPlaceholder;
    private String yawPlaceholder;
    private String initialPlaceholder;
    private String colorPlaceholder;
    private Button defaultYawButton;
    private Button defaultDisabledButton;
    private Button defaultGlobalButton;
    protected Button confirmButton;
    private boolean censorCoordsIfNeeded;
    private final String frozenAutoContainerID;
    private final String frozenAutoWorldID;
    private BiFunction<String, Integer, String> censoredTextFormatterString;
    private BiFunction<String, Integer, FormattedCharSequence> censoredTextFormatter;

    public GuiAddWaypoint(IXaeroMinimap modMain, WaypointsManager waypointsManager, Screen par1GuiScreen, Waypoint point, String defaultParentContainer, WaypointWorld defaultWorld) {
        this(modMain, waypointsManager, par1GuiScreen, null, point, defaultParentContainer, defaultWorld, defaultWorld.getCurrent());
    }

    public GuiAddWaypoint(IXaeroMinimap modMain, WaypointsManager waypointsManager, Screen par1GuiScreen, Screen escapeScreen, Waypoint point, String defaultParentContainer, WaypointWorld defaultWorld, String waypointSet) {
        this(modMain, waypointsManager, par1GuiScreen, escapeScreen, point == null ? Lists.newArrayList() : Lists.newArrayList((Object[])new Waypoint[]{point}), defaultParentContainer, defaultWorld, waypointSet, point == null || point.getActualColor() == -1);
    }

    public GuiAddWaypoint(IXaeroMinimap modMain, WaypointsManager waypointsManager, Screen par1GuiScreen, ArrayList<Waypoint> waypointsEdited, String defaultParentContainer, WaypointWorld defaultWorld, boolean adding) {
        this(modMain, waypointsManager, par1GuiScreen, null, waypointsEdited, defaultParentContainer, defaultWorld, defaultWorld.getCurrent(), adding);
    }

    public GuiAddWaypoint(IXaeroMinimap modMain, WaypointsManager waypointsManager, Screen par1GuiScreen, Screen escapeScreen, ArrayList<Waypoint> waypointsEdited, String defaultParentContainer, WaypointWorld defaultWorld, String waypointSet, boolean adding) {
        super(modMain, par1GuiScreen, escapeScreen, (Component)new TextComponent(""));
        this.waypointsEdited = waypointsEdited;
        this.waypointsManager = waypointsManager;
        this.fromSet = waypointSet;
        this.defaultWorld = defaultWorld;
        this.frozenAutoContainerID = waypointsManager.getAutoContainerID();
        this.frozenAutoWorldID = waypointsManager.getAutoWorldID();
        this.containers = new GuiWaypointContainers(modMain, waypointsManager, defaultParentContainer, this.frozenAutoContainerID);
        this.defaultContainer = this.containers.current;
        this.worlds = new GuiWaypointWorlds(waypointsManager.getWorldContainer(defaultParentContainer), waypointsManager, defaultWorld.getFullId(), this.frozenAutoContainerID, this.frozenAutoWorldID);
        this.sets = new GuiWaypointSets(false, defaultWorld, this.fromSet);
        this.dropDowns = new ArrayList();
        this.prefilled = !waypointsEdited.isEmpty();
        this.startPrefilled = this.prefilled;
        this.createForms();
        this.fieldValidator = modMain.getFieldValidators().getNumericFieldValidator();
        this.fieldYValidator = modMain.getFieldValidators().getWpCoordFieldValidator();
        this.adding = adding;
        this.namePlaceholder = "- " + I18n.m_118938_((String)"gui.xaero_waypoint_name", (Object[])new Object[0]);
        this.xPlaceholder = "- x";
        this.yPlaceholder = "- y";
        this.zPlaceholder = "- z";
        this.yawPlaceholder = "- " + I18n.m_118938_((String)"gui.xaero_yaw", (Object[])new Object[0]);
        this.initialPlaceholder = "- " + I18n.m_118938_((String)"gui.xaero_initial", (Object[])new Object[0]);
        this.colorPlaceholder = "\u00a78-";
        this.censorCoordsIfNeeded = true;
        this.censoredTextFormatterString = (p_195610_0_, p_195610_1_) -> {
            if (!this.censorCoordsIfNeeded) {
                return p_195610_0_;
            }
            int formatIndex = p_195610_0_.indexOf("\u00a7".charAt(0));
            if (formatIndex == -1) {
                return p_195610_0_.replaceAll(".", "#");
            }
            return p_195610_0_.substring(0, formatIndex).replaceAll(".", "#") + p_195610_0_.substring(formatIndex);
        };
        Style defaultTextStyle = Style.f_131099_;
        this.censoredTextFormatter = (s, i) -> {
            String censoredString = this.censoredTextFormatterString.apply((String)s, (Integer)i);
            return cc -> {
                for (int j = 0; j < censoredString.length(); ++j) {
                    cc.m_6411_(j, defaultTextStyle, (int)censoredString.charAt(j));
                }
                return true;
            };
        };
        this.canSkipWorldRender = true;
    }

    private void fillFormWaypoint(WaypointEditForm form, Waypoint w) {
        form.name = w.getLocalizedName();
        form.xText = "" + w.getX();
        form.yText = w.isYIncluded() ? "" + w.getY() : "~";
        form.zText = "" + w.getZ();
        form.yawText = w.isRotation() ? "" + w.getYaw() : "";
        form.initial = w.getSymbol();
        form.disabled = w.isDisabled();
        form.color = 1 + (w.getActualColor() == -1 ? (int)(Math.random() * (double)(ModSettings.ENCHANT_COLORS.length - 1)) : w.getActualColor());
        form.global = w.isGlobal();
        if (form.initial.length() == 0) {
            form.autoInitial = true;
        }
    }

    private int getAutomaticX(double dimDiv) {
        return OptimizedMath.myFloor((double)OptimizedMath.myFloor(this.f_96541_.f_91074_.m_20185_()) * dimDiv);
    }

    private int getAutomaticY() {
        return OptimizedMath.myFloor(this.f_96541_.f_91074_.m_20186_());
    }

    private int getAutomaticZ(double dimDiv) {
        return OptimizedMath.myFloor((double)OptimizedMath.myFloor(this.f_96541_.f_91074_.m_20189_()) * dimDiv);
    }

    private void fillFormAutomatic(WaypointEditForm form) {
        form.xText = "";
        form.yText = "";
        form.zText = "";
        form.color = (int)(Math.random() * (double)(ModSettings.ENCHANT_COLORS.length - 1)) + 1;
        form.autoInitial = true;
    }

    private void createForms() {
        this.editForms = new ArrayList();
        this.mutualForm = new WaypointEditForm();
        for (int i = 0; i < this.waypointsEdited.size(); ++i) {
            Waypoint w = this.waypointsEdited.get(i);
            WaypointEditForm form = new WaypointEditForm();
            this.fillFormWaypoint(form, w);
            this.editForms.add(form);
        }
        if (!this.startPrefilled) {
            WaypointEditForm createdForm = new WaypointEditForm();
            this.fillFormAutomatic(createdForm);
            this.editForms.add(createdForm);
        }
        this.updateMutual();
    }

    private void resetCurrentForm() {
        if (this.selectedWaypointIndex >= this.waypointsEdited.size()) {
            WaypointEditForm freshForm = new WaypointEditForm();
            this.fillFormAutomatic(freshForm);
            this.editForms.set(this.selectedWaypointIndex, freshForm);
        } else {
            Waypoint w = this.waypointsEdited.get(this.selectedWaypointIndex);
            WaypointEditForm freshForm = new WaypointEditForm();
            this.fillFormWaypoint(freshForm, w);
            this.editForms.set(this.selectedWaypointIndex, freshForm);
        }
    }

    private void updateMutual() {
        String nameTextMutual = "";
        String initialMutual = "";
        String yawMutual = "";
        String xTextMutual = "";
        String yTextMutual = "";
        String zTextMutual = "";
        boolean waypointDisabledMutual = false;
        boolean waypointGlobalMutual = false;
        int colorMutual = 0;
        colorMutual = this.differentValues(WaypointEditForm::getColor) ? 0 : this.editForms.get((int)0).color;
        xTextMutual = "";
        yTextMutual = "";
        zTextMutual = "";
        WaypointEditForm firstForm = this.editForms.get(0);
        this.mutualForm.keepName = this.differentValues(WaypointEditForm::getName);
        this.mutualForm.keepXText = this.editForms.size() > 1 && firstForm.xText.isEmpty() || this.differentValues(WaypointEditForm::getxText);
        this.mutualForm.keepYText = this.editForms.size() > 1 && firstForm.yText.isEmpty() || this.differentValues(WaypointEditForm::getyText);
        this.mutualForm.keepZText = this.editForms.size() > 1 && firstForm.zText.isEmpty() || this.differentValues(WaypointEditForm::getzText);
        this.mutualForm.defaultKeepYawText = this.mutualForm.keepYawText = this.differentValues(WaypointEditForm::getYawText);
        this.mutualForm.keepInitial = this.differentValues(WaypointEditForm::getInitial);
        this.mutualForm.autoInitial = this.editForms.size() == 1 && firstForm.autoInitial;
        this.mutualForm.defaultKeepDisabled = this.mutualForm.keepDisabled = this.differentValues(WaypointEditForm::isDisabled);
        this.mutualForm.defaultKeepGlobal = this.mutualForm.keepGlobal = this.differentValues(WaypointEditForm::isGlobal);
        if (!this.mutualForm.keepName) {
            nameTextMutual = firstForm.name;
        }
        if (!this.mutualForm.keepXText) {
            xTextMutual = firstForm.xText;
        }
        if (!this.mutualForm.keepYText) {
            yTextMutual = firstForm.yText;
        }
        if (!this.mutualForm.keepZText) {
            zTextMutual = firstForm.zText;
        }
        if (!this.mutualForm.keepYawText) {
            yawMutual = firstForm.yawText;
        }
        if (!this.mutualForm.keepInitial) {
            initialMutual = firstForm.initial;
        }
        if (!this.mutualForm.keepDisabled) {
            waypointDisabledMutual = firstForm.disabled;
        }
        if (!this.mutualForm.keepGlobal) {
            waypointGlobalMutual = firstForm.global;
        }
        this.mutualForm.name = nameTextMutual;
        this.mutualForm.xText = xTextMutual;
        this.mutualForm.yText = yTextMutual;
        this.mutualForm.zText = zTextMutual;
        this.mutualForm.yawText = yawMutual;
        this.mutualForm.initial = initialMutual;
        this.mutualForm.disabled = waypointDisabledMutual;
        this.mutualForm.global = waypointGlobalMutual;
        this.mutualForm.color = colorMutual;
    }

    private void confirmMutual() {
        for (int i = 0; i < this.editForms.size(); ++i) {
            WaypointEditForm individualForm = this.editForms.get(i);
            if (!this.mutualForm.keepName) {
                individualForm.name = this.mutualForm.name;
            }
            if (!this.mutualForm.keepXText) {
                individualForm.xText = this.mutualForm.xText;
            }
            if (!this.mutualForm.keepYText) {
                individualForm.yText = this.mutualForm.yText;
            }
            if (!this.mutualForm.keepZText) {
                individualForm.zText = this.mutualForm.zText;
            }
            if (!this.mutualForm.keepYawText) {
                individualForm.yawText = this.mutualForm.yawText;
            }
            if (!this.mutualForm.keepInitial) {
                if (!individualForm.initial.equals(this.mutualForm.initial)) {
                    individualForm.autoInitial = false;
                }
                individualForm.initial = this.mutualForm.initial;
            }
            if (!this.mutualForm.keepDisabled) {
                individualForm.disabled = this.mutualForm.disabled;
            }
            if (!this.mutualForm.keepGlobal) {
                individualForm.global = this.mutualForm.global;
            }
            if (this.mutualForm.color == 0) continue;
            individualForm.color = this.mutualForm.color;
        }
    }

    private boolean differentValues(Function<WaypointEditForm, Object> s) {
        if (this.editForms.size() == 1) {
            return false;
        }
        WaypointEditForm testWaypoint = this.editForms.get(0);
        for (int i = 1; i < this.editForms.size(); ++i) {
            WaypointEditForm w = this.editForms.get(i);
            if (s.apply(w).equals(s.apply(testWaypoint))) continue;
            return true;
        }
        return false;
    }

    public String[] createColorOptions() {
        boolean unchangedOption = this.getCurrent().color == 0;
        String[] options = new String[ModSettings.ENCHANT_COLOR_NAMES.length + (unchangedOption ? 1 : 0)];
        if (unchangedOption) {
            options[0] = this.colorPlaceholder;
        }
        for (int i = 0; i < ModSettings.ENCHANT_COLOR_NAMES.length; ++i) {
            options[i + (unchangedOption ? 1 : 0)] = i == 0 ? I18n.m_118938_((String)ModSettings.ENCHANT_COLOR_NAMES[i], (Object[])new Object[0]) : "\u00a7" + ModSettings.ENCHANT_COLORS[i] + I18n.m_118938_((String)ModSettings.ENCHANT_COLOR_NAMES[i], (Object[])new Object[0]);
        }
        return options;
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        String string = this.screenTitle = this.adding ? I18n.m_118938_((String)"gui.xaero_new_waypoint", (Object[])new Object[0]) : I18n.m_118938_((String)"gui.xaero_edit_waypoint", (Object[])new Object[0]);
        if (this.editForms.size() > 1) {
            this.screenTitle = this.screenTitle + (String)(this.editForms.size() > 1 ? " (" + (String)(this.modMain.getSettings().waypointsMutualEdit ? "" : this.selectedWaypointIndex + 1 + "/") + this.editForms.size() + ")" : "");
        }
        this.modMain.getInterfaces().setSelectedId(-1);
        this.modMain.getInterfaces().setDraggingId(-1);
        this.nameTextField = new EditBox(this.f_96547_, this.f_96543_ / 2 - 100, 104, 200, 20, (Component)new TranslatableComponent("gui.xaero_waypoint_name"));
        this.xTextField = new EditBox(this.f_96547_, this.f_96543_ / 2 - 109, 134, 50, 20, (Component)new TextComponent("x"));
        this.yTextField = new EditBox(this.f_96547_, this.f_96543_ / 2 - 53, 134, 50, 20, (Component)new TextComponent("y"));
        this.zTextField = new EditBox(this.f_96547_, this.f_96543_ / 2 + 3, 134, 50, 20, (Component)new TextComponent("z"));
        if (this.modMain.getSettings().hideWaypointCoordinates) {
            this.xTextField.m_94149_(this.censoredTextFormatter);
            this.yTextField.m_94149_(this.censoredTextFormatter);
            this.zTextField.m_94149_(this.censoredTextFormatter);
        }
        this.yawTextField = new EditBox(this.f_96547_, this.f_96543_ / 2 + 59, 134, 50, 20, (Component)new TranslatableComponent("gui.xaero_yaw"));
        this.initialTextField = new EditBox(this.f_96547_, this.f_96543_ / 2 - 25, 164, 50, 20, (Component)new TranslatableComponent("gui.xaero_initial"));
        this.m_7787_((GuiEventListener)this.nameTextField);
        this.m_7787_((GuiEventListener)this.xTextField);
        this.m_7787_((GuiEventListener)this.yTextField);
        this.m_7787_((GuiEventListener)this.zTextField);
        this.m_7787_((GuiEventListener)this.yawTextField);
        this.m_7787_((GuiEventListener)this.initialTextField);
        this.confirmButton = new MySmallButton(0, this.f_96543_ / 2 - 155, this.f_96544_ / 6 + 168, (Component)new TranslatableComponent("gui.xaero_confirm"), b -> {
            if (this.modMain.getSettings().waypointsMutualEdit) {
                this.confirmMutual();
            }
            boolean creatingAWaypoint = this.adding && this.waypointsEdited.size() < this.editForms.size();
            double dimDiv = this.waypointsManager.getDimensionDivision(this.worlds.getCurrentKeys()[0]);
            int initialEditedWaypointsSize = this.waypointsEdited.size();
            for (int i = 0; i < this.editForms.size(); ++i) {
                Waypoint w;
                int z;
                int x;
                boolean shouldCreate;
                boolean bl = shouldCreate = i >= initialEditedWaypointsSize;
                if (!creatingAWaypoint && shouldCreate) break;
                WaypointEditForm waypointForm = this.editForms.get(i);
                String nameString = waypointForm.name;
                String xString = waypointForm.xText;
                String yString = waypointForm.yText;
                String zString = waypointForm.zText;
                String initialString = waypointForm.initial;
                int colorInt = waypointForm.color;
                boolean yIncluded = !yString.equals("~");
                int n = x = xString.equals("-") || xString.isEmpty() ? this.getAutomaticX(dimDiv) : Integer.parseInt(xString);
                int y = yString.equals("-") || yString.isEmpty() ? this.getAutomaticY() : (!yIncluded ? 0 : Integer.parseInt(yString));
                int n2 = z = zString.equals("-") || zString.isEmpty() ? this.getAutomaticZ(dimDiv) : Integer.parseInt(zString);
                if (shouldCreate) {
                    w = new Waypoint(x, y, z, nameString, initialString, colorInt - 1, 0, false, yIncluded);
                    this.waypointsEdited.add(w);
                } else {
                    w = this.waypointsEdited.get(i);
                    if (w.getType() != 1 || !nameString.equals(I18n.m_118938_((String)"gui.xaero_deathpoint", (Object[])new Object[0]))) {
                        w.setName(nameString);
                        if (w.getType() == 1) {
                            w.setType(0);
                        }
                    }
                    w.setX(x);
                    w.setY(y);
                    w.setZ(z);
                    w.setSymbol(initialString);
                    w.setColor(colorInt - 1);
                    w.setYIncluded(yIncluded);
                }
                String yawText = waypointForm.yawText;
                boolean disableBool = waypointForm.disabled;
                boolean yawIsUsable = yawText.length() > 0 && !yawText.equals("-");
                w.setRotation(yawIsUsable);
                if (yawIsUsable) {
                    w.setYaw(Integer.parseInt(yawText));
                }
                w.setDisabled(disableBool);
                w.setGlobal(waypointForm.global);
            }
            WaypointWorld sourceWorld = this.defaultWorld;
            WaypointSet sourceSet = sourceWorld.getSets().get(this.fromSet);
            String[] destinationWorldKeys = this.worlds.getCurrentKeys();
            String destinationSetKey = this.sets.getCurrentSetKey();
            WaypointWorld destinationWorld = this.waypointsManager.getWorld(destinationWorldKeys[0], destinationWorldKeys[1]);
            WaypointSet destinationSet = destinationWorld.getSets().get(destinationSetKey);
            if (this.adding || sourceSet != destinationSet) {
                if (!this.modMain.getSettings().waypointsBottom) {
                    destinationSet.getList().addAll(0, this.waypointsEdited);
                } else {
                    destinationSet.getList().addAll(this.waypointsEdited);
                }
            }
            if (sourceSet != destinationSet) {
                sourceSet.getList().removeAll(this.waypointsEdited);
            }
            try {
                this.modMain.getSettings().saveWaypoints(sourceWorld);
                if (destinationWorld != sourceWorld) {
                    this.modMain.getSettings().saveWaypoints(destinationWorld);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.goBack();
        });
        this.m_142416_((GuiEventListener)this.confirmButton);
        this.m_142416_((GuiEventListener)new MySmallButton(0, this.f_96543_ / 2 + 5, this.f_96544_ / 6 + 168, (Component)new TranslatableComponent("gui.xaero_cancel", new Object[0]), b -> this.goBack()));
        this.leftButton = new Button(this.f_96543_ / 2 - 203, 104, 20, 20, (Component)new TextComponent("<"), b -> {
            --this.selectedWaypointIndex;
            if (this.selectedWaypointIndex < 0) {
                this.selectedWaypointIndex = 0;
            }
            boolean restoreFocus = this.m_7222_() == b;
            this.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
            if (restoreFocus) {
                boolean activeBU = this.leftButton.f_93623_;
                this.leftButton.f_93623_ = true;
                this.m_7522_((GuiEventListener)this.leftButton);
                this.leftButton.m_5755_(true);
                this.leftButton.f_93623_ = activeBU;
            }
        });
        this.rightButton = new Button(this.f_96543_ / 2 + 183, 104, 20, 20, (Component)new TextComponent(">"), b -> {
            ++this.selectedWaypointIndex;
            if (this.selectedWaypointIndex >= this.editForms.size()) {
                this.selectedWaypointIndex = this.editForms.size() - 1;
            }
            boolean restoreFocus = this.m_7222_() == b;
            this.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
            if (restoreFocus) {
                boolean activeBU = this.rightButton.f_93623_;
                this.rightButton.f_93623_ = true;
                this.m_7522_((GuiEventListener)this.rightButton);
                this.rightButton.m_5755_(true);
                this.rightButton.f_93623_ = activeBU;
            }
        });
        this.modeSwitchButton = new MyTinyButton(this.f_96543_ / 2 + 129, 56, null, (Component)new TranslatableComponent(this.modMain.getSettings().waypointsMutualEdit ? "gui.xaero_waypoints_edit_mode_all" : "gui.xaero_waypoints_edit_mode_individually"), b -> {
            this.modMain.getSettings().waypointsMutualEdit = !this.modMain.getSettings().waypointsMutualEdit;
            try {
                this.modMain.getSettings().saveSettings();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (this.modMain.getSettings().waypointsMutualEdit) {
                this.prefilled = true;
                this.updateMutual();
            } else {
                this.confirmMutual();
            }
            boolean restoreFocus = this.m_7222_() == b;
            this.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
            if (restoreFocus) {
                boolean activeBU = this.modeSwitchButton.f_93623_;
                this.modeSwitchButton.f_93623_ = true;
                this.m_7522_((GuiEventListener)this.modeSwitchButton);
                this.modeSwitchButton.m_5755_(true);
                this.modeSwitchButton.f_93623_ = activeBU;
            }
        });
        if (this.editForms.size() > 1) {
            this.m_142416_((GuiEventListener)this.leftButton);
            this.m_142416_((GuiEventListener)this.rightButton);
            this.m_142416_((GuiEventListener)this.modeSwitchButton);
        }
        this.resetButton = new MyTinyButton(this.f_96543_ / 2 - 204, 56, null, (Component)new TranslatableComponent("gui.xaero_waypoints_edit_reset"), b -> {
            if (this.modMain.getSettings().waypointsMutualEdit) {
                this.createForms();
                boolean restoreFocus = this.m_7222_() == b;
                this.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
                if (restoreFocus) {
                    boolean activeBU = this.resetButton.f_93623_;
                    this.resetButton.f_93623_ = true;
                    this.m_7522_((GuiEventListener)this.resetButton);
                    this.resetButton.m_5755_(true);
                    this.resetButton.f_93623_ = activeBU;
                }
            } else {
                this.resetCurrentForm();
                boolean restoreFocus = this.m_7222_() == b;
                this.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
                if (restoreFocus) {
                    boolean activeBU = this.resetButton.f_93623_;
                    this.resetButton.f_93623_ = true;
                    this.m_7522_((GuiEventListener)this.resetButton);
                    this.resetButton.m_5755_(true);
                    this.resetButton.f_93623_ = activeBU;
                }
            }
        });
        this.m_142416_((GuiEventListener)this.resetButton);
        this.nameTextField.m_94144_(this.getCurrent().name);
        this.xTextField.m_94144_(this.getCurrent().xText);
        this.yTextField.m_94144_(this.getCurrent().yText);
        this.zTextField.m_94144_(this.getCurrent().zText);
        this.yawTextField.m_94144_(this.getCurrent().yawText);
        this.initialTextField.m_94144_(this.getCurrent().initial);
        String[] enabledisable = I18n.m_118938_((String)"gui.xaero_disable_enable", (Object[])new Object[0]).split("/");
        this.disableButton = new MySuperTinyButton(this.f_96543_ / 2 + 31, 164, (Component)new TextComponent(enabledisable[this.getCurrent().disabled ? 1 : 0]), b -> {
            this.getCurrent().disabled = !this.getCurrent().disabled;
            this.disableButton.m_93666_((Component)new TextComponent(this.getCurrent().disabled ? enabledisable[1] : enabledisable[0]));
            this.getCurrent().keepDisabled = false;
            if (this.defaultDisabledButton != null) {
                this.defaultDisabledButton.f_93623_ = true;
            }
        });
        this.m_142416_((GuiEventListener)this.disableButton);
        this.globalButton = new MySuperTinyButton(this.f_96543_ / 2 - 81, 164, (Component)new TranslatableComponent(this.getCurrent().global ? "gui.xaero_waypoints_global" : "gui.xaero_waypoints_local"), b -> {
            this.getCurrent().global = !this.getCurrent().global;
            this.globalButton.m_93666_((Component)new TranslatableComponent(this.getCurrent().global ? "gui.xaero_waypoints_global" : "gui.xaero_waypoints_local"));
            this.getCurrent().keepGlobal = false;
            if (this.defaultGlobalButton != null) {
                this.defaultGlobalButton.f_93623_ = true;
            }
        });
        this.m_142416_((GuiEventListener)this.globalButton);
        if (this.getCurrent().defaultKeepYawText) {
            this.defaultYawButton = new Button(this.f_96543_ / 2 + 111, 134, 20, 20, (Component)new TextComponent("-"), b -> {
                this.getCurrent().keepYawText = true;
                this.getCurrent().yawText = "";
                this.yawTextField.m_94144_(this.getCurrent().yawText);
                b.f_93623_ = false;
            });
            this.m_142416_((GuiEventListener)this.defaultYawButton);
            boolean bl = this.defaultYawButton.f_93623_ = !this.getCurrent().keepYawText;
        }
        if (this.getCurrent().defaultKeepDisabled) {
            this.defaultDisabledButton = new Button(this.f_96543_ / 2 + 81, 164, 20, 20, (Component)new TextComponent("-"), b -> {
                this.getCurrent().keepDisabled = true;
                this.getCurrent().disabled = false;
                this.disableButton.m_93666_((Component)new TextComponent(this.getCurrent().disabled ? enabledisable[1] : enabledisable[0]));
                b.f_93623_ = false;
            });
            this.m_142416_((GuiEventListener)this.defaultDisabledButton);
            boolean bl = this.defaultDisabledButton.f_93623_ = !this.getCurrent().keepDisabled;
        }
        if (this.getCurrent().defaultKeepGlobal) {
            this.defaultGlobalButton = new Button(this.f_96543_ / 2 - 101, 164, 20, 20, (Component)new TextComponent("-"), b -> {
                this.getCurrent().keepGlobal = true;
                this.getCurrent().global = false;
                this.globalButton.m_93666_((Component)new TranslatableComponent(this.getCurrent().global ? "gui.xaero_waypoints_global" : "gui.xaero_waypoints_local"));
                b.f_93623_ = false;
            });
            this.m_142416_((GuiEventListener)this.defaultGlobalButton);
            boolean bl = this.defaultGlobalButton.f_93623_ = !this.getCurrent().keepGlobal;
        }
        if (this.modMain.getSettings().hideWaypointCoordinates) {
            this.m_142416_((GuiEventListener)new MySuperTinyButton(this.f_96543_ / 2 + 115, 134, (Component)new TranslatableComponent(this.censorCoordsIfNeeded ? "gui.xaero_waypoints_edit_show" : "gui.xaero_waypoints_edit_hide"), b -> {
                this.censorCoordsIfNeeded = !this.censorCoordsIfNeeded;
                b.m_93666_((Component)new TranslatableComponent(this.censorCoordsIfNeeded ? "gui.xaero_waypoints_edit_show" : "gui.xaero_waypoints_edit_hide"));
            }));
        }
        this.dropDowns.clear();
        int currentColor = this.getCurrent().color;
        this.colorDD = new GuiDropDown(this.createColorOptions(), this.f_96543_ / 2 - 60, 82, 120, currentColor == 0 ? 0 : currentColor - 1, this);
        this.dropDowns.add(this.colorDD);
        this.setsDD = new GuiDropDown(this.sets.getOptions(), this.f_96543_ / 2 - 101, 60, 201, this.sets.getCurrentSet(), this);
        this.dropDowns.add(this.setsDD);
        this.containersDD = new GuiDropDown(this.containers.options, this.f_96543_ / 2 - 203, 38, 200, this.containers.current, this);
        this.dropDowns.add(this.containersDD);
        this.worldsDD = new GuiDropDown(this.worlds.options, this.f_96543_ / 2 + 2, 38, 200, this.worlds.current, this);
        this.dropDowns.add(this.worldsDD);
        this.m_7522_((GuiEventListener)this.nameTextField);
        this.nameTextField.m_94178_(true);
        this.f_96541_.f_91068_.m_90926_(true);
        this.updateConfirmButton();
    }

    private WaypointEditForm getCurrent() {
        return this.modMain.getSettings().waypointsMutualEdit ? this.mutualForm : this.editForms.get(this.selectedWaypointIndex);
    }

    public void m_7861_() {
        this.f_96541_.f_91068_.m_90926_(false);
    }

    public boolean m_7933_(int par1, int par2, int par3) {
        GuiEventListener focused = this.m_7222_();
        this.preType(focused);
        boolean result = super.m_7933_(par1, par2, par3);
        this.postType(focused);
        if (focused instanceof EditBox && this.canConfirm() && (par1 == 257 || par1 == 335)) {
            this.confirmButton.m_5716_(0.0, 0.0);
        }
        return result;
    }

    public boolean m_5534_(char par1, int par2) {
        GuiEventListener focused = this.m_7222_();
        this.preType(focused);
        boolean result = super.m_5534_(par1, par2);
        this.postType(focused);
        return result;
    }

    private void preType(GuiEventListener focused) {
        if (focused == null) {
            return;
        }
    }

    private void postType(GuiEventListener focused) {
        if (focused == null) {
            return;
        }
        if (this.nameTextField == focused) {
            if (!(!this.getCurrent().autoInitial || this.nameTextField.m_94155_().length() <= 0 || this.getCurrent().keepInitial && this.modMain.getSettings().waypointsMutualEdit)) {
                this.initialTextField.m_94144_(this.nameTextField.m_94155_().substring(0, 1).toUpperCase());
            }
        } else if (this.yawTextField == focused) {
            this.fieldValidator.validate(this.yawTextField);
            this.getCurrent().keepYawText = false;
            if (this.defaultYawButton != null) {
                this.defaultYawButton.f_93623_ = true;
            }
        } else if (this.initialTextField == focused) {
            this.getCurrent().autoInitial = false;
        }
        this.checkFields();
        this.updateConfirmButton();
    }

    public void m_7522_(GuiEventListener l) {
        this.preType(l);
        GuiEventListener currentFocused = this.m_7222_();
        if (currentFocused != null && currentFocused != l && currentFocused instanceof EditBox) {
            ((EditBox)currentFocused).m_94178_(false);
        }
        super.m_7522_(l);
    }

    private boolean canConfirm() {
        WaypointEditForm current = this.getCurrent();
        return !(!current.keepName && current.name.length() <= 0 || !current.keepInitial && current.initial.length() <= 0);
    }

    private void updateConfirmButton() {
        this.confirmButton.f_93623_ = this.modeSwitchButton.f_93623_ = this.canConfirm();
        this.leftButton.f_93623_ = !this.modMain.getSettings().waypointsMutualEdit && this.canConfirm() && this.selectedWaypointIndex > 0;
        this.rightButton.f_93623_ = !this.modMain.getSettings().waypointsMutualEdit && this.canConfirm() && this.selectedWaypointIndex < this.editForms.size() - 1;
    }

    protected void checkFields() {
        this.fieldValidator.validate(this.xTextField);
        this.fieldYValidator.validate(this.yTextField);
        this.fieldValidator.validate(this.zTextField);
        WaypointEditForm current = this.getCurrent();
        current.name = this.nameTextField.m_94155_();
        current.xText = this.xTextField.m_94155_();
        current.yText = this.yTextField.m_94155_();
        current.zText = this.zTextField.m_94155_();
        current.yawText = this.yawTextField.m_94155_();
        current.initial = this.initialTextField.m_94155_();
        current.initial = current.initial.toUpperCase();
        if (current.initial.length() > 2) {
            current.initial = current.initial.substring(0, 2);
            this.initialTextField.m_94144_(current.initial);
        }
        if (current.yawText.length() > 4) {
            current.yawText = current.yawText.substring(0, 4);
            this.yawTextField.m_94144_(current.yawText);
        }
        if (this.prefilled && this.editForms.size() > 1 && this.modMain.getSettings().waypointsMutualEdit) {
            current.keepName = current.name.isEmpty();
            current.keepXText = current.xText.isEmpty();
            current.keepYText = current.yText.isEmpty();
            current.keepZText = current.zText.isEmpty();
            current.keepInitial = current.initial.isEmpty();
        }
    }

    public boolean m_6375_(double par1, double par2, int par3) {
        for (GuiDropDown d : this.dropDowns) {
            if (!d.isClosed() && d.onDropDown((int)par1, (int)par2, this.f_96544_)) {
                d.mouseClicked((int)par1, (int)par2, par3, this.f_96544_);
                return true;
            }
            d.setClosed(true);
        }
        for (GuiDropDown d : this.dropDowns) {
            if (d.onDropDown((int)par1, (int)par2, this.f_96544_)) {
                d.mouseClicked((int)par1, (int)par2, par3, this.f_96544_);
                return true;
            }
            d.setClosed(true);
        }
        return super.m_6375_(par1, par2, par3);
    }

    public boolean m_6348_(double par1, double par2, int par3) {
        for (GuiDropDown d : this.dropDowns) {
            d.mouseReleased((int)par1, (int)par2, par3, this.f_96544_);
        }
        return super.m_6348_(par1, par2, par3);
    }

    private void setFieldText(EditBox field, String text) {
        this.setFieldText(field, text, -1);
    }

    private void setFieldText(EditBox field, String text, int color) {
        field.m_94202_(color);
        if (field.m_94155_().equals(text)) {
            return;
        }
        field.m_94144_(text);
    }

    public void m_96624_() {
        if (this.f_96541_.f_91074_ == null) {
            this.f_96541_.m_91152_(null);
            return;
        }
        this.nameTextField.m_94120_();
        this.xTextField.m_94120_();
        this.yTextField.m_94120_();
        this.zTextField.m_94120_();
        this.yawTextField.m_94120_();
        this.initialTextField.m_94120_();
    }

    public void m_6305_(PoseStack matrixStack, int par1, int par2, float par3) {
        this.renderEscapeScreen(matrixStack, par1, par2, par3);
        this.m_7333_(matrixStack);
        super.m_6305_(matrixStack, par1, par2, par3);
        GuiComponent.m_93208_((PoseStack)matrixStack, (Font)this.f_96547_, (String)this.screenTitle, (int)(this.f_96543_ / 2), (int)20, (int)0xFFFFFF);
        WaypointEditForm current = this.getCurrent();
        if (!this.nameTextField.m_93696_() && current.keepName) {
            this.setFieldText(this.nameTextField, this.namePlaceholder, -11184811);
            this.nameTextField.m_94192_(0);
        }
        double dimDiv = this.waypointsManager.getDimensionDivision(this.worlds.getCurrentKeys()[0]);
        if (current.keepXText) {
            if (!this.xTextField.m_93696_()) {
                this.setFieldText(this.xTextField, this.xPlaceholder, -11184811);
            }
        } else if (current.xText.isEmpty()) {
            this.setFieldText(this.xTextField, "" + this.getAutomaticX(dimDiv), -11184811);
            this.xTextField.m_94192_(0);
        }
        if (current.keepYText) {
            if (!this.yTextField.m_93696_()) {
                this.setFieldText(this.yTextField, this.yPlaceholder, -11184811);
            }
        } else if (current.yText.isEmpty()) {
            this.setFieldText(this.yTextField, "" + this.getAutomaticY(), -11184811);
            this.yTextField.m_94192_(0);
        }
        if (current.keepZText) {
            if (!this.zTextField.m_93696_()) {
                this.setFieldText(this.zTextField, this.zPlaceholder, -11184811);
            }
        } else if (current.zText.isEmpty()) {
            this.setFieldText(this.zTextField, "" + this.getAutomaticZ(dimDiv), -11184811);
            this.zTextField.m_94192_(0);
        }
        if (!this.yawTextField.m_93696_() && current.yawText.isEmpty()) {
            if (current.keepYawText) {
                this.setFieldText(this.yawTextField, this.yawPlaceholder, -11184811);
            } else {
                this.setFieldText(this.yawTextField, I18n.m_118938_((String)"gui.xaero_yaw", (Object[])new Object[0]), -11184811);
            }
            this.yawTextField.m_94192_(0);
        }
        if (!this.initialTextField.m_93696_() && current.initial.isEmpty()) {
            if (current.keepInitial) {
                this.setFieldText(this.initialTextField, this.initialPlaceholder, -11184811);
            } else {
                this.setFieldText(this.initialTextField, I18n.m_118938_((String)"gui.xaero_initial", (Object[])new Object[0]), -11184811);
            }
            this.initialTextField.m_94192_(0);
        }
        this.nameTextField.m_6305_(matrixStack, par1, par2, par3);
        this.xTextField.m_6305_(matrixStack, par1, par2, par3);
        this.yTextField.m_6305_(matrixStack, par1, par2, par3);
        this.zTextField.m_6305_(matrixStack, par1, par2, par3);
        this.yawTextField.m_6305_(matrixStack, par1, par2, par3);
        this.initialTextField.m_6305_(matrixStack, par1, par2, par3);
        this.setFieldText(this.nameTextField, current.name);
        this.setFieldText(this.xTextField, current.xText);
        this.setFieldText(this.yTextField, current.yText);
        this.setFieldText(this.zTextField, current.zText);
        this.setFieldText(this.yawTextField, current.yawText);
        this.setFieldText(this.initialTextField, current.initial);
        if (this.dropped) {
            super.m_6305_(matrixStack, 0, 0, par3);
        } else {
            super.m_6305_(matrixStack, par1, par2, par3);
        }
        this.dropped = false;
        GuiDropDown openDropdown = null;
        for (int k = 0; k < this.dropDowns.size(); ++k) {
            GuiDropDown dropdown = this.dropDowns.get(k);
            if (!dropdown.isClosed()) {
                this.dropped = true;
                openDropdown = dropdown;
                continue;
            }
            dropdown.drawButton(matrixStack, par1, par2, this.f_96544_);
        }
        if (openDropdown != null) {
            openDropdown.drawButton(matrixStack, par1, par2, this.f_96544_);
        }
    }

    public boolean m_6050_(double p_mouseScrolled_1_, double p_mouseScrolled_3_, double wheel) {
        if ((int)wheel != 0) {
            int mouseXScaled = (int)(Misc.getMouseX(Minecraft.m_91087_()) / Minecraft.m_91087_().m_91268_().m_85449_());
            int mouseYScaled = (int)(Misc.getMouseY(Minecraft.m_91087_()) / Minecraft.m_91087_().m_91268_().m_85449_());
            for (GuiDropDown d : this.dropDowns) {
                if (d.isClosed() || !d.onDropDown(mouseXScaled, mouseYScaled, this.f_96544_)) continue;
                d.mouseScrolled((int)wheel, mouseXScaled, mouseYScaled, this.f_96544_);
                return true;
            }
        }
        return super.m_6050_(p_mouseScrolled_1_, p_mouseScrolled_3_, wheel);
    }

    @Override
    public boolean onSelected(GuiDropDown menu, int selected) {
        if (menu == this.setsDD) {
            this.sets.setCurrentSet(selected);
            if (this.waypointsManager.getCurrentContainerAndWorldID().equals(this.worlds.getCurrentKey())) {
                this.waypointsManager.getCurrentWorld().setCurrent(this.sets.getCurrentSetKey());
                this.waypointsManager.updateWaypoints();
                try {
                    this.modMain.getSettings().saveWaypoints(this.waypointsManager.getCurrentWorld());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else if (menu == this.colorDD) {
            this.getCurrent().color = this.colorDD.size() > ModSettings.ENCHANT_COLORS.length ? selected : selected + 1;
        } else if (menu == this.containersDD) {
            this.containers.current = selected;
            WaypointWorld currentWorld = this.containers.current != this.defaultContainer ? this.waypointsManager.getWorldContainer(this.containers.getCurrentKey()).getFirstWorld() : this.defaultWorld;
            this.sets = new GuiWaypointSets(false, currentWorld, this.containers.current == this.defaultContainer ? this.fromSet : currentWorld.getCurrent());
            this.worlds = new GuiWaypointWorlds(this.waypointsManager.getWorldContainer(this.containers.getCurrentKey()), this.waypointsManager, currentWorld.getFullId(), this.frozenAutoContainerID, this.frozenAutoWorldID);
            this.setsDD = new GuiDropDown(this.sets.getOptions(), this.f_96543_ / 2 - 101, 60, 201, this.sets.getCurrentSet(), this);
            this.dropDowns.set(1, this.setsDD);
            this.worldsDD = new GuiDropDown(this.worlds.options, this.f_96543_ / 2 + 2, 38, 200, this.worlds.current, this);
            this.dropDowns.set(3, this.worldsDD);
        } else if (menu == this.worldsDD) {
            WaypointWorld currentWorld;
            this.worlds.current = selected;
            String[] worldKeys = this.worlds.getCurrentKeys();
            this.sets = new GuiWaypointSets(false, currentWorld, (currentWorld = this.waypointsManager.getWorld(worldKeys[0], worldKeys[1])) == this.defaultWorld ? this.fromSet : currentWorld.getCurrent());
            this.setsDD = new GuiDropDown(this.sets.getOptions(), this.f_96543_ / 2 - 101, 60, 201, this.sets.getCurrentSet(), this);
            this.dropDowns.set(1, this.setsDD);
        }
        return true;
    }
}

