/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import xaero.common.IXaeroMinimap;
import xaero.common.graphics.CursorBox;
import xaero.common.gui.GuiDropDown;
import xaero.common.gui.IDropDownCallback;
import xaero.common.gui.MySmallButton;
import xaero.common.gui.MyTinyButton;
import xaero.common.gui.ScreenBase;
import xaero.common.misc.Misc;
import xaero.common.settings.ModOptions;
import xaero.common.settings.ModSettings;

public class GuiEntityRadar
extends ScreenBase
implements IDropDownCallback {
    private final int ROW_HEIGHT = 25;
    private ArrayList<RadarCategory> categories;
    private boolean dropped;
    private String[] colorOptions;
    public CursorBox nameTooltip = new CursorBox("gui.xaero_box_entity_radar_names");
    public CursorBox iconTooltip = new CursorBox("gui.xaero_box_entity_radar_icons");

    public GuiEntityRadar(IXaeroMinimap modMain, Screen par1GuiScreen, Screen escape) {
        super(modMain, par1GuiScreen, escape, (Component)new TranslatableComponent("gui.xaero_entity_radar"));
        this.categories = new ArrayList();
        this.colorOptions = this.createColorOptions();
        String[] playerOptions = new String[this.colorOptions.length + 1];
        String[] teamOptions = new String[this.colorOptions.length + 1];
        String[] tamedOptions = new String[this.colorOptions.length + 1];
        for (int i = 0; i < this.colorOptions.length; ++i) {
            playerOptions[i] = this.colorOptions[i];
            teamOptions[i + 1] = this.colorOptions[i];
            tamedOptions[i + 1] = this.colorOptions[i];
        }
        playerOptions[this.colorOptions.length] = "gui.xaero_team_colours";
        teamOptions[0] = "gui.xaero_players";
        tamedOptions[0] = "gui.xaero_untamed_color";
        ModSettings settings = modMain.getSettings();
        this.categories.add(new RadarCategory("gui.xaero_players", settings.playersColor != -1 ? settings.playersColor : this.colorOptions.length, settings.playerNames, settings.playerIcons, 3, this.categories.size(), playerOptions, ModOptions.PLAYERS){

            @Override
            public void onConfirm(ModSettings settings) {
                settings.playersColor = this.color < GuiEntityRadar.this.colorOptions.length ? this.color : -1;
                settings.playerNames = this.names;
                settings.playerIcons = this.icons;
            }
        });
        this.categories.add(new RadarCategory("gui.xaero_other_teams", settings.otherTeamColor + 1, settings.otherTeamsNames, -4, 4, this.categories.size(), teamOptions, ModOptions.DISPLAY_OTHER_TEAM){

            @Override
            public void onConfirm(ModSettings settings) {
                settings.otherTeamColor = this.color - 1;
                settings.otherTeamsNames = this.names;
            }
        });
        this.categories.add(new RadarCategory("gui.xaero_mobs", settings.mobsColor, settings.friendlyMobNames, settings.mobIcons, 3, this.categories.size(), this.colorOptions, ModOptions.MOBS){

            @Override
            public void onConfirm(ModSettings settings) {
                settings.mobsColor = this.color;
                settings.friendlyMobNames = this.names;
                settings.mobIcons = this.icons;
            }
        });
        this.categories.add(new RadarCategory("gui.xaero_hostile", settings.hostileColor, settings.hostileMobNames, settings.hostileIcons, 3, this.categories.size(), this.colorOptions, ModOptions.HOSTILE){

            @Override
            public void onConfirm(ModSettings settings) {
                settings.hostileColor = this.color;
                settings.hostileMobNames = this.names;
                settings.hostileIcons = this.icons;
            }
        });
        this.categories.add(new RadarCategory("gui.xaero_tamed", settings.tamedMobsColor + 1, settings.tamedMobNames, settings.tamedIcons, 4, this.categories.size(), tamedOptions, ModOptions.TAMED){

            @Override
            public void onConfirm(ModSettings settings) {
                settings.tamedMobsColor = this.color - 1;
                settings.tamedMobNames = this.names;
                settings.tamedIcons = this.icons;
            }
        });
        this.categories.add(new RadarCategory("gui.xaero_items", settings.itemsColor, settings.itemNames, -1, 3, this.categories.size(), this.colorOptions, ModOptions.ITEMS){

            @Override
            public void onConfirm(ModSettings settings) {
                settings.itemsColor = this.color;
                settings.itemNames = this.names;
            }
        });
        this.categories.add(new RadarCategory("gui.xaero_other", settings.otherColor, settings.otherNames, -1, 3, this.categories.size(), this.colorOptions, ModOptions.ENTITIES){

            @Override
            public void onConfirm(ModSettings settings) {
                settings.otherColor = this.color;
                settings.otherNames = this.names;
            }
        });
    }

    private String[] createColorOptions() {
        String[] options = new String[ModSettings.ENCHANT_COLOR_NAMES.length];
        for (int i = 0; i < options.length; ++i) {
            options[i] = i == 0 ? I18n.m_118938_((String)ModSettings.ENCHANT_COLOR_NAMES[i], (Object[])new Object[0]) : "\u00a7" + ModSettings.ENCHANT_COLORS[i] + I18n.m_118938_((String)ModSettings.ENCHANT_COLOR_NAMES[i], (Object[])new Object[0]);
        }
        return options;
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.m_142416_((GuiEventListener)new MySmallButton(200, this.f_96543_ / 2 - 155, this.f_96544_ / 6 + 168, (Component)new TranslatableComponent("gui.xaero_confirm", new Object[0]), b -> {
            ModSettings settings = this.modMain.getSettings();
            for (RadarCategory c : this.categories) {
                c.onConfirm(settings);
                c.onDisplayOptionConfirm(settings);
            }
            try {
                settings.saveSettings();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.goBack();
        }));
        this.m_142416_((GuiEventListener)new MySmallButton(201, this.f_96543_ / 2 + 5, this.f_96544_ / 6 + 168, (Component)new TranslatableComponent("gui.xaero_cancel", new Object[0]), b -> this.goBack()));
        for (RadarCategory c : this.categories) {
            c.init();
        }
    }

    public void m_6305_(PoseStack matrixStack, int par1, int par2, float par3) {
        this.m_7333_(matrixStack);
        GuiComponent.m_93215_((PoseStack)matrixStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)5, (int)0xFFFFFF);
        GuiComponent.m_93208_((PoseStack)matrixStack, (Font)this.f_96547_, (String)I18n.m_118938_((String)"gui.xaero_entity_radar_type", (Object[])new Object[0]), (int)(this.f_96543_ / 2 - 176), (int)(this.f_96544_ / 12), (int)-1);
        GuiComponent.m_93208_((PoseStack)matrixStack, (Font)this.f_96547_, (String)I18n.m_118938_((String)"gui.xaero_entity_radar_color", (Object[])new Object[0]), (int)(this.f_96543_ / 2 - 76), (int)(this.f_96544_ / 12), (int)-1);
        GuiComponent.m_93208_((PoseStack)matrixStack, (Font)this.f_96547_, (String)I18n.m_118938_((String)"gui.xaero_entity_radar_visiblity", (Object[])new Object[0]), (int)(this.f_96543_ / 2 + 24), (int)(this.f_96544_ / 12), (int)-1);
        GuiComponent.m_93208_((PoseStack)matrixStack, (Font)this.f_96547_, (String)I18n.m_118938_((String)"gui.xaero_entity_radar_names", (Object[])new Object[0]), (int)(this.f_96543_ / 2 + 100), (int)(this.f_96544_ / 12), (int)-1);
        GuiComponent.m_93208_((PoseStack)matrixStack, (Font)this.f_96547_, (String)I18n.m_118938_((String)"gui.xaero_entity_radar_icons", (Object[])new Object[0]), (int)(this.f_96543_ / 2 + 176), (int)(this.f_96544_ / 12), (int)-1);
        for (RadarCategory c : this.categories) {
            c.render(matrixStack, par1, par2, par3);
        }
        if (this.dropped) {
            super.m_6305_(matrixStack, 0, 0, par3);
        } else {
            super.m_6305_(matrixStack, par1, par2, par3);
        }
        this.dropped = false;
        for (RadarCategory c : this.categories) {
            if (!c.onDropdownRender(matrixStack, par1, par2, par3, true)) continue;
            this.dropped = true;
        }
        for (RadarCategory c : this.categories) {
            c.onDropdownRender(matrixStack, par1, par2, par3, false);
        }
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, 0.0, 0.1);
        for (GuiEventListener el : this.m_6702_()) {
            AbstractWidget b;
            if (!(el instanceof AbstractWidget) || !((b = (AbstractWidget)el) instanceof MyTinyButton)) continue;
            MyTinyButton optionWidget = (MyTinyButton)b;
            if (!optionWidget.f_93623_ || optionWidget.getTooltip() == null || par1 < b.f_93620_ || par2 < b.f_93621_ || par1 >= b.f_93620_ + b.m_5711_() || par2 >= b.f_93621_ + b.m_93694_()) continue;
            optionWidget.getTooltip().drawBox(matrixStack, par1, par2, this.f_96543_, this.f_96544_);
        }
        matrixStack.m_85849_();
    }

    @Override
    public boolean onSelected(GuiDropDown menu, int selected) {
        for (RadarCategory c : this.categories) {
            if (!c.onDropdownSelect(menu, selected)) continue;
            return true;
        }
        return false;
    }

    public boolean m_6375_(double par1, double par2, int par3) {
        for (RadarCategory c : this.categories) {
            if (!c.onClick(par1, par2, par3, false)) continue;
            return true;
        }
        for (RadarCategory c : this.categories) {
            if (!c.onClick(par1, par2, par3, true)) continue;
            return true;
        }
        return super.m_6375_(par1, par2, par3);
    }

    public boolean m_6348_(double par1, double par2, int par3) {
        for (RadarCategory c : this.categories) {
            c.onRelease(par1, par2, par3);
        }
        return super.m_6348_(par1, par2, par3);
    }

    public boolean m_6050_(double mouseX, double mouseY, double wheel) {
        if ((int)wheel != 0) {
            int mouseXScaled = (int)(Misc.getMouseX(Minecraft.m_91087_()) / Minecraft.m_91087_().m_91268_().m_85449_());
            int mouseYScaled = (int)(Misc.getMouseY(Minecraft.m_91087_()) / Minecraft.m_91087_().m_91268_().m_85449_());
            for (RadarCategory c : this.categories) {
                if (!c.onScroll(mouseXScaled, mouseYScaled, wheel)) continue;
                return true;
            }
        }
        return super.m_6050_(mouseX, mouseY, wheel);
    }

    public abstract class RadarCategory {
        String name;
        int index;
        GuiDropDown dropdown;
        int color;
        int names;
        int icons;
        boolean display;
        boolean initialDisplay;
        int totalNames;
        String[] dropdownOptions;
        ModOptions displayOption;

        public RadarCategory(String name, int color, int names, int icons, int totalNames, int index, String[] dropdownOptions, ModOptions displayOption) {
            this.name = name;
            this.color = color;
            this.names = names;
            this.icons = icons;
            this.display = this.initialDisplay = GuiEntityRadar.this.modMain.getSettings().getClientBooleanValue(displayOption);
            this.index = index;
            this.dropdownOptions = dropdownOptions;
            this.displayOption = displayOption;
            this.totalNames = totalNames;
        }

        public void init() {
            this.dropdown = new GuiDropDown(this.dropdownOptions, GuiEntityRadar.this.f_96543_ / 2 - 136, GuiEntityRadar.this.f_96544_ / 12 + 20 + 25 * this.index, 120, this.color, GuiEntityRadar.this);
            GuiEntityRadar.this.m_142416_((GuiEventListener)new MyTinyButton(null, GuiEntityRadar.this.f_96543_ / 2 - 13, GuiEntityRadar.this.f_96544_ / 12 + 16 + 25 * this.index, ModOptions.MOBS, (Component)new TextComponent(this.getDisplayButtonText()), this::onSettingClicked));
            GuiEntityRadar.this.m_142416_((GuiEventListener)new MyTinyButton(GuiEntityRadar.this.nameTooltip, GuiEntityRadar.this.f_96543_ / 2 + 63, GuiEntityRadar.this.f_96544_ / 12 + 16 + 25 * this.index, (Component)new TranslatableComponent(ModSettings.ENTITY_NAMES_OPTIONS[this.names]), b -> {
                this.names = (this.names + 1) % this.totalNames;
                b.m_93666_((Component)new TranslatableComponent(ModSettings.ENTITY_NAMES_OPTIONS[this.names]));
            }));
            int icons = this.icons;
            if (icons < 0) {
                icons = -icons - 1;
            }
            MyTinyButton iconsButton = new MyTinyButton(GuiEntityRadar.this.iconTooltip, GuiEntityRadar.this.f_96543_ / 2 + 139, GuiEntityRadar.this.f_96544_ / 12 + 16 + 25 * this.index, (Component)new TranslatableComponent(ModSettings.ENTITY_ICONS_OPTIONS[icons]), b -> {
                this.icons = (this.icons + 1) % this.totalNames;
                b.m_93666_((Component)new TranslatableComponent(ModSettings.ENTITY_ICONS_OPTIONS[this.icons]));
            });
            if (this.icons < 0) {
                iconsButton.f_93623_ = false;
            }
            GuiEntityRadar.this.m_142416_((GuiEventListener)iconsButton);
        }

        public void render(PoseStack matrixStack, int par1, int par2, float par3) {
            GuiComponent.m_93208_((PoseStack)matrixStack, (Font)GuiEntityRadar.this.f_96547_, (String)I18n.m_118938_((String)this.name, (Object[])new Object[0]), (int)(GuiEntityRadar.this.f_96543_ / 2 - 176), (int)(GuiEntityRadar.this.f_96544_ / 12 + 22 + 25 * this.index), (int)-5592406);
        }

        public boolean onDropdownRender(PoseStack matrixStack, int par1, int par2, float par3, boolean closed) {
            if (closed == this.dropdown.isClosed()) {
                this.dropdown.drawButton(matrixStack, par1, par2, GuiEntityRadar.this.f_96544_);
                return false;
            }
            return true;
        }

        public boolean onDropdownSelect(GuiDropDown menu, int selected) {
            if (menu == this.dropdown) {
                this.color = selected;
                return true;
            }
            return false;
        }

        public boolean onClick(double par1, double par2, int par3, boolean closed) {
            if (closed == this.dropdown.isClosed() && this.dropdown.onDropDown((int)par1, (int)par2, GuiEntityRadar.this.f_96544_)) {
                this.dropdown.mouseClicked((int)par1, (int)par2, par3, GuiEntityRadar.this.f_96544_);
                return true;
            }
            this.dropdown.setClosed(true);
            return false;
        }

        public boolean onRelease(double par1, double par2, int par3) {
            this.dropdown.mouseReleased((int)par1, (int)par2, par3, GuiEntityRadar.this.f_96544_);
            return true;
        }

        public boolean onScroll(int mouseXScaled, int mouseYScaled, double wheel) {
            if (!this.dropdown.isClosed() && this.dropdown.onDropDown(mouseXScaled, mouseYScaled, GuiEntityRadar.this.f_96544_)) {
                this.dropdown.mouseScrolled((int)wheel, mouseXScaled, mouseYScaled, GuiEntityRadar.this.f_96544_);
                return true;
            }
            return false;
        }

        private void onSettingClicked(Button b) {
            this.display = !this.display;
            b.m_93666_((Component)new TextComponent(this.getDisplayButtonText()));
        }

        private String getDisplayButtonText() {
            Object s = "";
            boolean serverSetting = GuiEntityRadar.this.modMain.getSettings().getBooleanValue(this.displayOption);
            s = (String)s + ModSettings.getTranslation(this.display) + (String)(serverSetting != this.initialDisplay ? "\u00a7e (" + ModSettings.getTranslation(serverSetting) + ")" : "");
            return s;
        }

        public void onDisplayOptionConfirm(ModSettings settings) {
            if (this.display != this.initialDisplay) {
                settings.toggleBooleanOptionValue(this.displayOption);
            }
        }

        public abstract void onConfirm(ModSettings var1);
    }
}

