/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.interfaces.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.client.gui.IIngameOverlay;
import net.minecraftforge.client.gui.OverlayRegistry;
import org.lwjgl.opengl.GL11;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.anim.OldAnimation;
import xaero.common.graphics.CustomVertexConsumers;
import xaero.common.gui.GuiEditMode;
import xaero.common.interfaces.Interface;
import xaero.common.interfaces.InterfaceInstance;
import xaero.common.interfaces.InterfaceManager;
import xaero.common.interfaces.pushbox.PushBox;
import xaero.common.misc.Misc;

public class InterfaceRenderer {
    public static final ResourceLocation guiTextures = new ResourceLocation("xaerobetterpvp", "gui/guis.png");
    private CustomVertexConsumers customVertexConsumers;
    private IXaeroMinimap modMain;
    private final int disabled = 1354612157;
    private final int enabled = 0x64FFFFFF;
    private final int selected = -2097152001;
    private IIngameOverlay overlay;

    public InterfaceRenderer(IXaeroMinimap modMain) {
        this.modMain = modMain;
        this.customVertexConsumers = new CustomVertexConsumers();
    }

    public void renderInterfaces(XaeroMinimapSession minimapSession, PoseStack matrixStack, float partial) {
        while (GL11.glGetError() != 0) {
        }
        Minecraft mc = Minecraft.m_91087_();
        int width = mc.m_91268_().m_85445_();
        int height = mc.m_91268_().m_85446_();
        double scale = mc.m_91268_().m_85449_();
        int mouseX = (int)(Misc.getMouseX(mc) * (double)width / (double)mc.m_91268_().m_85441_());
        int mouseY = (int)(Misc.getMouseY(mc) * (double)height / (double)mc.m_91268_().m_85442_());
        InterfaceManager interfaceManager = this.modMain.getInterfaces();
        interfaceManager.updateInterfaces(minimapSession, mouseX, mouseY, width, height, scale);
        Iterator<Interface> iter = this.modMain.getInterfaces().getInterfaceIterator();
        while (iter.hasNext()) {
            Interface l = iter.next();
            if (!this.modMain.getSettings().getBooleanValue(l.getOption())) continue;
            InterfaceInstance ii = minimapSession.getInterfaceInstances().get(l);
            int xBU = l.getX();
            int yBU = l.getY();
            interfaceManager.pushInterface(l, ii, scale, width, height);
            ii.render(matrixStack, width, height, scale, partial, this.customVertexConsumers);
            l.setX(xBU);
            l.setY(yBU);
        }
        for (PushBox pb : interfaceManager.pushBoxes) {
            pb.postUpdate();
        }
        RenderSystem.m_69482_();
    }

    public void renderBoxes(PoseStack matrixStack, int mouseX, int mouseY, int width, int height, double d) {
        if (this.modMain.getEvents().getLastGuiOpen() instanceof GuiEditMode) {
            XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
            int mouseOverId = this.modMain.getInterfaces().getInterfaceId(minimapSession, mouseX, mouseY, width, height, d);
            InterfaceManager interfaces = this.modMain.getInterfaces();
            Iterator<Interface> iter = interfaces.getInterfaceIterator();
            int i = -1;
            while (iter.hasNext()) {
                ++i;
                Interface l = iter.next();
                if (!this.modMain.getSettings().getBooleanValue(l.getOption())) continue;
                InterfaceInstance li = minimapSession.getInterfaceInstances().get(l);
                int x = l.getX();
                int y = l.getY();
                int w = li.getW(d);
                int h = li.getH(d);
                int x2 = x + w;
                int y2 = y + h;
                if (interfaces.getSelectedId() == i || !interfaces.overAButton(mouseX, mouseY) && mouseX >= x && mouseX <= x2 && mouseY >= y && mouseY <= y2 || i == interfaces.getDraggingId()) {
                    GuiComponent.m_93172_((PoseStack)matrixStack, (int)x, (int)y, (int)x2, (int)y2, (int)(interfaces.getSelectedId() == i ? -2097152001 : 0x64FFFFFF));
                    if (interfaces.getDraggingId() != -1 || i != mouseOverId) continue;
                    l.getcBox().drawBox(matrixStack, mouseX, mouseY, width, height);
                    continue;
                }
                GuiComponent.m_93172_((PoseStack)matrixStack, (int)x, (int)y, (int)x2, (int)y2, (int)1354612157);
            }
        }
    }

    public CustomVertexConsumers getCustomVertexConsumers() {
        return this.customVertexConsumers;
    }

    public void registerOverlay() {
        this.overlay = new IIngameOverlay(){

            public void render(ForgeIngameGui gui, PoseStack matrixStack, float partialTicks, int width, int height) {
                RenderSystem.m_69421_((int)256, (boolean)Minecraft.f_91002_);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
                if (minimapSession != null) {
                    InterfaceRenderer.this.modMain.getInterfaceRenderer().renderInterfaces(minimapSession, matrixStack, partialTicks);
                    InterfaceRenderer.this.modMain.getInterfaces().getMinimapInterface().getWaypointsGuiRenderer().drawSetChange(minimapSession.getWaypointsManager(), matrixStack, Minecraft.m_91087_().m_91268_());
                    if (OverlayRegistry.getEntry((IIngameOverlay)ForgeIngameGui.CROSSHAIR_ELEMENT).isEnabled() && minimapSession.getMinimapProcessor().isEnlargedMap() && InterfaceRenderer.this.modMain.getSettings().centeredEnlarged) {
                        OverlayRegistry.enableOverlay((IIngameOverlay)ForgeIngameGui.CROSSHAIR_ELEMENT, (boolean)false);
                        InterfaceRenderer.this.modMain.getEvents().crosshairDisabledByThisMod = true;
                    }
                }
                OldAnimation.tick();
            }
        };
        OverlayRegistry.registerOverlayAbove((IIngameOverlay)ForgeIngameGui.SPYGLASS_ELEMENT, (String)"xaero", (IIngameOverlay)this.overlay);
    }
}

