/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.scores.Team;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.effect.Effects;
import xaero.common.minimap.MinimapProcessor;
import xaero.common.settings.ModSettings;

public class MinimapRadar {
    public static final int radarPlayers = -1;
    public static final int radarShadow = -16777216;
    private IXaeroMinimap modMain;
    private XaeroMinimapSession minimapSession;
    private ArrayList<Entity> players;
    private ArrayList<Entity> living;
    private ArrayList<Entity> livingTamed;
    private ArrayList<Entity> hostile;
    private ArrayList<Entity> items;
    private ArrayList<Entity> entities;
    private ArrayList<Entity> playersOtherTeams;
    public EntityDataAccessor<Optional<UUID>> FOX_TRUSTED_UUID_SECONDARY;
    public EntityDataAccessor<Optional<UUID>> FOX_TRUSTED_UUID_MAIN;
    private Entity lastRenderViewEntity;

    public MinimapRadar(IXaeroMinimap modMain, XaeroMinimapSession minimapSession) {
        this.modMain = modMain;
        this.minimapSession = minimapSession;
        this.players = new ArrayList();
        this.living = new ArrayList();
        this.livingTamed = new ArrayList();
        this.hostile = new ArrayList();
        this.items = new ArrayList();
        this.entities = new ArrayList();
        this.playersOtherTeams = new ArrayList();
        Field foxTrustSecondaryField = null;
        Field foxTrustMainField = null;
        try {
            foxTrustSecondaryField = Fox.class.getDeclaredField("f_28439_");
        }
        catch (Exception e) {
            try {
                foxTrustSecondaryField = Fox.class.getDeclaredField("DATA_TRUSTED_ID_0");
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        try {
            foxTrustMainField = Fox.class.getDeclaredField("f_28440_");
        }
        catch (Exception e) {
            try {
                foxTrustMainField = Fox.class.getDeclaredField("DATA_TRUSTED_ID_1");
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        if (foxTrustSecondaryField != null) {
            try {
                boolean accessibleBU = foxTrustSecondaryField.isAccessible();
                foxTrustSecondaryField.setAccessible(true);
                this.FOX_TRUSTED_UUID_SECONDARY = (EntityDataAccessor)foxTrustSecondaryField.get(null);
                foxTrustSecondaryField.setAccessible(accessibleBU);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (foxTrustMainField != null) {
            try {
                boolean accessibleBU = foxTrustMainField.isAccessible();
                foxTrustMainField.setAccessible(true);
                this.FOX_TRUSTED_UUID_MAIN = (EntityDataAccessor)foxTrustMainField.get(null);
                foxTrustMainField.setAccessible(accessibleBU);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public int getType(Entity e, Player p, boolean ignoreTamed) {
        if (e instanceof Player) {
            if (p.m_5647_() != ((Player)e).m_5647_()) {
                return 6;
            }
            return 1;
        }
        if (!ignoreTamed && this.isTamed(e, p)) {
            return 7;
        }
        if (e.getPersistentData().m_128441_("hostileMinimap") ? e.getPersistentData().m_128471_("hostileMinimap") : Minecraft.m_91087_().f_91073_.m_46791_() != Difficulty.PEACEFUL && !this.hostileException(e) && (e instanceof Monster || e instanceof Enemy || e.m_5720_() == SoundSource.HOSTILE)) {
            return 2;
        }
        if (e instanceof LivingEntity) {
            return 3;
        }
        if (e instanceof ItemEntity) {
            return 4;
        }
        return 0;
    }

    public void updateRadar(ClientLevel world, Player p, Entity renderEntity, MinimapProcessor minimap) {
        if (renderEntity == null) {
            renderEntity = this.lastRenderViewEntity;
        }
        this.players.clear();
        this.hostile.clear();
        this.living.clear();
        this.items.clear();
        this.entities.clear();
        this.playersOtherTeams.clear();
        this.livingTamed.clear();
        if (world == null || p == null || renderEntity == null || p.m_21023_(Effects.NO_RADAR) || p.m_21023_(Effects.NO_RADAR_BENEFICIAL) || p.m_21023_(Effects.NO_RADAR_HARMFUL)) {
            return;
        }
        Iterable worldEntities = world.m_104735_();
        ModSettings settings = this.modMain.getSettings();
        int cullingSize = minimap.getMinimapSize() / 2 + 48;
        double maxDistance = (double)(cullingSize * cullingSize) / (minimap.getMinimapZoom() * minimap.getMinimapZoom());
        for (Entity e : worldEntities) {
            if (e.f_19797_ <= 0) continue;
            try {
                int type = this.getType(e, p, false);
                if (type == 1 ? e != p && !settings.getShowPlayers() : (type == 2 ? !settings.getShowHostile() : (type == 3 ? !settings.getShowMobs() : (type == 4 ? !settings.getShowItems() : (type == 6 ? !settings.getShowOtherTeam() : (type == 7 ? !settings.getShowTamedMobs() : !settings.getShowOther() || e instanceof ItemFrame && !settings.itemFramesOnRadar)))))) continue;
                double offx = e.m_20185_() - renderEntity.m_20185_();
                double offy = e.m_20189_() - renderEntity.m_20189_();
                double offh = renderEntity.m_20186_() - e.m_20186_();
                double offheight2 = offh * offh;
                double offx2 = offx * offx;
                double offy2 = offy * offy;
                if (offx2 > maxDistance || offy2 > maxDistance || offheight2 > (double)(settings.heightLimit * settings.heightLimit)) continue;
                ArrayList<Entity> typeList = this.entities;
                switch (type) {
                    case 1: {
                        typeList = this.players;
                        break;
                    }
                    case 2: {
                        typeList = this.hostile;
                        break;
                    }
                    case 3: {
                        typeList = this.living;
                        break;
                    }
                    case 4: {
                        typeList = this.items;
                        break;
                    }
                    case 6: {
                        typeList = this.playersOtherTeams;
                        break;
                    }
                    case 7: {
                        typeList = this.livingTamed;
                    }
                }
                if (settings.entityAmount != 0 && typeList.size() >= 100 * settings.entityAmount) continue;
                typeList.add(e);
            }
            catch (Exception ex) {}
        }
    }

    private boolean hostileException(Entity e) {
        if (e instanceof Piglin) {
            return ((Piglin)e).m_6162_();
        }
        return false;
    }

    public double getEntityX(Entity e, float partial) {
        return e.f_19790_ + (e.m_20185_() - e.f_19790_) * (double)partial;
    }

    public double getEntityY(Entity e, float partial) {
        return e.f_19791_ + (e.m_20186_() - e.f_19791_) * (double)partial;
    }

    public double getEntityZ(Entity e, float partial) {
        return e.f_19792_ + (e.m_20189_() - e.f_19792_) * (double)partial;
    }

    public boolean shouldRenderEntity(Entity e, Entity renderEntity) {
        return e == renderEntity || !e.m_6144_() && !e.m_20145_();
    }

    public int getPlayerTeamColour(Player p) {
        Integer teamColour = null;
        Team team = p.m_5647_();
        if (team != null) {
            teamColour = team.m_7414_().m_126665_();
        }
        return teamColour == null ? -1 : teamColour;
    }

    public int getEntityColour(Player p, Entity e, float offh, boolean cave, ModSettings settings) {
        int entityTeamColour;
        int type = this.getType(e, p, settings.tamedMobsColor == -1);
        if (type == 6 && settings.otherTeamColor == -1) {
            type = 1;
        }
        int color = type == 1 ? (settings.playersColor != -1 ? ModSettings.COLORS[settings.playersColor] : ((entityTeamColour = this.getPlayerTeamColour((Player)e)) != -1 ? entityTeamColour : -1)) : (type == 2 ? ModSettings.COLORS[settings.hostileColor] : (type == 3 ? ModSettings.COLORS[settings.mobsColor] : (type == 4 ? ModSettings.COLORS[settings.itemsColor] : (type == 6 ? ModSettings.COLORS[settings.otherTeamColor] : (type == 7 ? ModSettings.COLORS[settings.tamedMobsColor] : ModSettings.COLORS[settings.otherColor])))));
        float brightness = this.getEntityBrightness(offh, settings);
        if (brightness < 1.0f) {
            int r = color >> 16 & 0xFF;
            int g = color >> 8 & 0xFF;
            int b = color & 0xFF;
            int a = 255;
            if (cave) {
                a = (int)((float)a * brightness);
            } else {
                r = (int)((float)r * brightness);
                g = (int)((float)g * brightness);
                b = (int)((float)b * brightness);
            }
            color = a << 24 | r << 16 | g << 8 | b;
        }
        return color;
    }

    public float getEntityBrightness(float offh, ModSettings settings) {
        float level = (float)settings.heightLimit - offh;
        if (level < 0.0f) {
            level = 0.0f;
        }
        float brightness = 1.0f;
        if (level <= (float)(settings.heightLimit / 2) && settings.showEntityHeight) {
            brightness = 0.25f + 0.5f * level / (float)settings.heightLimit;
        }
        return brightness;
    }

    public Iterator<Entity> getEntitiesIterator() {
        return this.entities.iterator();
    }

    public Iterator<Entity> getItemsIterator() {
        return this.items.iterator();
    }

    public Iterator<Entity> getLivingIterator() {
        return this.living.iterator();
    }

    public Iterator<Entity> getLivingTamedIterator() {
        return this.livingTamed.iterator();
    }

    public Iterator<Entity> getHostileIterator() {
        return this.hostile.iterator();
    }

    public Iterator<Entity> getPlayersIterator() {
        return this.players.iterator();
    }

    public Iterator<Entity> getPlayersOtherTeamsIterator() {
        return this.playersOtherTeams.iterator();
    }

    private boolean isTamed(Entity e, Player p) {
        if (e instanceof TamableAnimal) {
            TamableAnimal tameable = (TamableAnimal)e;
            if (tameable.m_21824_() && p.m_142081_().equals(tameable.m_142504_())) {
                return true;
            }
        } else if (e instanceof AbstractHorse) {
            AbstractHorse horse = (AbstractHorse)e;
            if (horse.m_30614_() && p.m_142081_().equals(horse.m_30615_())) {
                return true;
            }
        } else if (e instanceof Fox) {
            Fox fox = (Fox)e;
            if (this.FOX_TRUSTED_UUID_SECONDARY != null && p.m_142081_().equals(((Optional)fox.m_20088_().m_135370_(this.FOX_TRUSTED_UUID_SECONDARY)).orElse(null))) {
                return true;
            }
            if (this.FOX_TRUSTED_UUID_MAIN != null && p.m_142081_().equals(((Optional)fox.m_20088_().m_135370_(this.FOX_TRUSTED_UUID_MAIN)).orElse(null))) {
                return true;
            }
        }
        return false;
    }

    public void setLastRenderViewEntity(Entity lastRenderViewEntity) {
        this.lastRenderViewEntity = lastRenderViewEntity;
    }
}

