/*
 * Decompiled with CFR 0.152.
 */
package com.dantaeusb.zetter.block;

import com.dantaeusb.zetter.Zetter;
import com.dantaeusb.zetter.core.ModItems;
import com.dantaeusb.zetter.network.packet.SCanvasNamePacket;
import com.dantaeusb.zetter.tileentity.EaselTileEntity;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class EaselBlock
extends ContainerBlock {
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.field_208163_P;
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    private static final VoxelShape UPPER_SHAPE = Block.func_208617_a((double)2.0, (double)0.0, (double)5.0, (double)14.0, (double)11.0, (double)10.0);
    private static final VoxelShape LOWER_SHAPE = Block.func_208617_a((double)2.0, (double)0.0, (double)3.0, (double)14.0, (double)15.0, (double)12.0);

    public EaselBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return this.func_196283_a_(world);
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader world) {
        return new EaselTileEntity();
    }

    public boolean hasTileEntity(BlockState state) {
        return state.func_177229_b(HALF) != DoubleBlockHalf.UPPER;
    }

    public BlockRenderType func_149645_b(BlockState iBlockState) {
        return BlockRenderType.INVISIBLE;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        EaselTileEntity easelTileEntity;
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        ItemStack heldItem = player.func_184586_b(Hand.MAIN_HAND);
        BlockPos tileEntityPos = pos;
        if (state.func_177229_b((Property)DoorBlock.field_176523_O) == DoubleBlockHalf.UPPER) {
            tileEntityPos = tileEntityPos.func_177977_b();
        }
        if ((easelTileEntity = (EaselTileEntity)world.func_175625_s(tileEntityPos)) == null) {
            return ActionResultType.FAIL;
        }
        if (!player.func_213453_ef()) {
            ItemStack easelCanvasStack = easelTileEntity.getEaselStorage().getCanvasStack();
            if (easelCanvasStack.func_190926_b() && heldItem.func_77973_b() == ModItems.CANVAS && easelTileEntity.putCanvasStack(heldItem)) {
                player.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
                world.func_184138_a(tileEntityPos, state, state, 2);
                return ActionResultType.SUCCESS;
            }
            INamedContainerProvider namedContainerProvider = this.func_220052_b(state, world, tileEntityPos);
            if (namedContainerProvider != null) {
                if (!(player instanceof ServerPlayerEntity)) {
                    return ActionResultType.FAIL;
                }
                ServerPlayerEntity serverPlayerEntity = (ServerPlayerEntity)player;
                BlockPos finalTileEntityPos = tileEntityPos;
                NetworkHooks.openGui((ServerPlayerEntity)serverPlayerEntity, (INamedContainerProvider)namedContainerProvider, packetBuffer -> this.writeCanvasIdToNetwork(state, world, finalTileEntityPos, player, (PacketBuffer)packetBuffer));
            }
            return ActionResultType.SUCCESS;
        }
        if (heldItem.func_190926_b()) {
            ItemStack canvasStack = easelTileEntity.getEaselStorage().extractCanvas();
            world.func_184138_a(tileEntityPos, state, state, 2);
            if (canvasStack.func_190926_b()) {
                return ActionResultType.FAIL;
            }
            player.func_184611_a(Hand.MAIN_HAND, canvasStack);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return true;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{HALF, FACING});
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.func_203425_a(newState.func_177230_c())) {
            TileEntity tileEntity = world.func_175625_s(pos);
            if (tileEntity instanceof EaselTileEntity) {
                InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)((EaselTileEntity)tileEntity).getEaselStorage());
                world.func_175666_e(pos, (Block)this);
            }
            super.func_196243_a(state, world, pos, newState, isMoving);
        }
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos blockpos = context.func_195995_a();
        if (blockpos.func_177956_o() < 255 && context.func_195991_k().func_180495_p(blockpos.func_177984_a()).func_196953_a(context)) {
            return (BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f())).func_206870_a(HALF, (Comparable)DoubleBlockHalf.LOWER)).func_206870_a((Property)FACING, (Comparable)context.func_195992_f());
        }
        return null;
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        DoubleBlockHalf doubleBlockHalf = (DoubleBlockHalf)state.func_177229_b(HALF);
        if (facing.func_176740_k() == Direction.Axis.Y && doubleBlockHalf == DoubleBlockHalf.LOWER == (facing == Direction.UP) && !facingState.func_203425_a((Block)this)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return doubleBlockHalf == DoubleBlockHalf.LOWER && !state.func_196955_c((IWorldReader)world, currentPos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(state, facing, facingState, world, currentPos, facingPos);
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.func_177977_b();
        BlockState blockstate = worldIn.func_180495_p(blockpos);
        return state.func_177229_b(HALF) == DoubleBlockHalf.LOWER ? blockstate.func_224755_d((IBlockReader)worldIn, blockpos, Direction.UP) : blockstate.func_203425_a((Block)this);
    }

    protected void writeCanvasIdToNetwork(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, PacketBuffer networkBuffer) {
        TileEntity easelTileEntity = worldIn.func_175625_s(pos);
        if (!(easelTileEntity instanceof EaselTileEntity)) {
            Zetter.LOG.error("Cannot find EaselTileEntity to send canvas data to client");
            return;
        }
        SCanvasNamePacket.writeCanvasName(networkBuffer, ((EaselTileEntity)easelTileEntity).getCanvasName());
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        worldIn.func_180501_a(pos.func_177984_a(), (BlockState)state.func_206870_a(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        if (state.func_177229_b(HALF) == DoubleBlockHalf.UPPER) {
            return EaselBlock.rotateShape(Direction.NORTH, (Direction)state.func_177229_b((Property)FACING), UPPER_SHAPE);
        }
        return EaselBlock.rotateShape(Direction.NORTH, (Direction)state.func_177229_b((Property)FACING), LOWER_SHAPE);
    }

    public static VoxelShape rotateShape(Direction from, Direction to, VoxelShape shape) {
        VoxelShape[] buffer = new VoxelShape[]{shape, VoxelShapes.func_197880_a()};
        int times = (to.func_176736_b() - from.func_176736_b() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].func_197755_b((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = VoxelShapes.func_197872_a((VoxelShape)buffer[1], (VoxelShape)VoxelShapes.func_197873_a((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX));
            });
            buffer[0] = buffer[1];
            buffer[1] = VoxelShapes.func_197880_a();
        }
        return buffer[0];
    }
}

