/*
 * Decompiled with CFR 0.152.
 */
package com.dantaeusb.zetter.canvastracker;

import com.dantaeusb.zetter.Zetter;
import com.dantaeusb.zetter.canvastracker.CanvasDefaultTracker;
import com.dantaeusb.zetter.core.ModNetwork;
import com.dantaeusb.zetter.network.packet.SCanvasSyncMessage;
import com.dantaeusb.zetter.storage.AbstractCanvasData;
import com.dantaeusb.zetter.storage.CanvasData;
import com.dantaeusb.zetter.storage.DummyCanvasData;
import com.dantaeusb.zetter.storage.PaintingData;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.Vector;
import javax.annotation.Nullable;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fml.network.PacketDistributor;

public class CanvasServerTracker
extends CanvasDefaultTracker {
    private final World world;
    private int lastCanvasId;
    private int lastPaintingId;
    private final Map<String, Vector<PlayerTrackingCanvas>> trackedCanvases = new HashMap<String, Vector<PlayerTrackingCanvas>>();
    private final Vector<String> desyncCanvases = new Vector();
    private int ticksFromLastSync = 0;

    public CanvasServerTracker(World world) {
        this.world = world;
        this.lastCanvasId = 0;
        this.lastPaintingId = 0;
    }

    @Override
    public World getWorld() {
        return this.world;
    }

    @Override
    public int getNextCanvasId() {
        return ++this.lastCanvasId;
    }

    @Override
    public int getLastCanvasId() {
        return this.lastCanvasId;
    }

    @Override
    public void setLastCanvasId(int id) {
        this.lastCanvasId = id;
    }

    @Override
    public int getNextPaintingId() {
        return ++this.lastPaintingId;
    }

    @Override
    public int getLastPaintingId() {
        return this.lastPaintingId;
    }

    @Override
    public void setLastPaintingId(int id) {
        this.lastPaintingId = id;
    }

    public void markCanvasDesync(String canvasCode) {
        this.desyncCanvases.add(canvasCode);
    }

    @Override
    @Nullable
    public <T extends AbstractCanvasData> T getCanvasData(String canvasCode, @Nullable Class<T> type) {
        return (T)((Object)((AbstractCanvasData)this.world.func_73046_m().func_241755_D_().func_217481_x().func_215753_b(() -> {
            if (type.equals(CanvasData.class)) {
                return new CanvasData(canvasCode);
            }
            if (type.equals(PaintingData.class)) {
                return new PaintingData(canvasCode);
            }
            return new DummyCanvasData(canvasCode);
        }, canvasCode)));
    }

    @Override
    public void registerCanvasData(AbstractCanvasData canvasData) {
        if (canvasData instanceof DummyCanvasData) {
            Zetter.LOG.error("Trying to register dummy canvas on server side");
            return;
        }
        this.world.func_73046_m().func_241755_D_().func_217481_x().func_215757_a((WorldSavedData)canvasData);
    }

    public void tick() {
        ++this.ticksFromLastSync;
        if (this.ticksFromLastSync < 20) {
            return;
        }
        MinecraftServer server = this.world.func_73046_m();
        for (String canvasCode : this.desyncCanvases) {
            for (PlayerTrackingCanvas playerTrackingCanvas : this.getTrackingEntries(canvasCode)) {
                ServerPlayerEntity playerEntity = server.func_184103_al().func_177451_a(playerTrackingCanvas.playerId);
                SCanvasSyncMessage canvasSyncMessage = new SCanvasSyncMessage(this.getCanvasData(canvasCode, DummyCanvasData.class), System.currentTimeMillis());
                ModNetwork.simpleChannel.send(PacketDistributor.PLAYER.with(() -> playerEntity), (Object)canvasSyncMessage);
            }
        }
        this.desyncCanvases.clear();
        this.ticksFromLastSync = 0;
    }

    public void trackCanvas(UUID playerId, String canvasName) {
        Vector<PlayerTrackingCanvas> trackingEntries = this.getTrackingEntries(canvasName);
        for (PlayerTrackingCanvas playerTrackingCanvas : trackingEntries) {
            if (playerTrackingCanvas.playerId != playerId) continue;
            return;
        }
        trackingEntries.add(new PlayerTrackingCanvas(playerId, canvasName));
    }

    public void stopTrackingCanvas(UUID playerId, String canvasName) {
        Vector<PlayerTrackingCanvas> trackingEntries = this.getTrackingEntries(canvasName);
        trackingEntries.removeIf(entry -> entry.playerId == playerId);
    }

    public void stopTrackingAllCanvases(UUID playerId) {
        for (String canvasName : this.trackedCanvases.keySet()) {
            this.stopTrackingCanvas(playerId, canvasName);
        }
    }

    private Vector<PlayerTrackingCanvas> getTrackingEntries(String canvasName) {
        return this.trackedCanvases.computeIfAbsent(canvasName, k -> new Vector());
    }

    private static class PlayerTrackingCanvas {
        public final UUID playerId;
        public final String canvasName;

        PlayerTrackingCanvas(UUID playerId, String canvasName) {
            this.playerId = playerId;
            this.canvasName = canvasName;
        }
    }
}

